/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dtb;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.dtb.FdtNodeHeader;
import ghidra.file.formats.dtb.FdtProperty;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class FdtHeader
implements StructConverter {
    private static final int OFF_DT_STRUCT_INDEX = 2;
    private static final int OFF_DT_STRINGS_INDEX = 3;
    private static final int OFF_MEM_RSVMAP_INDEX = 4;
    private int magic;
    private int totalsize;
    private int off_dt_struct;
    private int off_dt_strings;
    private int off_mem_rsvmap;
    private int version;
    private int last_comp_version;
    private int boot_cpuid_phys;
    private int size_dt_strings;
    private int size_dt_struct;
    private Map<Integer, String> stringsMap = new HashMap<Integer, String>();

    public FdtHeader(BinaryReader reader) throws IOException {
        if (!reader.isBigEndian()) {
            throw new IOException("FTD is always big endian.");
        }
        this.magic = reader.readNextInt();
        if (this.magic != -804389139) {
            throw new IOException("Invalid FDT Header magic.");
        }
        this.totalsize = reader.readNextInt();
        this.off_dt_struct = reader.readNextInt();
        this.off_dt_strings = reader.readNextInt();
        this.off_mem_rsvmap = reader.readNextInt();
        this.version = reader.readNextInt();
        this.last_comp_version = reader.readNextInt();
        if (this.version >= 2) {
            this.boot_cpuid_phys = reader.readNextInt();
        }
        if (this.version >= 3) {
            this.size_dt_strings = reader.readNextInt();
        }
        if (this.version == 17) {
            this.size_dt_struct = reader.readNextInt();
        }
        if (this.version > 17) {
            throw new IOException("Unsupported FDT Header version: " + this.version);
        }
    }

    public int getMagic() {
        return this.magic;
    }

    public int getTotalSize() {
        return this.totalsize;
    }

    public int getOffsetToDtStruct() {
        return this.off_dt_struct;
    }

    public int getOffsetToDtStrings() {
        return this.off_dt_strings;
    }

    public int getOffsetToMemoryReserveMap() {
        return this.off_mem_rsvmap;
    }

    public int getVersion() {
        return this.version;
    }

    public int getLastCompatibleVersion() {
        return this.last_comp_version;
    }

    public int getBootCpuIdPhysical() {
        return this.boot_cpuid_phys;
    }

    public int getSizeDtStrings() {
        return this.size_dt_strings;
    }

    public int getSizeDtStruct() {
        return this.size_dt_struct;
    }

    public void markup(Address fdtHeaderAddress, Program program, TaskMonitor monitor, MessageLog log) throws Exception {
        FlatProgramAPI programAPI = new FlatProgramAPI(program);
        DataType fdtHeaderDataType = this.toDataType();
        Data fdtHeaderData = program.getListing().createData(fdtHeaderAddress, fdtHeaderDataType);
        programAPI.createFragment(fdtHeaderData.getDataType().getName(), fdtHeaderAddress, (long)fdtHeaderData.getLength());
        this.markupStrings(fdtHeaderAddress, fdtHeaderData, programAPI, monitor);
        this.markupStructure(fdtHeaderAddress, fdtHeaderData, programAPI, monitor);
        this.markupMemoryReserveMap(fdtHeaderAddress, fdtHeaderData, programAPI, monitor);
    }

    private void markupStructure(Address fdtHeaderAddress, Data fdtHeaderData, FlatProgramAPI programAPI, TaskMonitor monitor) throws IOException, DuplicateNameException, CodeUnitInsertionException, NotFoundException {
        Address structAddress = fdtHeaderAddress.add((long)this.getOffsetToDtStruct());
        Data structsData = fdtHeaderData.getComponent(2);
        programAPI.createMemoryReference(structsData, structAddress, RefType.DATA);
        this.markupStructureContents(structAddress, programAPI, monitor);
    }

    private void markupStructureContents(Address address, FlatProgramAPI programAPI, TaskMonitor monitor) throws IOException, DuplicateNameException, CodeUnitInsertionException, NotFoundException {
        Program currentProgram = programAPI.getCurrentProgram();
        MemoryByteProvider provider = new MemoryByteProvider(currentProgram.getMemory(), address);
        BinaryReader reader = new BinaryReader((ByteProvider)provider, !currentProgram.getLanguage().isBigEndian());
        while (!monitor.isCancelled()) {
            DWordDataType dWordDataType = new DWordDataType();
            switch (reader.peekNextInt()) {
                case 1: {
                    FdtNodeHeader nodeHeader = new FdtNodeHeader(reader);
                    DataType nodeHeaderDataType = nodeHeader.toDataType();
                    programAPI.createData(address, nodeHeaderDataType);
                    programAPI.createFragment("FDT_BEGIN_NODE", address, (long)nodeHeaderDataType.getLength());
                    programAPI.setPlateComment(address, "FDT_BEGIN_NODE: " + nodeHeader.getName());
                    address = address.add((long)nodeHeaderDataType.getLength());
                    break;
                }
                case 2: {
                    reader.readNextInt();
                    programAPI.createData(address, (DataType)dWordDataType);
                    programAPI.createFragment("FDT_END_NODE", address, (long)dWordDataType.getLength());
                    programAPI.setPlateComment(address, "FDT_END_NODE");
                    address = address.add(4L);
                    break;
                }
                case 3: {
                    FdtProperty property = new FdtProperty(reader);
                    DataType propertyDataType = property.toDataType();
                    programAPI.createData(address, propertyDataType);
                    programAPI.createFragment("FDT_PROP", address, (long)propertyDataType.getLength());
                    programAPI.setPlateComment(address, "FDT_PROP: \n" + this.getString(property) + " = " + property.getDataAsString());
                    address = address.add((long)propertyDataType.getLength());
                    break;
                }
                case 4: {
                    reader.readNextInt();
                    programAPI.createData(address, (DataType)dWordDataType);
                    programAPI.createFragment("FDT_NOP", address, (long)dWordDataType.getLength());
                    programAPI.setPlateComment(address, "FDT_NOP");
                    address = address.add(4L);
                    break;
                }
                case 9: {
                    reader.readNextInt();
                    programAPI.createData(address, (DataType)dWordDataType);
                    programAPI.createFragment("FDT_END", address, (long)dWordDataType.getLength());
                    programAPI.setPlateComment(address, "FDT_END");
                    address = address.add(4L);
                    return;
                }
            }
        }
    }

    private void markupStrings(Address fdtHeaderAddress, Data fdtHeaderData, FlatProgramAPI programAPI, TaskMonitor monitor) throws Exception {
        Address stringsAddress = fdtHeaderAddress.add((long)this.getOffsetToDtStrings());
        Data stringsData = fdtHeaderData.getComponent(3);
        programAPI.createMemoryReference(stringsData, stringsAddress, RefType.DATA);
        int stringSize = 0;
        while (!monitor.isCancelled()) {
            Data stringData = programAPI.createData(stringsAddress, (DataType)StringDataType.dataType);
            programAPI.createFragment(StringDataType.dataType.getName(), stringsAddress, (long)stringData.getLength());
            String string = (String)stringData.getValue();
            this.storeString(fdtHeaderAddress, stringsAddress, string);
            stringsAddress = stringsAddress.add((long)stringData.getLength());
            if ((stringSize += stringData.getLength()) < this.getSizeDtStrings()) continue;
            break;
        }
    }

    private void markupMemoryReserveMap(Address fdtHeaderAddress, Data fdtHeaderData, FlatProgramAPI programAPI, TaskMonitor monitor) {
        Address structAddress = fdtHeaderAddress.add((long)this.getOffsetToMemoryReserveMap());
        Data structsData = fdtHeaderData.getComponent(4);
        programAPI.createMemoryReference(structsData, structAddress, RefType.DATA);
    }

    private void storeString(Address fdtHeaderAddress, Address stringsAddress, String string) {
        long index = stringsAddress.getOffset() - fdtHeaderAddress.getOffset() - (long)this.off_dt_strings;
        this.stringsMap.put((int)index, string);
    }

    private String getString(FdtProperty property) {
        return this.stringsMap.getOrDefault(property.getNameOffset(), "");
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("fdt_header", 0);
        structure.add(DWORD, "magic", null);
        structure.add(DWORD, "totalsize", null);
        structure.add(DWORD, "off_dt_struct", null);
        structure.add(DWORD, "off_dt_strings", null);
        structure.add(DWORD, "off_mem_rsvmap", null);
        structure.add(DWORD, "version", null);
        structure.add(DWORD, "last_comp_version", null);
        if (this.version >= 2) {
            structure.add(DWORD, "boot_cpuid_phys", null);
        }
        if (this.version >= 3) {
            structure.add(DWORD, "size_dt_strings", null);
        }
        if (this.version >= 17) {
            structure.add(DWORD, "size_dt_struct", null);
        }
        return structure;
    }
}

