/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.repulsion;

import org.jungrapht.visualization.layout.algorithms.repulsion.BarnesHutRepulsion;
import org.jungrapht.visualization.layout.algorithms.repulsion.StandardFA2Repulsion;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.quadtree.BarnesHutQuadTree;
import org.jungrapht.visualization.layout.quadtree.ForceObject;

public class BarnesHutFA2Repulsion<V>
extends StandardFA2Repulsion<V, BarnesHutFA2Repulsion<V>, Builder<V>>
implements BarnesHutRepulsion<V, BarnesHutFA2Repulsion<V>, Builder<V>> {
    private BarnesHutQuadTree<V> tree;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static Builder barnesHutBuilder() {
        return BarnesHutFA2Repulsion.builder();
    }

    protected BarnesHutFA2Repulsion(Builder<V> builder) {
        super(builder);
        this.tree = builder.tree;
    }

    @Override
    public void step() {
        this.tree.rebuild(this.layoutModel.getGraph().vertexSet(), this.nodeMasses::get, this.layoutModel);
    }

    @Override
    public void calculateRepulsion() {
        for (final Object vertex : this.vertexSet) {
            Point forcePoint = (Point)this.layoutModel.apply(vertex);
            final double vertexOneSize = (Double)this.nodeSizes.apply(vertex);
            ForceObject forceObject = new ForceObject<V>(vertex, forcePoint, (Double)this.nodeMasses.get(vertex)){

                @Override
                protected void addForceFrom(ForceObject other) {
                    double force;
                    double dx = this.p.x - other.p.x;
                    double dy = this.p.y - other.p.y;
                    double otherMass = other.getMass();
                    double dist = Math.max(1.0E-16, Math.sqrt(dx * dx + dy * dy));
                    if (Double.isNaN(force = Double.compare(dist -= vertexOneSize + (Double)BarnesHutFA2Repulsion.this.nodeSizes.apply(vertex), 0.0) == 0 ? 0.0 : (dist > 0.0 ? BarnesHutFA2Repulsion.this.kr * this.mass * otherMass / dist / dist : BarnesHutFA2Repulsion.this.kr * this.mass * otherMass / dist))) {
                        throw new RuntimeException("Unexpected mathematical result in FRLayout:calcPositions [repulsion]");
                    }
                    this.f = this.f.add(force * dx, force * dy);
                }
            };
            this.tree.applyForcesTo(forceObject);
            this.frVertexData.put(vertex, Point.of(forceObject.f.x, forceObject.f.y));
        }
    }

    public static class Builder<V>
    extends StandardFA2Repulsion.Builder<V, BarnesHutFA2Repulsion<V>, Builder<V>>
    implements BarnesHutRepulsion.Builder<V, BarnesHutFA2Repulsion<V>, Builder<V>> {
        private double theta = 0.5;
        private BarnesHutQuadTree<V> tree;

        @Override
        public Builder<V> layoutModel(LayoutModel<V> layoutModel) {
            this.layoutModel = layoutModel;
            this.tree = BarnesHutQuadTree.builder().bounds(layoutModel.getWidth(), layoutModel.getHeight()).theta(this.theta).build();
            return this;
        }

        @Override
        public Builder<V> theta(double theta) {
            this.theta = theta;
            return this;
        }

        @Override
        public BarnesHutFA2Repulsion build() {
            return new BarnesHutFA2Repulsion(this);
        }
    }
}

