/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.decorators;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;

public class GradientEdgePaintFunction<V, E>
implements Function<E, Paint> {
    protected VisualizationServer<V, E> visualizationServer;
    protected Function<E, Paint> originalEdgePaintFunction;

    public GradientEdgePaintFunction(VisualizationServer<V, E> visualizationServer) {
        this.visualizationServer = visualizationServer;
        this.originalEdgePaintFunction = visualizationServer.getRenderContext().getEdgeDrawPaintFunction();
    }

    @Override
    public Paint apply(E edge) {
        LayoutModel<V> layoutModel = this.visualizationServer.getVisualizationModel().getLayoutModel();
        Graph graph = layoutModel.getGraph();
        MultiLayerTransformer transformer = this.visualizationServer.getRenderContext().getMultiLayerTransformer();
        Object source = graph.getEdgeSource(edge);
        Object target = graph.getEdgeTarget(edge);
        Point sourcePoint = (Point)layoutModel.apply(source);
        Point targetPoint = (Point)layoutModel.apply(target);
        Point2D sourceInView = transformer.transform(MultiLayerTransformer.Layer.LAYOUT, sourcePoint.x, sourcePoint.y);
        Point2D targetInView = transformer.transform(MultiLayerTransformer.Layer.LAYOUT, targetPoint.x, targetPoint.y);
        Color edgeColor = (Color)this.originalEdgePaintFunction.apply(edge);
        if (Color.black.equals(edgeColor)) {
            return new GradientPaint(sourceInView, Color.lightGray.brighter(), targetInView, Color.black);
        }
        return new GradientPaint(sourceInView, edgeColor.brighter().brighter(), targetInView, edgeColor.darker().darker());
    }
}

