/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.AbstractGCellRenderer;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.RowObjectTableModel;
import generic.theme.GColor;
import generic.theme.Gui;
import generic.theme.ThemeListener;
import ghidra.docking.settings.FloatingPointPrecisionSettingsDefinition;
import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.IntegerSignednessFormattingModeSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.util.NumericUtilities;
import ghidra.util.SignednessFormatMode;
import ghidra.util.StringUtilities;
import ghidra.util.exception.AssertException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class GTableCellRenderer
extends AbstractGCellRenderer
implements TableCellRenderer {
    protected static final FormatSettingsDefinition INTEGER_RADIX_SETTING = FormatSettingsDefinition.DEF_DECIMAL;
    protected static final IntegerSignednessFormattingModeSettingsDefinition INTEGER_SIGNEDNESS_MODE_SETTING = IntegerSignednessFormattingModeSettingsDefinition.DEF;
    protected static final FloatingPointPrecisionSettingsDefinition FLOATING_POINT_PRECISION_SETTING = FloatingPointPrecisionSettingsDefinition.DEF;
    private static final Color BG_DRAG = new GColor("color.bg.table.row.drag");
    private static Map<Integer, ThreadLocal<DecimalFormat>> decimalFormatCache = new HashMap<Integer, ThreadLocal<DecimalFormat>>();
    private ThemeListener themeListener = e -> {
        if (e.isLookAndFeelChanged()) {
            this.updateUI();
        }
    };

    public GTableCellRenderer() {
        Gui.addThemeListener((ThemeListener)this.themeListener);
    }

    public GTableCellRenderer(Font f) {
        this();
        this.setFont(f);
    }

    protected String getText(Object value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(table instanceof GTable)) {
            throw new AssertException("Using a GTableCellRenderer in a non-GTable table. (Model class: " + table.getModel().getClass().getName() + ")");
        }
        GTable gTable = (GTable)table;
        GTableCellRenderingData data = gTable.getRenderingData(column);
        Object rowObject = null;
        if (gTable.getModel() instanceof RowObjectTableModel) {
            rowObject = ((RowObjectTableModel)gTable.getModel()).getRowObject(row);
        }
        data.setRowData(row, rowObject);
        data.setCellData(value, column, isSelected, hasFocus);
        Component renderComponent = this.getTableCellRendererComponent(data);
        data.resetRowData();
        return renderComponent;
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        Object value = data.getValue();
        JTable table = data.getTable();
        int row = data.getRowViewIndex();
        boolean isSelected = data.isSelected();
        boolean hasFocus = data.hasFocus();
        Settings settings = data.getColumnSettings();
        if (value instanceof Number) {
            Number n = (Number)value;
            this.setHorizontalAlignment(4);
            this.setText(this.formatNumber(n, settings));
        } else {
            this.setText(this.getText(value));
            this.setHorizontalAlignment(2);
        }
        TableModel model = table.getModel();
        this.setFont(this.getDefaultFont());
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
            this.setOpaque(true);
        } else {
            this.setForegroundColor(table, model, value);
            if (row == this.dropRow) {
                this.setBackground(BG_DRAG);
            } else {
                this.setBackground(this.getAlternatingBackgroundColor(table, row));
            }
        }
        this.setBorder(hasFocus ? this.focusBorder : this.noFocusBorder);
        return this;
    }

    protected void setForegroundColor(JTable table, TableModel model, Object value) {
        this.setForeground(table.getForeground());
    }

    @Override
    protected Font getDefaultFont() {
        return this.defaultFont;
    }

    protected int getRadix(Settings settings) {
        return INTEGER_RADIX_SETTING.getRadix(settings);
    }

    protected SignednessFormatMode getSignMode(Settings settings) {
        return INTEGER_SIGNEDNESS_MODE_SETTING.getFormatMode(settings);
    }

    protected int getPrecision(Settings settings) {
        return FLOATING_POINT_PRECISION_SETTING.getPrecision(settings);
    }

    protected String formatNumber(Number value, Settings settings) {
        if (NumericUtilities.isIntegerType((Number)value)) {
            int radix = this.getRadix(settings);
            SignednessFormatMode signMode = this.getSignMode(settings);
            long number = value.longValue();
            return NumericUtilities.formatNumber((long)number, (int)radix, (SignednessFormatMode)signMode);
        }
        if (NumericUtilities.isFloatingPointType((Number)value)) {
            Double number = value.doubleValue();
            if (number.isNaN() || number.isInfinite()) {
                return Character.toString('\u221e');
            }
            int precision = this.getPrecision(settings);
            return this.getFormatter(precision).format(number);
        }
        if (value instanceof BigInteger) {
            int radix = this.getRadix(settings);
            return ((BigInteger)value).toString(radix);
        }
        if (value instanceof BigDecimal) {
            int precision = this.getPrecision(settings);
            DecimalFormat formatter = this.getFormatter(precision);
            formatter.format(value);
            return ((BigDecimal)value).toPlainString();
        }
        return value.toString();
    }

    private DecimalFormat getFormatter(int digitsPrecision) {
        int precision = Math.max(0, Math.min(digitsPrecision, FloatingPointPrecisionSettingsDefinition.MAX_PRECISION));
        ThreadLocal<DecimalFormat> localFormat = decimalFormatCache.get(precision);
        return localFormat.get();
    }

    private static String createDecimalFormat(int digitsPrecision) {
        if (digitsPrecision <= 0) {
            return "0";
        }
        return "0." + StringUtilities.pad((String)"", (char)'0', (int)digitsPrecision);
    }

    static {
        int n = FloatingPointPrecisionSettingsDefinition.MAX_PRECISION;
        int i = 0;
        while (i <= n) {
            int precision = i++;
            ThreadLocal<DecimalFormat> localFormatter = ThreadLocal.withInitial(() -> new DecimalFormat(GTableCellRenderer.createDecimalFormat(precision)));
            decimalFormatCache.put(precision, localFormatter);
        }
    }
}

