/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMInvalidAccessException;
import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSRatioValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.MediaQueryPredicate;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.om.MediaFeature;
import io.sf.carte.doc.style.css.om.MediaPredicate;
import io.sf.carte.doc.style.css.parser.AbstractMediaQuery;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.NumberValue;
import org.w3c.dom.DOMException;

abstract class MediaQueryImpl
extends AbstractMediaQuery {
    private static final long serialVersionUID = 1L;

    MediaQueryImpl() {
    }

    @Override
    protected void setMediaType(String mediaType) {
        super.setMediaType(mediaType);
    }

    @Override
    protected void setFeaturePredicate(BooleanCondition predicate) {
        super.setFeaturePredicate(predicate);
    }

    @Override
    protected void setNegative(boolean negative) {
        super.setNegative(negative);
    }

    @Override
    protected void setOnlyPrefix(boolean only) {
        super.setOnlyPrefix(only);
    }

    @Override
    protected boolean matchesPredicate(MediaQueryPredicate condition, CSSCanvas canvas) {
        if (condition.getPredicateType() == 1) {
            return condition instanceof MediaFeature && this.matchesFeaturePredicate((MediaFeature)condition, canvas);
        }
        return true;
    }

    private boolean matchesFeaturePredicate(MediaFeature predicate, CSSCanvas canvas) {
        String feature = predicate.getName();
        CSSTypedValue value = predicate.getValue();
        predicate.getRangeSecondValue();
        byte type = predicate.getRangeType();
        if (type == 0 && value == null) {
            return MediaQueryImpl.featureBooleanMatch(feature, canvas);
        }
        if (type == 0) {
            if (feature.startsWith("min-")) {
                if ((feature = feature.substring(4)).startsWith("device-")) {
                    feature = feature.substring(7);
                }
                return this.featureRangeMatch(feature, (byte)5, value, null, canvas);
            }
            if (feature.startsWith("max-")) {
                if ((feature = feature.substring(4)).startsWith("device-")) {
                    feature = feature.substring(7);
                }
                return this.featureRangeMatch(feature, (byte)3, value, null, canvas);
            }
            if (feature.startsWith("device-")) {
                feature = feature.substring(7);
            }
            if (!MediaQueryImpl.isRangeFeature(feature)) {
                return canvas.matchesFeature(feature, value);
            }
            return this.featureRangeMatch(feature, (byte)1, value, null, canvas);
        }
        return this.featureRangeMatch(feature, type, value, predicate.getRangeSecondValue(), canvas);
    }

    private static boolean featureBooleanMatch(String feature, CSSCanvas canvas) {
        if (MediaQueryImpl.isRangeFeature(feature)) {
            CSSTypedValue featured = canvas.getFeatureValue(feature);
            return !featured.isNumberZero();
        }
        return canvas.matchesFeature(feature, null);
    }

    private boolean featureRangeMatch(String feature, byte type, CSSTypedValue value, CSSTypedValue value2, CSSCanvas canvas) {
        float fval1;
        CSSTypedValue featured = canvas.getFeatureValue(feature);
        if (featured == null) {
            return false;
        }
        short unitype = featured.getUnitType();
        float featureValue = featured.getFloatValue(unitype);
        float fval2 = 0.0f;
        try {
            fval1 = this.valueInUnit(value, canvas, unitype);
        }
        catch (DOMException e) {
            return false;
        }
        if (type >= 6) {
            if (value2 == null) {
                return false;
            }
            try {
                fval2 = this.valueInUnit(value2, canvas, unitype);
            }
            catch (DOMException e) {
                return false;
            }
        }
        switch (type) {
            case 1: {
                return MediaQueryImpl.floatEquals(fval1, featureValue);
            }
            case 2: {
                return fval1 > featureValue;
            }
            case 3: {
                return fval1 >= featureValue;
            }
            case 4: {
                return fval1 < featureValue;
            }
            case 5: {
                return fval1 <= featureValue;
            }
            case 18: {
                return fval1 < featureValue && featureValue < fval2;
            }
            case 19: {
                return fval1 <= featureValue && featureValue < fval2;
            }
            case 26: {
                return fval1 < featureValue && featureValue <= fval2;
            }
            case 27: {
                return fval1 <= featureValue && featureValue <= fval2;
            }
            case 36: {
                return fval1 > featureValue && featureValue > fval2;
            }
            case 37: {
                return fval1 >= featureValue && featureValue > fval2;
            }
            case 44: {
                return fval1 > featureValue && featureValue >= fval2;
            }
            case 45: {
                return fval1 >= featureValue && featureValue >= fval2;
            }
        }
        return false;
    }

    private float valueInUnit(CSSTypedValue value, CSSCanvas canvas, short primitype) throws DOMException {
        float fval;
        switch (value.getPrimitiveType()) {
            case EXPRESSION: {
                CSSExpressionValue evalue = (CSSExpressionValue)value;
                MQEvaluator ev = new MQEvaluator(canvas);
                fval = ev.evaluateExpression(evalue).getFloatValue(primitype);
                break;
            }
            case RATIO: {
                float fsecond;
                MQEvaluator ev;
                float ffirst;
                CSSRatioValue ratio = (CSSRatioValue)value;
                CSSPrimitiveValue first = ratio.getAntecedentValue();
                CSSPrimitiveValue second = ratio.getConsequentValue();
                if (first.getUnitType() == 0) {
                    ffirst = ((CSSTypedValue)first).getFloatValue();
                } else {
                    ev = new MQEvaluator(canvas);
                    ffirst = ev.evaluateExpression((CSSExpressionValue)first).getFloatValue((short)0);
                }
                if (second.getUnitType() == 0) {
                    fsecond = ((CSSTypedValue)second).getFloatValue();
                } else {
                    ev = new MQEvaluator(canvas);
                    fsecond = ev.evaluateExpression((CSSExpressionValue)second).getFloatValue((short)0);
                }
                fval = ffirst / fsecond;
                break;
            }
            case NUMERIC: {
                return MediaQueryImpl.numericValueInUnit(value, canvas, primitype);
            }
            default: {
                throw new DOMInvalidAccessException("Unsupported type: " + (Object)((Object)value.getPrimitiveType()));
            }
        }
        return fval;
    }

    private static float numericValueInUnit(CSSTypedValue value, CSSCanvas canvas, short primitype) throws DOMException {
        float fval;
        switch (value.getUnitType()) {
            case 20: {
                fval = value.getFloatValue((short)20);
                StyleDatabase sdb = canvas.getStyleDatabase();
                float fontSize = sdb.getFontSizeFromIdentifier(null, "medium");
                fontSize = NumberValue.floatValueConversion(fontSize, sdb.getNaturalUnit(), primitype);
                fval *= fontSize;
                break;
            }
            case 21: {
                fval = value.getFloatValue((short)21);
                StyleDatabase sdb = canvas.getStyleDatabase();
                float fontSize = sdb.getFontSizeFromIdentifier(null, "medium");
                float exSize = sdb.getExSizeInPt(null, fontSize);
                exSize = NumberValue.floatValueConversion(exSize, (short)6, primitype);
                fval *= exSize;
                break;
            }
            default: {
                fval = value.getFloatValue(primitype);
            }
        }
        return fval;
    }

    static boolean floatEquals(float value1, float value2) {
        return (double)Math.abs(value2 - value1) < 7.0E-6;
    }

    protected abstract CSSNumberValue createNumberValue(short var1, float var2, boolean var3);

    @Override
    protected byte matches(BooleanCondition condition, BooleanCondition otherCondition, byte negatedQuery) {
        switch (condition.getType()) {
            case AND: {
                for (BooleanCondition subcond : condition.getSubConditions()) {
                    if (this.matches(subcond, otherCondition, negatedQuery) != 0) continue;
                    return 0;
                }
                return 1;
            }
            case OR: {
                for (BooleanCondition subcond : condition.getSubConditions()) {
                    if (this.matches(subcond, otherCondition, negatedQuery) != 1) continue;
                    return 1;
                }
                break;
            }
            case PREDICATE: {
                if (!(condition instanceof MediaPredicate)) {
                    return 0;
                }
                MediaPredicate predicate = (MediaPredicate)condition;
                if (predicate.getPredicateType() == 0) {
                    return 2;
                }
                switch (otherCondition.getType()) {
                    case PREDICATE: {
                        if (!(otherCondition instanceof MediaPredicate)) {
                            return 0;
                        }
                        MediaPredicate otherPredicate = (MediaPredicate)otherCondition;
                        if (otherPredicate.getPredicateType() == 0) {
                            return 2;
                        }
                        if (predicate.matches(otherPredicate, negatedQuery)) {
                            return 1;
                        }
                        return 0;
                    }
                    case AND: {
                        for (BooleanCondition subcond : otherCondition.getSubConditions()) {
                            if (this.matches(condition, subcond, negatedQuery) != 1) continue;
                            return 1;
                        }
                        break;
                    }
                    case OR: {
                        for (BooleanCondition subcond : otherCondition.getSubConditions()) {
                            if (this.matches(condition, subcond, negatedQuery) != 0) continue;
                            return 0;
                        }
                        return 1;
                    }
                    case NOT: {
                        negatedQuery = negatedQuery == 0 ? (byte)2 : (negatedQuery == 1 ? (byte)3 : (negatedQuery == 2 ? (byte)0 : 1));
                        return this.matches(condition, otherCondition.getNestedCondition(), negatedQuery);
                    }
                    case SELECTOR_FUNCTION: {
                        return 1;
                    }
                    case OTHER: {
                        return 0;
                    }
                }
                break;
            }
            case NOT: {
                negatedQuery = negatedQuery == 0 ? (byte)1 : (negatedQuery == 1 ? (byte)0 : (negatedQuery == 2 ? (byte)3 : (byte)2));
                return this.matches(condition.getNestedCondition(), otherCondition, negatedQuery);
            }
            case SELECTOR_FUNCTION: {
                return 1;
            }
        }
        return 0;
    }

    private class MQEvaluator
    extends Evaluator {
        private final CSSCanvas canvas;
        private final short expectedUnit;

        private MQEvaluator(CSSCanvas canvas) {
            this.canvas = canvas;
            this.expectedUnit = canvas.getStyleDatabase().getNaturalUnit();
        }

        @Override
        protected CSSNumberValue absoluteTypedValue(CSSTypedValue partialValue) {
            if (partialValue.getUnitType() != 0) {
                float fval = MediaQueryImpl.this.valueInUnit(partialValue, this.canvas, this.expectedUnit);
                return this.createNumberValue(this.expectedUnit, fval, true);
            }
            return super.absoluteTypedValue(partialValue);
        }

        @Override
        protected CSSNumberValue createNumberValue(short unit, float valueInSpecifiedUnit, boolean calculated) {
            return MediaQueryImpl.this.createNumberValue(unit, valueInSpecifiedUnit, calculated);
        }
    }
}

