/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode.mindmapmode;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.themes.FlatMacDarkLaf;
import com.formdev.flatlaf.themes.FlatMacLightLaf;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.OptionPanelBuilder;
import org.freeplane.core.resources.components.PreferencesDialogLauncher;
import org.freeplane.core.resources.components.ShowPreferencesAction;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.flatlaf.FlatAtomOneDarkContrastIJTheme;
import org.freeplane.core.ui.flatlaf.FlatSolarizedLightIJTheme;
import org.freeplane.core.ui.menubuilders.generic.UserRole;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.mindmapmode.MMapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.RedoAction;
import org.freeplane.features.mode.mindmapmode.UndoAction;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;

public class MModeController
extends ModeController {
    private static final String LOOKANDFEEL_PROPERTY = "lookandfeel";
    public static final String MODENAME = "MindMap";
    private RedoAction redo;
    public static final String RESOURCES_DELETE_NODES_WITHOUT_QUESTION = "delete_nodes_without_question";
    private UndoAction undo;
    private OptionPanelBuilder optionPanelBuilder;

    public static MModeController getMModeController() {
        Controller controller = Controller.getCurrentController();
        return (MModeController)controller.getModeController(MODENAME);
    }

    public MModeController(Controller controller) {
        super(controller);
        this.createActions();
    }

    private void addUndoableActor(IActor actor, MapModel map) {
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        if (undoHandler != null && !undoHandler.isUndoActionRunning()) {
            undoHandler.addActor(actor);
        }
    }

    public void deactivateUndo(MMapModel map) {
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        if (undoHandler != null) {
            undoHandler.deactivate();
        }
    }

    public void commit() {
        MapModel map = this.getController().getMap();
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        if (undoHandler != null) {
            undoHandler.commit();
        }
    }

    public void delayedCommit(MapModel map) {
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        if (undoHandler != null) {
            undoHandler.delayedCommit();
        }
    }

    public void delayedRollback(MapModel map) {
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        if (undoHandler != null) {
            undoHandler.delayedRollback();
        }
    }

    private void createActions() {
        this.undo = new UndoAction();
        this.redo = new RedoAction();
        this.undo.setRedo((Action)((Object)this.redo));
        this.redo.setUndo((Action)((Object)this.undo));
        this.addAction(this.undo);
        this.addAction(this.redo);
    }

    public void createOptionPanelControls() {
        this.optionPanelBuilder = new OptionPanelBuilder();
        ResourceController resourceController = ResourceController.getResourceController();
        URL preferences = resourceController.getResource("/xml/preferences.xml");
        this.optionPanelBuilder.load(preferences);
        UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
        Vector<String> lafNames = new Vector<String>(lafInfo.length + 2);
        Vector<String> translatedLafNames = new Vector<String>(lafInfo.length + 2);
        lafNames.add("default");
        translatedLafNames.add(TextUtils.getOptionalText((String)"OptionPanel.default"));
        for (int i = 0; i < lafInfo.length; ++i) {
            UIManager.LookAndFeelInfo info = lafInfo[i];
            String className = info.getClassName();
            lafNames.add(className);
            translatedLafNames.add(info.getName());
        }
        if (Compat.isMacOsX()) {
            lafNames.add(FlatMacLightLaf.class.getName());
            translatedLafNames.add("Flat macOS Light");
            lafNames.add(FlatMacDarkLaf.class.getName());
            translatedLafNames.add("Flat macOS Dark");
        }
        lafNames.add(FlatLightLaf.class.getName());
        translatedLafNames.add("Flat Light");
        lafNames.add(FlatIntelliJLaf.class.getName());
        translatedLafNames.add("Flat IntelliJ");
        lafNames.add(FlatSolarizedLightIJTheme.class.getName());
        translatedLafNames.add("Flat Solarized Light");
        lafNames.add(FlatDarkLaf.class.getName());
        translatedLafNames.add("Flat Dark");
        lafNames.add(FlatDarculaLaf.class.getName());
        translatedLafNames.add("Flat Darcula");
        lafNames.add(FlatAtomOneDarkContrastIJTheme.class.getName());
        translatedLafNames.add("Atom One Dark Contrast (Material)");
        MModeController.addCurrentLookAndFeelIfNecessary(lafNames, translatedLafNames);
        this.optionPanelBuilder.addEditableComboProperty("Appearance/look_and_feel/lookandfeel", LOOKANDFEEL_PROPERTY, lafNames, translatedLafNames, 0);
        this.getController().addAction((AFreeplaneAction)MModeController.createShowPreferencesAction(this.optionPanelBuilder, true));
    }

    public static ShowPreferencesAction createShowPreferencesAction(OptionPanelBuilder optionPanelBuilder, boolean arePropertyValidatorsEnabled) {
        return new ShowPreferencesAction(optionPanelBuilder.getRoot(), arePropertyValidatorsEnabled);
    }

    public static void showPreferences(OptionPanelBuilder optionPanelBuilder, boolean arePropertyValidatorsEnabled, String tabIdentifier, String selectedProperty) {
        String actionCommand = tabIdentifier != null ? "OptionPanel." + tabIdentifier : null;
        ActionEvent event = new ActionEvent(optionPanelBuilder, 1001, actionCommand);
        PreferencesDialogLauncher.open((DefaultMutableTreeNode)optionPanelBuilder.getRoot(), (String)selectedProperty, (boolean)arePropertyValidatorsEnabled, (ActionEvent)event);
    }

    public void showPreferences(String tabIdentifier, String selectedProperty) {
        MModeController.showPreferences(this.optionPanelBuilder, true, tabIdentifier, selectedProperty);
    }

    private static void addCurrentLookAndFeelIfNecessary(Vector<String> lafNames, Vector<String> translatedLafNames) {
        String currentLaf = ResourceController.getResourceController().getProperty(LOOKANDFEEL_PROPERTY);
        if (!lafNames.contains(currentLaf)) {
            lafNames.add(currentLaf);
            translatedLafNames.add(currentLaf.replaceFirst(".*\\.", ""));
        }
    }

    public void execute(IActor actor, MapModel map) {
        if (actor.isReadonly() || this.canEdit(map)) {
            try {
                Controller.getCurrentController().getViewController().invokeAndWait(() -> {
                    this.addUndoableActor(actor, map);
                    actor.act();
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getModeName() {
        return MODENAME;
    }

    public OptionPanelBuilder getOptionPanelBuilder() {
        return this.optionPanelBuilder;
    }

    public void rollback() {
        MapModel map = this.getController().getMap();
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        if (undoHandler != null) {
            undoHandler.rollback();
        }
    }

    public boolean save() {
        return ((MFileManager)UrlManager.getController()).save(this.getController().getMap());
    }

    public void shutdown() {
        super.shutdown();
        MNoteController noteController = (MNoteController)NoteController.getController();
        if (noteController != null) {
            noteController.shutdownController();
        }
    }

    public void startTransaction() {
        MapModel map = this.getController().getMap();
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        if (undoHandler != null) {
            undoHandler.startTransaction();
        }
    }

    public void forceNewTransaction() {
        MapModel map = this.getController().getMap();
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        if (undoHandler != null) {
            undoHandler.forceNewTransaction();
        }
    }

    public void startup() {
        super.startup();
        NoteController noteController = NoteController.getController();
        if (noteController != null) {
            ((MNoteController)noteController).startupController();
        }
    }

    public void undo() {
        this.undo.actionPerformed(null);
    }

    public void resetRedo() {
        this.redo.reset();
    }

    public boolean canEdit() {
        return true;
    }

    public UserRole userRole(MapModel map) {
        return map != null ? UserRole.of((boolean)this.canEdit(map)) : UserRole.NO_MAP;
    }

    public boolean supportsHookActions() {
        return true;
    }

    public boolean shouldCenterCompactMaps() {
        return ResourceController.getResourceController().getBooleanProperty("shouldCenterSmallMaps");
    }
}

