/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicMenuItemUI;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.components.MultipleImageIcon;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.bookmarks.mindmapmode.MapBookmarks;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.FilterUpdateListener;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.main.application.AuxillaryEditorSplitPane;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.outline.FilterCache;
import org.freeplane.view.swing.map.outline.MapTreeNode;
import org.freeplane.view.swing.map.outline.NodeTreeBuilder;
import org.freeplane.view.swing.map.outline.OutlineDisplayMode;
import org.freeplane.view.swing.map.outline.OutlineGeometry;
import org.freeplane.view.swing.map.outline.OutlinePane;
import org.freeplane.view.swing.map.outline.OutlineSelectedNodeUpdater;
import org.freeplane.view.swing.map.outline.OutlineSelectionBridge;
import org.freeplane.view.swing.map.outline.OutlineTreeViewState;
import org.freeplane.view.swing.map.outline.OutlineTreeViewStates;
import org.freeplane.view.swing.map.outline.ScrollableTreePanel;
import org.freeplane.view.swing.map.outline.SelectionSynchronizationTrigger;
import org.freeplane.view.swing.map.outline.TreeNode;

public class MapAwareOutlinePane
extends OutlinePane
implements IMapViewChangeListener,
IMapChangeListener,
INodeChangeListener {
    private static final String FILTER_ICON = "filter_icon";
    private static final long serialVersionUID = 1L;
    private static final Icon BOOKMARK_ICON = IconStoreFactory.ICON_STORE.getUIIcon("node-bookmark.svg").getIcon();
    private static final Icon SYNC_ICON = ResourceController.getResourceController().getIcon("/images/sync.svg?useAccentColor=true");
    private static final Icon JUMPIN_ICON = ResourceController.getResourceController().getIcon("/images/syncJumpIn.svg?useAccentColor=true");
    private static final Icon QUICK_FILTER_ICON = ResourceController.getResourceController().getIcon("/images/apply_quick_filter.svg?useAccentColor=true");
    private static final Icon FILTER_BUTTON_ICON = ResourceController.getResourceController().getIcon("filterIcon");
    private static final Icon REMOVE_FILTER_ICON = ResourceController.getResourceController().getIcon("ApplyNoFilteringAction.icon");
    private static final TreeNode NO_MAP_AVAILABLE = new TreeNode("empty", () -> TextUtils.getText("no_open_map"));
    private static final String OUTLINE_STATE_KEY = "freeplane.outline.state";
    private TreeNode currentRoot;
    private MapView currentMapView;
    private final OutlineTreeViewStates displayState;
    private final FilterCache bookmarkFilterCache;
    private JToggleButton bookmarkModeToggleButton;
    private JToggleButton syncModeToggleButton;
    private JToggleButton jumpInToggleButton;
    private static final String QUICK_FILTER_HISTORY_SIZE_KEY = "outlineFilterHistorySize";
    private final LinkedList<FilterEntry> quickFilterHistory = new LinkedList();
    private final JPopupMenu quickFilterPopupMenu = new JPopupMenu();
    private JToggleButton quickFilterButton;
    private final OutlineSelectedNodeUpdater selectedNodeUpdater;
    private PropertyChangeListener focusListener;
    private boolean refreshScheduled;
    private final FilterUpdateListener filterUpdateListener = this::onFilterResultUpdate;
    private boolean isFilterResultUpdateScheduled;

    MapView getCurrentMapView() {
        return this.currentMapView;
    }

    void handleMapSelectionChanged(NodeModel node) {
        if (node != null && this.isCurrentMapViewSelected()) {
            SwingUtilities.invokeLater(this::syncronizeSelectionFollowingMap);
        }
    }

    private boolean isCurrentMapViewSelected() {
        return this.currentMapView != null && this.currentMapView.isSelected() && this.getTreePanel() != null;
    }

    private void syncronizeSelectionFollowingMap() {
        if (this.isCurrentMapViewSelected()) {
            this.getTreePanel().getOutlineSelection().setShowsExtendedBreadcrumb(true);
            this.synchronizeOutlineSelection(SelectionSynchronizationTrigger.MAP, false);
        }
    }

    void synchronizeOutlineSelection(SelectionSynchronizationTrigger synchronizationTrigger, boolean requestFocus) {
        if (this.currentRoot == NO_MAP_AVAILABLE) {
            return;
        }
        NodeModel node = this.currentMapView.getSelected().getNode();
        ScrollableTreePanel panel = this.getTreePanel();
        TreeNode target = this.findOutlineNode(node);
        if (target != null) {
            panel.synchronizeOutlineSelection(target, synchronizationTrigger, requestFocus);
        }
    }

    private TreeNode findOutlineNode(NodeModel node) {
        if (node == null) {
            return null;
        }
        TreeNode outlineNode = node.getViewers().stream().filter(MapTreeNode.class::isInstance).map(MapTreeNode.class::cast).filter(mapNode -> mapNode.isContainedIn(this)).findAny().orElse(null);
        if (outlineNode == null) {
            return this.findOutlineNode(node.getParentNode());
        }
        return outlineNode;
    }

    public MapAwareOutlinePane(AuxillaryEditorSplitPane pane) {
        super(OutlineDisplayMode.DEFAULT, NO_MAP_AVAILABLE);
        this.selectedNodeUpdater = new OutlineSelectedNodeUpdater(this);
        this.displayState = new OutlineTreeViewStates();
        this.bookmarkFilterCache = new FilterCache();
        this.configureToolbar(this.toolbar);
        pane.changeAuxComponentSide(OutlineGeometry.getInstance().isRightToLeft() ? "right" : "left");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Controller.getCurrentController().getMapViewManager().addMapViewChangeListener(this);
        try {
            Window w = SwingUtilities.getWindowAncestor(this);
            if (w != null) {
                IMapViewManager mvm = Controller.getCurrentController().getMapViewManager();
                JComponent mv = mvm.getLastSelectedMapViewContainedIn(w);
                if (mv instanceof MapView) {
                    this.updateTreeFromMap((MapView)mv);
                    this.synchronizeOutlineSelection(SelectionSynchronizationTrigger.MAP, false);
                } else {
                    this.showNoMapState();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Controller.getCurrentController().getMapViewManager().removeMapViewChangeListener(this);
        this.removeMapListeners();
        this.cleanupCurrentTree();
    }

    @Override
    public void afterFilterChange(Component view, Filter newFilter) {
        if (this.displayState.getCurrentMode() == OutlineDisplayMode.BOOKMARK) {
            return;
        }
        if (view instanceof MapView) {
            Window myWindow = SwingUtilities.getWindowAncestor(this);
            if (SwingUtilities.getWindowAncestor(view) == myWindow && this.displayState.getFilter() == null && this.displayState.getCurrentMode() != OutlineDisplayMode.BOOKMARK) {
                Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
                boolean requestFocus = focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, this);
                this.updateTreeFromMap((MapView)view);
                this.synchronizeOutlineSelection(SelectionSynchronizationTrigger.MAP, requestFocus);
            }
        }
    }

    private void refreshOutlineLater() {
        if (this.refreshScheduled) {
            return;
        }
        this.refreshScheduled = true;
        SwingUtilities.invokeLater(this::refreshOutline);
    }

    private void refreshOutline() {
        if (this.currentMapView == null) {
            this.showNoMapState();
        } else {
            this.updateTreeFromMap(this.currentMapView);
        }
        this.refreshScheduled = false;
    }

    private void updateTreeFromMap(MapView mapView) {
        this.updateTreeFromMap(mapView, true);
    }

    private void updateTreeFromMap(MapView mapView, boolean captureState) {
        try {
            Filter effectiveFilter;
            boolean showsExtendedBreadcrumb;
            this.removeMapListeners();
            ScrollableTreePanel oldPanel = this.getTreePanel();
            if (oldPanel != null) {
                if (captureState) {
                    this.storeCurrentDisplayState(oldPanel);
                }
                showsExtendedBreadcrumb = oldPanel.getOutlineSelection().showsExtendedBreadcrumb();
            } else {
                showsExtendedBreadcrumb = false;
            }
            this.cleanupCurrentTree();
            if (this.currentMapView != mapView) {
                this.detachCurrentMapView();
                this.currentMapView = mapView;
                if (mapView.getModeController().getModeName().equals("File")) {
                    this.showNoMapState();
                    return;
                }
                mapView.setFilterUpdateListener(this.filterUpdateListener);
            }
            OutlineTreeViewState saved = this.loadSavedViewState(this.currentMapView);
            NodeTreeBuilder builder = new NodeTreeBuilder(mapView, this, saved);
            OutlineDisplayMode displayMode = this.displayState.getCurrentMode();
            MapModel map = mapView.getMap();
            if (displayMode == OutlineDisplayMode.BOOKMARK || !this.displayState.followsJumpIn()) {
                builder.withRootModel(map.getRootNode());
            }
            if ((effectiveFilter = this.resolveEffectiveFilter(mapView)) != null) {
                builder.withFilter(effectiveFilter);
            }
            builder.build();
            this.currentRoot = builder.getRoot();
            if (displayMode != OutlineDisplayMode.BOOKMARK) {
                int minimalLevel = displayMode.getMinimalOutlineLevel();
                if (builder.getApplicableState() == null || this.currentRoot.getExpansionLevel() < minimalLevel) {
                    int initialLevel = displayMode.getInitialOutlineLevel();
                    this.currentRoot.applyExpansionLevel(Math.max(initialLevel, minimalLevel));
                }
            } else if (this.currentRoot.getExpansionLevel() < 10000) {
                this.currentRoot.applyExpansionLevel(10000);
            }
            this.setRootNode(displayMode, this.currentRoot);
            ScrollableTreePanel panel = this.getTreePanel();
            panel.setBackgroundColorSupplier(this::getBackgroundColor);
            panel.setSelectionBridge(new OutlineSelectionBridge(this));
            panel.getOutlineSelection().setShowsExtendedBreadcrumb(showsExtendedBreadcrumb);
            try {
                this.addMapChangeListeners();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (builder.getApplicableState() != null) {
                panel = this.getTreePanel();
                builder.getApplicableState().applyTo(panel.getRoot());
                panel.updateVisibleNodes(displayMode == OutlineDisplayMode.MAP_VIEW_SYNC ? ScrollableTreePanel.ScrollMode.SIBLINGS : ScrollableTreePanel.ScrollMode.SINGLE_ITEM);
            }
            try {
                this.synchronizeOutlineSelection(SelectionSynchronizationTrigger.MAP, false);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            System.err.println("Failed to update tree from map: " + e.getMessage());
            e.printStackTrace();
            this.showNoMapState();
        }
    }

    private void addMapChangeListeners() {
        this.currentMapView.getMap().addMapChangeListener(this);
        MapController mapController = this.currentMapView.getModeController().getMapController();
        mapController.addNodeSelectionListener(this.selectedNodeUpdater);
        mapController.addNodeChangeListener(this);
        this.installFocusListener();
    }

    private void showNoMapState() {
        this.cleanupCurrentTree();
        this.removeMapListeners();
        this.detachCurrentMapView();
        this.currentRoot = NO_MAP_AVAILABLE;
        this.bookmarkFilterCache.reset();
        this.displayState.putViewState(null);
        this.setRootNode(OutlineDisplayMode.DEFAULT, this.currentRoot);
        this.getTreePanel().setBackgroundColorSupplier(null);
    }

    private void removeMapListeners() {
        if (this.currentMapView != null) {
            try {
                this.currentMapView.getMap().removeMapChangeListener(this);
                MapController mapController = this.currentMapView.getModeController().getMapController();
                mapController.removeNodeSelectionListener(this.selectedNodeUpdater);
                mapController.removeNodeChangeListener(this);
                this.uninstallFocusListener();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void installFocusListener() {
        this.uninstallFocusListener();
        this.focusListener = ev -> {
            Object nv = ev.getNewValue();
            if (nv == null) {
                return;
            }
            String action = String.valueOf(nv);
            this.currentMapView.putClientProperty("outlineFocus", null);
            if ("back".equals(action)) {
                this.currentMapView.getSelected().getMainView().requestFocusInWindow();
                return;
            }
            ScrollableTreePanel panel = this.getTreePanel();
            if (panel != null) {
                SwingUtilities.invokeLater(() -> {
                    try {
                        NodeModel selectedNode;
                        IMapSelection sel = Controller.getCurrentController().getSelection();
                        NodeModel nodeModel = selectedNode = sel != null ? sel.getSelected() : null;
                        if (selectedNode != null) {
                            this.synchronizeOutlineSelection(SelectionSynchronizationTrigger.MAP, true);
                        }
                        panel.synchronizeSelectionButton(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        };
        try {
            this.currentMapView.addPropertyChangeListener("outlineFocus", this.focusListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void uninstallFocusListener() {
        if (this.currentMapView != null && this.focusListener != null) {
            try {
                this.currentMapView.removePropertyChangeListener("outlineFocus", this.focusListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.focusListener = null;
    }

    @Override
    public void mapChanged(MapChangeEvent event) {
        if (this.currentMapView == null) {
            return;
        }
        Object property = event.getProperty();
        if (MapView.class.equals(property) && event.getSource() == this.currentMapView) {
            event.getMap().removeMapChangeListener(this);
            this.updateTreeFromMap(this.currentMapView);
            return;
        }
        if (event.getMap() != this.currentMapView.getMap()) {
            return;
        }
        if (MapBookmarks.class.equals(property)) {
            if (this.displayState.getCurrentMode() == OutlineDisplayMode.BOOKMARK) {
                this.bookmarkFilterCache.refresh(this.currentMapView);
                this.refreshOutlineLater();
            }
            return;
        }
        if ((property == IMapViewManager.MapChangeEventProperty.MAP_VIEW_ROOT || IMapViewManager.MapChangeEventProperty.MAP_VIEW_ROOT.equals(property)) && this.displayState.getCurrentMode() == OutlineDisplayMode.MAP_VIEW) {
            this.refreshOutlineLater();
            return;
        }
    }

    @Override
    public void afterWindowLastSelectedMapViewChanged(Window window, Component newView) {
        Window myWindow = SwingUtilities.getWindowAncestor(this);
        if (myWindow == window && newView != this.currentMapView && newView instanceof MapView) {
            this.updateTreeFromMap((MapView)newView);
            this.synchronizeOutlineSelection(SelectionSynchronizationTrigger.MAP, false);
        }
    }

    @Override
    public void afterWindowLastSelectedMapViewRemoved(Window window) {
        Window myWindow = SwingUtilities.getWindowAncestor(this);
        if (myWindow == window) {
            this.detachCurrentMapView();
            this.showNoMapState();
        }
    }

    private void detachCurrentMapView() {
        if (this.currentMapView != null) {
            this.currentMapView.removeFilterUpdateListener(this.filterUpdateListener);
            this.currentMapView = null;
        }
    }

    private void cleanupCurrentTree() {
        if (this.currentRoot != null && this.currentRoot instanceof MapTreeNode) {
            OutlinePane.cleanupTree(this.currentRoot);
        }
    }

    private OutlineTreeViewState captureCurrentState(ScrollableTreePanel panel) {
        String firstId = panel.getVisibleNodes().getFirstVisibleNodeId();
        TreeNode root = panel.getRoot();
        HashMap<String, Integer> levels = new HashMap<String, Integer>();
        this.collectExpanded(root, levels);
        String rootId = null;
        try {
            if (this.currentMapView != null && this.currentMapView.getRoot() != null && this.currentMapView.getRoot().getNode() != null) {
                rootId = this.currentMapView.getRoot().getNode().getID();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Filter stateFilter = this.displayState.getCurrentMode() == OutlineDisplayMode.BOOKMARK ? this.bookmarkFilterCache.current() : (this.currentMapView != null ? this.currentMapView.getFilter() : null);
        WeakReference<Filter> ref = new WeakReference<Filter>(stateFilter);
        return new OutlineTreeViewState(firstId, levels, rootId, ref);
    }

    private void collectExpanded(TreeNode node, Map<String, Integer> out) {
        int lvl = node.getExpansionLevel();
        if (lvl > 0) {
            out.put(node.getId(), lvl);
        }
        for (TreeNode c : node.getChildren()) {
            this.collectExpanded(c, out);
        }
    }

    private void configureToolbar(FreeplaneToolBar toolbar) {
        this.bookmarkModeToggleButton = new JToggleButton(BOOKMARK_ICON);
        TranslatedElementFactory.createTooltip(this.bookmarkModeToggleButton, "outline.showBookmarks");
        this.configureModeToggleButton(this.bookmarkModeToggleButton, OutlineDisplayMode.BOOKMARK);
        toolbar.add((Component)this.bookmarkModeToggleButton, 0);
        this.syncModeToggleButton = new JToggleButton(SYNC_ICON);
        this.syncModeToggleButton.setSelected(this.displayState.getCurrentMode() == OutlineDisplayMode.MAP_VIEW_SYNC);
        TranslatedElementFactory.createTooltip(this.syncModeToggleButton, "outline.followSelection");
        this.configureModeToggleButton(this.syncModeToggleButton, OutlineDisplayMode.MAP_VIEW_SYNC);
        toolbar.add((Component)this.syncModeToggleButton, 1);
        this.jumpInToggleButton = new JToggleButton(JUMPIN_ICON);
        TranslatedElementFactory.createTooltip(this.jumpInToggleButton, "outline.followRoot");
        this.configureJumpinToggleButton(this.jumpInToggleButton);
        toolbar.add((Component)this.jumpInToggleButton, 2);
        this.quickFilterButton = new JToggleButton(FILTER_BUTTON_ICON){

            @Override
            public JToolTip createToolTip() {
                QuickFilterToolTip quickFilterToolTip = new QuickFilterToolTip(this);
                quickFilterToolTip.setComponent(this);
                return quickFilterToolTip;
            }
        };
        TranslatedElementFactory.createTooltip(this.quickFilterButton, "outline.filter");
        this.configureQuickFilterToggleButton(this.quickFilterButton);
        toolbar.add((Component)this.quickFilterButton, 3);
    }

    private void configureModeToggleButton(JToggleButton toggleButton, OutlineDisplayMode mode) {
        toggleButton.setFocusable(false);
        toggleButton.addActionListener(e -> {
            boolean isSelected = toggleButton.isSelected();
            OutlineDisplayMode targetMode = isSelected ? mode : OutlineDisplayMode.MAP_VIEW;
            this.setOutlineDisplayMode(targetMode, this.displayState.getFilter(), this.displayState.followsJumpIn());
            if (mode == OutlineDisplayMode.MAP_VIEW_SYNC) {
                ResourceController.getResourceController().setProperty("outline.displayMode", isSelected);
            }
        });
    }

    private void configureJumpinToggleButton(JToggleButton toggleButton) {
        toggleButton.setFocusable(false);
        toggleButton.setSelected(this.displayState.followsJumpIn());
        toggleButton.addActionListener(e -> this.setFollowsJumpIn(toggleButton.isSelected()));
    }

    private void configureQuickFilterToggleButton(JToggleButton toggleButton) {
        toggleButton.setFocusable(false);
        toggleButton.setSelected(this.displayState.getFilter() != null);
        toggleButton.addActionListener(e -> {
            toggleButton.setSelected(this.displayState.getFilter() != null);
            this.showQuickFilterMenu(toggleButton);
        });
    }

    private void showQuickFilterMenu(JToggleButton invoker) {
        FilterController filterController;
        DefaultComboBoxModel filterConditions;
        this.quickFilterPopupMenu.removeAll();
        if (this.displayState.getFilter() != null) {
            JMenuItem removeFilter = TranslatedElementFactory.createMenuItem("outline.filter.remove");
            removeFilter.addActionListener(e -> this.setQuickFilter(false));
            removeFilter.setIcon(REMOVE_FILTER_ICON);
            TranslatedElementFactory.createTooltip(removeFilter, "outline.filter");
            this.quickFilterPopupMenu.add(removeFilter);
        }
        JMenuItem addFilter = TranslatedElementFactory.createMenuItem("outline.filter");
        addFilter.addActionListener(e -> this.setQuickFilter(true));
        addFilter.setIcon(QUICK_FILTER_ICON);
        this.quickFilterPopupMenu.add(addFilter);
        if (!this.quickFilterHistory.isEmpty()) {
            JMenu recentFiltersMenu = TranslatedElementFactory.createMenu("outline.recentFilters");
            this.quickFilterPopupMenu.add(recentFiltersMenu);
            this.addHistoryMenuItems(recentFiltersMenu);
        }
        if ((filterConditions = (filterController = FilterController.getCurrentFilterController()).getFilterConditions()).getSize() > 3) {
            JMenu predefinedConditionsMenu = TranslatedElementFactory.createMenu("outline.predefinedFilters");
            this.quickFilterPopupMenu.add(predefinedConditionsMenu);
            for (int conditionIndex = 3; conditionIndex < filterConditions.getSize(); ++conditionIndex) {
                ASelectableCondition condition = (ASelectableCondition)filterConditions.getElementAt(conditionIndex);
                Filter filter = filterController.createFilter(condition, null);
                MultipleImageIcon icon = filter.createIcon(this.quickFilterButton.getFontMetrics(this.quickFilterButton.getFont()));
                JMenuItem menuItem = new FilterEntry(filter, icon).createMenuItem(this);
                predefinedConditionsMenu.add(menuItem);
            }
        }
        if (this.quickFilterPopupMenu.getComponentCount() > 0) {
            this.quickFilterPopupMenu.show(invoker, 0, invoker.getHeight());
        }
    }

    private void addHistoryMenuItems(JMenu menu) {
        for (FilterEntry entry : this.quickFilterHistory) {
            JMenuItem historyItem = entry.createMenuItem(this);
            menu.add(historyItem);
        }
    }

    private void setQuickFilter(boolean enable) {
        Filter filter;
        if (enable) {
            FilterController filterController = FilterController.getCurrentFilterController();
            filter = filterController.createQuickFilter(null);
            if (filter == null) {
                this.quickFilterButton.setSelected(false);
                this.clearQuickFilterIcon();
            } else {
                MultipleImageIcon icon = filter.createIcon(this.quickFilterButton.getFontMetrics(this.quickFilterButton.getFont()));
                this.registerQuickFilterHistory(filter, icon);
            }
        } else {
            this.clearQuickFilterIcon();
            filter = null;
        }
        if (this.displayState.getFilter() != filter) {
            this.setOutlineDisplayMode(this.displayState.getCurrentMode(), filter, this.displayState.followsJumpIn());
        }
    }

    private void clearQuickFilterIcon() {
        this.quickFilterButton.putClientProperty(FILTER_ICON, null);
        this.quickFilterButton.repaint();
    }

    private void registerQuickFilterHistory(Filter filter, Icon icon) {
        if (filter == null || icon == null) {
            return;
        }
        this.quickFilterButton.putClientProperty(FILTER_ICON, icon);
        this.quickFilterButton.repaint();
        this.quickFilterHistory.removeIf(entry -> ((FilterEntry)entry).filter == filter);
        this.quickFilterHistory.addFirst(new FilterEntry(filter, icon));
        while (this.quickFilterHistory.size() > ResourceController.getResourceController().getIntProperty(QUICK_FILTER_HISTORY_SIZE_KEY, 10)) {
            this.quickFilterHistory.removeLast();
        }
    }

    private void applyQuickFilter(FilterEntry entry) {
        if (entry == null) {
            return;
        }
        this.quickFilterButton.setSelected(true);
        this.registerQuickFilterHistory(entry.filter, entry.icon);
        this.setOutlineDisplayMode(this.displayState.getCurrentMode(), entry.filter, this.displayState.followsJumpIn());
    }

    private void setFollowsJumpIn(boolean followsJumpIn) {
        this.setOutlineDisplayMode(this.displayState.getCurrentMode(), this.displayState.getFilter(), followsJumpIn);
    }

    public void setOutlineDisplayMode(OutlineDisplayMode displayMode, Filter filter, boolean followsJumpIn) {
        OutlineDisplayMode lastMode = this.displayState.getCurrentMode();
        boolean lastFollowsJumpIn = this.displayState.followsJumpIn();
        Filter lastFilter = this.displayState.getFilter();
        if (displayMode == null || displayMode == lastMode && followsJumpIn == lastFollowsJumpIn && filter == lastFilter) {
            this.syncToggleWithMode();
            return;
        }
        this.displayState.setCurrentMode(displayMode);
        this.displayState.setFollowsJumpIn(followsJumpIn);
        this.displayState.setFilter(filter);
        ScrollableTreePanel panel = this.getTreePanel();
        if (this.currentMapView != null) {
            if (lastMode.baseMode() != displayMode.baseMode() || followsJumpIn != lastFollowsJumpIn || filter != lastFilter) {
                this.storeCurrentDisplayState(panel);
                this.updateTreeFromMap(this.currentMapView, false);
            } else {
                panel.setDisplayMode(displayMode);
            }
            this.synchronizeOutlineSelection(SelectionSynchronizationTrigger.MAP, false);
        }
        this.syncToggleWithMode();
    }

    private void syncToggleWithMode() {
        boolean filters;
        boolean syncSelected;
        boolean bookmarkSelected;
        boolean bl = bookmarkSelected = this.displayState.getCurrentMode() == OutlineDisplayMode.BOOKMARK;
        if (this.bookmarkModeToggleButton.isSelected() != bookmarkSelected) {
            this.bookmarkModeToggleButton.setSelected(bookmarkSelected);
        }
        boolean bl2 = syncSelected = this.displayState.getCurrentMode() == OutlineDisplayMode.MAP_VIEW_SYNC;
        if (this.syncModeToggleButton.isSelected() != syncSelected) {
            this.syncModeToggleButton.setSelected(syncSelected);
        }
        boolean followsJumpIn = this.displayState.followsJumpIn();
        if (this.jumpInToggleButton.isSelected() != followsJumpIn) {
            this.bookmarkModeToggleButton.setSelected(followsJumpIn);
        }
        boolean bl3 = filters = this.displayState.getFilter() != null;
        if (this.quickFilterButton.isSelected() != filters) {
            this.quickFilterButton.setSelected(filters);
        }
    }

    private void storeCurrentDisplayState(ScrollableTreePanel panel) {
        OutlineTreeViewState state = this.captureCurrentState(panel);
        if (state != null) {
            this.displayState.putViewState(state);
            this.storeDisplayStatesOnMapView();
        }
    }

    private void storeDisplayStatesOnMapView() {
        if (this.currentMapView == null) {
            return;
        }
        this.currentMapView.putClientProperty(OUTLINE_STATE_KEY, this.displayState.copy());
    }

    private OutlineTreeViewState loadSavedViewState(MapView mapView) {
        if (mapView == null) {
            return null;
        }
        try {
            OutlineTreeViewStates property = (OutlineTreeViewStates)mapView.getClientProperty(OUTLINE_STATE_KEY);
            this.displayState.loadFrom(property);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.syncToggleWithMode();
        return this.displayState.getViewState();
    }

    private boolean containsBookmark(NodeModel node) {
        if (node == null) {
            return false;
        }
        MapModel mapModel = node.getMap();
        return mapModel != null && MapBookmarks.of((MapModel)mapModel).contains(node.getID());
    }

    private Color getBackgroundColor() {
        if (this.currentMapView == null) {
            return null;
        }
        boolean useColoredOutlineItems = ResourceController.getResourceController().getBooleanProperty("useColoredOutlineItems", false);
        if (useColoredOutlineItems) {
            return this.currentMapView.getBackground();
        }
        return null;
    }

    @Override
    OutlineDisplayMode getDisplayMode() {
        return this.displayState.getCurrentMode();
    }

    private Filter resolveEffectiveFilter(MapView mapView) {
        if (mapView == null) {
            return null;
        }
        OutlineDisplayMode mode = this.displayState.getCurrentMode();
        if (mode == OutlineDisplayMode.BOOKMARK) {
            return this.bookmarkFilterCache.prepare(mapView, () -> Filter.createFilter(this::containsBookmark, true, false, false, null));
        }
        Filter filter = this.displayState.getFilter();
        if (filter != null) {
            filter.calculateFilterResults(mapView.getMap());
        }
        return filter;
    }

    private void onFilterResultUpdate(Filter filter, NodeModel node) {
        if (!(this.isFilterResultUpdateScheduled || this.displayState.getFilter() != null && this.displayState.getFilter() != filter)) {
            this.isFilterResultUpdateScheduled = true;
            MapView updatedView = this.currentMapView;
            SwingUtilities.invokeLater(() -> {
                this.isFilterResultUpdateScheduled = false;
                if (updatedView == this.currentMapView) {
                    this.updateTreeFromMap(this.currentMapView, false);
                }
            });
        }
    }

    @Override
    void updateNodeTitle(TreeNode node) {
        if (!this.isFilterResultUpdateScheduled) {
            super.updateNodeTitle(node);
        }
    }

    @Override
    void rebuildFromNode(TreeNode node) {
        if (!this.isFilterResultUpdateScheduled && node instanceof MapTreeNode) {
            MapTreeNode existingSubtreeRoot = (MapTreeNode)node;
            MapView mapView = this.getCurrentMapView();
            if (mapView != null && existingSubtreeRoot.isContainedIn(this)) {
                OutlineTreeViewState state = this.displayState.getViewState();
                NodeTreeBuilder builder = new NodeTreeBuilder(mapView, this, state);
                Filter effectiveFilter = this.resolveEffectiveFilter(mapView);
                if (effectiveFilter != null) {
                    builder.withFilter(effectiveFilter);
                }
                builder.rebuildSubtree(existingSubtreeRoot);
            }
        }
        if (!this.isFilterResultUpdateScheduled && node != null) {
            super.rebuildFromNode(node);
        }
    }

    @Override
    public void nodeChanged(NodeChangeEvent event) {
        NodeModel node = event.getNode();
        this.updateFilterResults(node);
    }

    @Override
    public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
        this.updateFilterResults(nodeDeletionEvent.parent);
        if (!this.isFilterResultUpdateScheduled) {
            TreeNode outlineNode = this.findOutlineNode(nodeDeletionEvent.parent);
            this.rebuildFromNode(outlineNode);
        }
    }

    @Override
    public void onNodeMoved(NodeMoveEvent nodeMoveEvent) {
        boolean rebuildsNewParentSubtree;
        NodeModel oldParent = nodeMoveEvent.oldParent;
        NodeModel newParent = nodeMoveEvent.newParent;
        boolean rebuildsOldParentSubtree = !oldParent.isDescendantOf(newParent);
        boolean bl = rebuildsNewParentSubtree = newParent != oldParent && !newParent.isDescendantOf(oldParent);
        if (rebuildsOldParentSubtree) {
            this.updateFilterResults(oldParent);
        }
        if (rebuildsNewParentSubtree) {
            this.updateFilterResults(newParent);
        }
        if (!this.isFilterResultUpdateScheduled) {
            if (rebuildsOldParentSubtree) {
                this.rebuildFromNode(this.findOutlineNode(oldParent));
            }
            if (rebuildsNewParentSubtree) {
                this.rebuildFromNode(this.findOutlineNode(newParent));
            }
        }
    }

    @Override
    public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
        this.updateFilterResults(child);
        if (!this.isFilterResultUpdateScheduled) {
            TreeNode outlineNode = this.findOutlineNode(parent);
            this.rebuildFromNode(outlineNode);
        }
    }

    private void updateFilterResults(NodeModel node) {
        if (this.currentMapView == null) {
            return;
        }
        Filter filter = this.displayState.getFilter();
        if (filter == null) {
            return;
        }
        if (node.getMap() != this.currentMapView.getMap()) {
            return;
        }
        filter.updateFilterResults(node, this.filterUpdateListener);
    }

    List<TreeNode> collectNodesToSelection(TreeNode ancestor) {
        NodeModel ancestorNode;
        if (!(ancestor instanceof MapTreeNode)) {
            return Collections.emptyList();
        }
        MapView mv = this.getCurrentMapView();
        if (mv == null) {
            return Collections.emptyList();
        }
        NodeModel selected = mv.getSelected().getNode();
        if (!selected.isDescendantOf(ancestorNode = ((MapTreeNode)ancestor).getNodeModel())) {
            return Collections.emptyList();
        }
        LinkedList<TreeNode> nodes = new LinkedList<TreeNode>();
        for (NodeModel node = selected; node != ancestorNode; node = node.getParentNode()) {
            nodes.addFirst(((MapTreeNode)ancestor).createNode(node));
        }
        for (TreeNode node : nodes) {
            node.setLevel(-1);
        }
        return nodes;
    }

    static final class FilterEntry {
        private final Filter filter;
        private final Icon icon;

        private FilterEntry(Filter filter, Icon icon) {
            this.filter = filter;
            this.icon = icon;
        }

        private JMenuItem createMenuItem(MapAwareOutlinePane mapAwareOutlinePane) {
            JMenuItem filterActionItem = new JMenuItem(){
                private static final long serialVersionUID = 1L;

                @Override
                public void updateUI() {
                    this.setUI(new BasicMenuItemUI());
                }
            };
            filterActionItem.setIcon(this.icon);
            filterActionItem.setText(null);
            TranslatedElementFactory.createTooltip(filterActionItem, "outline.filter");
            filterActionItem.addActionListener(e -> mapAwareOutlinePane.applyQuickFilter(this));
            filterActionItem.setMaximumSize(filterActionItem.getPreferredSize());
            filterActionItem.setAlignmentX(0.0f);
            return filterActionItem;
        }
    }

    private static final class QuickFilterToolTip
    extends JToolTip {
        private static final long serialVersionUID = 1L;
        private final JToggleButton sourceButton;
        private boolean suppressDefaultText;

        private QuickFilterToolTip(JToggleButton sourceButton) {
            this.sourceButton = sourceButton;
        }

        @Override
        public Dimension getPreferredSize() {
            Icon filterIcon = this.getFilterIcon();
            String tooltipText = super.getTipText();
            if (filterIcon == null || tooltipText == null || tooltipText.isEmpty()) {
                return super.getPreferredSize();
            }
            Insets insets = this.getInsets();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int textHeight = fontMetrics != null ? fontMetrics.getHeight() : filterIcon.getIconHeight();
            int requiredHeight = Math.max(textHeight, filterIcon.getIconHeight()) + insets.top + insets.bottom;
            int requiredWidth = filterIcon.getIconWidth() + insets.left + insets.right;
            return new Dimension(requiredWidth, requiredHeight);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Icon filterIcon = this.getFilterIcon();
            String tooltipText = super.getTipText();
            if (filterIcon == null || tooltipText == null || tooltipText.isEmpty()) {
                this.suppressDefaultText = false;
                super.paintComponent(graphics);
                return;
            }
            this.suppressDefaultText = true;
            super.paintComponent(graphics);
            this.suppressDefaultText = false;
            Insets insets = this.getInsets();
            int iconYPosition = insets.top + (this.getHeight() - insets.top - insets.bottom - filterIcon.getIconHeight()) / 2;
            int iconXPosition = insets.left;
            filterIcon.paintIcon(this, graphics, iconXPosition, iconYPosition);
        }

        @Override
        public String getTipText() {
            if (this.suppressDefaultText) {
                return "";
            }
            return super.getTipText();
        }

        private Icon getFilterIcon() {
            Object clientProperty = this.sourceButton.getClientProperty(MapAwareOutlinePane.FILTER_ICON);
            return clientProperty instanceof Icon ? (Icon)clientProperty : null;
        }
    }
}

