/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text;

import java.awt.FontMetrics;
import java.util.List;
import javax.swing.Icon;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.StringConditionAdapter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.text.NodeItemRelation;
import org.freeplane.features.text.NodeTextConditionController;
import org.freeplane.n3.nanoxml.XMLElement;

public class NodeContainsCondition
extends StringConditionAdapter
implements NodeItemRelation {
    static final String IGNORE_CASE_NAME = "node_contains_condition";
    static final String MATCH_CASE_NAME = "match_case_node_contains_condition";
    public static final String VALUE = "VALUE";
    private final String value;
    private final String nodeItem;
    final StringMatchingStrategy stringMatchingStrategy;

    static ASelectableCondition loadIgnoreCase(XMLElement element) {
        return new NodeContainsCondition(element.getAttribute("ITEM", "filter_node"), element.getAttribute(VALUE, null), false, Boolean.valueOf(element.getAttribute("MATCH_APPROXIMATELY", null)), Boolean.valueOf(element.getAttribute("MATCH_WORDWISE", null)), Boolean.valueOf(element.getAttribute("IGNORE_DIACRITICS", null)));
    }

    static ASelectableCondition loadMatchCase(XMLElement element) {
        return new NodeContainsCondition(element.getAttribute("ITEM", "filter_node"), element.getAttribute(VALUE, null), true, Boolean.valueOf(element.getAttribute("MATCH_APPROXIMATELY", null)), Boolean.valueOf(element.getAttribute("MATCH_WORDWISE", null)), Boolean.valueOf(element.getAttribute("IGNORE_DIACRITICS", null)));
    }

    public NodeContainsCondition(String nodeItem, String value, boolean matchCase, boolean matchApproximately, boolean matchWordwise, boolean ignoreDiacritics) {
        super(matchCase, matchApproximately, matchWordwise, ignoreDiacritics);
        this.value = value;
        this.nodeItem = nodeItem;
        this.stringMatchingStrategy = matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : StringMatchingStrategy.EXACT_STRING_MATCHING_STRATEGY;
    }

    @Override
    public boolean checkNode(NodeModel node) {
        Object[] content = NodeTextConditionController.getItemsForComparison(this.nodeItem, node);
        return this.checkText(content);
    }

    private boolean checkText(Object[] content) {
        for (Object o : content) {
            if (!this.checkText(o)) continue;
            return true;
        }
        return false;
    }

    private boolean checkText(Object o) {
        return o != null && this.stringMatchingStrategy.matches(this.normalizedValue(), this.normalize(o), this.substringMatchType());
    }

    @Override
    protected String createDescription() {
        String nodeCondition = TextUtils.getText(this.nodeItem);
        return this.createDescription(nodeCondition, this.containsDescription(), this.value);
    }

    @Override
    protected List<Icon> createRenderedIcons(FontMetrics fontMetrics) {
        String nodeCondition = "filter_any_text".equals(this.nodeItem) ? "" : TextUtils.getText(this.nodeItem);
        return this.createRenderedIcons(nodeCondition, this.containsOperator(), this.value, fontMetrics);
    }

    @Override
    public void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(VALUE, this.value);
        child.setAttribute("ITEM", this.nodeItem);
    }

    @Override
    protected String getName() {
        return this.matchCase ? MATCH_CASE_NAME : IGNORE_CASE_NAME;
    }

    @Override
    public String getNodeItem() {
        return this.nodeItem;
    }

    @Override
    protected Object conditionValue() {
        return this.value;
    }
}

