/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Random;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.views.markers.ViewerSettingsAndStatusDialog;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

abstract class ViewerColumnsDialog<T>
extends ViewerSettingsAndStatusDialog {
    private List<T> visible;
    private List<T> nonVisible;
    private TableViewer visibleViewer;
    private TableViewer nonVisibleViewer;
    private Button upButton;
    private Button downButton;
    private Button toVisibleBtt;
    private Button toNonVisibleBtt;
    private Label widthLabel;
    private Text widthText;
    private Point tableLabelSize;

    ViewerColumnsDialog(Shell parentShell) {
        super(parentShell);
    }

    void setColumnsObjs(T[] columnObjs) {
        IColumnInfoProvider columnInfo = this.doGetColumnInfoProvider();
        IColumnUpdater updater = this.doGetColumnUpdater();
        List<T> visibleLocalVar = this.getVisible();
        List<T> nonVisibleLocalVar = this.getNonVisible();
        visibleLocalVar.clear();
        nonVisibleLocalVar.clear();
        Object data = null;
        T[] TArray = columnObjs;
        int n = columnObjs.length;
        int n2 = 0;
        while (n2 < n) {
            T columnObj = TArray[n2];
            data = columnObj;
            if (columnInfo.isColumnVisible(data)) {
                updater.setColumnVisible(data, true);
                updater.setColumnIndex(data, visibleLocalVar.size());
                visibleLocalVar.add(data);
            } else {
                updater.setColumnVisible(data, false);
                updater.setColumnIndex(data, nonVisibleLocalVar.size());
                nonVisibleLocalVar.add(data);
            }
            ++n2;
        }
    }

    @Override
    protected Control createDialogContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createInvisibleTable(composite);
        this.createMoveButtons(composite);
        this.createVisibleTable(composite);
        this.createUpDownBtt(composite);
        this.createWidthArea(composite);
        Object element = this.visibleViewer.getElementAt(0);
        if (element != null) {
            this.visibleViewer.setSelection((ISelection)new StructuredSelection(element));
        }
        this.visibleViewer.getTable().setFocus();
        return composite;
    }

    Control createUpDownBtt(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)new GridData(0, 4, false, true));
        Composite bttArea = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        bttArea.setLayout((Layout)layout);
        bttArea.setLayoutData((Object)new GridData(0, 0x1000000, false, true));
        this.upButton = new Button(bttArea, 8);
        this.upButton.setText(JFaceResources.getString((String)"ConfigureColumnsDialog_up"));
        this.upButton.addListener(13, event -> this.handleUpButton(event));
        this.setButtonLayoutData(this.upButton);
        ((GridData)this.upButton.getLayoutData()).verticalIndent = this.tableLabelSize.y;
        this.upButton.setEnabled(false);
        this.downButton = new Button(bttArea, 8);
        this.downButton.setText(JFaceResources.getString((String)"ConfigureColumnsDialog_down"));
        this.downButton.addListener(13, event -> this.handleDownButton(event));
        this.setButtonLayoutData(this.downButton);
        this.downButton.setEnabled(false);
        return bttArea;
    }

    Control createWidthArea(Composite parent) {
        Label dummy = new Label(parent, 0);
        dummy.setLayoutData((Object)new GridData(0, 0, false, false, 2, 1));
        Composite widthComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        widthComposite.setLayout((Layout)gridLayout);
        widthComposite.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.widthLabel = new Label(widthComposite, 0);
        this.widthLabel.setText(MarkerMessages.MarkerPreferences_WidthOfShownColumn);
        GridData gridData = new GridData(32);
        this.widthLabel.setLayoutData((Object)gridData);
        this.widthText = new Text(widthComposite, 2048);
        this.widthText.addVerifyListener(e -> {
            if (e.character != '\u0000' && e.keyCode != 8 && e.keyCode != 127 && !Character.isDigit(e.character)) {
                e.doit = false;
            }
        });
        gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(5);
        this.widthText.setLayoutData((Object)gridData);
        this.widthText.addModifyListener(e -> this.updateWidth());
        this.setWidthEnabled(false);
        return this.widthText;
    }

    private void setWidthEnabled(boolean enabled) {
        this.widthLabel.setEnabled(enabled);
        this.widthText.setEnabled(enabled);
    }

    Control createVisibleTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(MarkerMessages.MarkerPreferences_VisibleColumnsTitle);
        Table table = new Table(composite, 2050);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = this.convertWidthInCharsToPixels(20);
        data.heightHint = table.getItemHeight() * 15;
        table.setLayoutData((Object)data);
        TableColumn column = new TableColumn(table, 0);
        column.setText(MarkerMessages.MarkerPreferences_VisibleColumnsTitle);
        Listener columnResize = event -> column.setWidth(table.getClientArea().width);
        table.addListener(11, columnResize);
        this.visibleViewer = new TableViewer(table);
        this.visibleViewer.setLabelProvider((IBaseLabelProvider)this.doGetLabelProvider());
        this.visibleViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.visibleViewer.addSelectionChangedListener(event -> this.handleVisibleSelection(event.getSelection()));
        table.addListener(8, event -> this.handleToNonVisibleButton(event));
        this.visibleViewer.setInput(this.getVisible());
        return table;
    }

    Control createInvisibleTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(MarkerMessages.MarkerPreferences_HiddenColumnsTitle);
        ViewerColumnsDialog.applyDialogFont((Control)label);
        this.tableLabelSize = label.computeSize(-1, -1);
        Table table = new Table(composite, 2050);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = this.convertWidthInCharsToPixels(20);
        data.heightHint = table.getItemHeight() * 15;
        table.setLayoutData((Object)data);
        TableColumn column = new TableColumn(table, 0);
        column.setText(MarkerMessages.MarkerPreferences_HiddenColumnsTitle);
        Listener columnResize = event -> column.setWidth(table.getClientArea().width);
        table.addListener(11, columnResize);
        this.nonVisibleViewer = new TableViewer(table);
        this.nonVisibleViewer.setLabelProvider((IBaseLabelProvider)this.doGetLabelProvider());
        this.nonVisibleViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.nonVisibleViewer.addSelectionChangedListener(event -> this.handleNonVisibleSelection(event.getSelection()));
        table.addListener(8, event -> this.handleToVisibleButton(event));
        this.nonVisibleViewer.setInput(this.getNonVisible());
        return table;
    }

    Control createMoveButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)new GridData(0, 4, false, true));
        Composite bttArea = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        bttArea.setLayout((Layout)layout);
        bttArea.setLayoutData((Object)new GridData(0, 0x1000000, false, true));
        this.toVisibleBtt = new Button(bttArea, 8);
        this.toVisibleBtt.setText(MarkerMessages.MarkerPreferences_MoveRight);
        this.setButtonLayoutData(this.toVisibleBtt);
        ((GridData)this.toVisibleBtt.getLayoutData()).verticalIndent = this.tableLabelSize.y;
        this.toVisibleBtt.addListener(13, event -> this.handleToVisibleButton(event));
        this.toVisibleBtt.setEnabled(false);
        this.toNonVisibleBtt = new Button(bttArea, 8);
        this.toNonVisibleBtt.setText(MarkerMessages.MarkerPreferences_MoveLeft);
        this.setButtonLayoutData(this.toNonVisibleBtt);
        this.toNonVisibleBtt.addListener(13, event -> this.handleToNonVisibleButton(event));
        this.toNonVisibleBtt.setEnabled(false);
        return bttArea;
    }

    void handleNonVisibleSelection(ISelection selection) {
        Object[] nvKeys = ((IStructuredSelection)selection).toArray();
        this.toVisibleBtt.setEnabled(nvKeys.length > 0);
        if (this.visibleViewer.getControl().isFocusControl() && this.getVisible().size() <= 1) {
            this.handleStatusUdpate(1, MarkerMessages.MarkerPreferences_AtLeastOneVisibleColumn);
        } else {
            this.handleStatusUdpate(1, this.getDefaultMessage());
        }
    }

    void handleVisibleSelection(ISelection selection) {
        List selVCols = ((IStructuredSelection)selection).toList();
        List<T> allVCols = this.getVisible();
        this.toNonVisibleBtt.setEnabled(selVCols.size() > 0 && allVCols.size() > selVCols.size());
        IColumnInfoProvider infoProvider = this.doGetColumnInfoProvider();
        boolean moveDown = !selVCols.isEmpty();
        boolean moveUp = !selVCols.isEmpty();
        for (Object columnObj : selVCols) {
            if (!infoProvider.isColumnMovable(columnObj)) {
                moveUp = false;
                moveDown = false;
                break;
            }
            int i = allVCols.indexOf(columnObj);
            if (i == 0) {
                moveUp = false;
                if (!moveDown) break;
            }
            if (i != allVCols.size() - 1) continue;
            moveDown = false;
            if (!moveUp) break;
        }
        this.upButton.setEnabled(moveUp);
        this.downButton.setEnabled(moveDown);
        boolean edit = selVCols.size() == 1 ? infoProvider.isColumnResizable(selVCols.get(0)) : false;
        this.setWidthEnabled(edit);
        if (edit) {
            int width = infoProvider.getColumnWidth(selVCols.get(0));
            this.widthText.setText(Integer.toString(width));
        } else {
            this.widthText.setText("");
        }
    }

    void handleDownButton(Event e) {
        IStructuredSelection selection = this.visibleViewer.getStructuredSelection();
        List selVCols = selection.toList();
        List<T> allVCols = this.getVisible();
        IColumnUpdater updater = this.doGetColumnUpdater();
        int i = selVCols.size() - 1;
        while (i >= 0) {
            Object colObj = selVCols.get(i);
            int index = allVCols.indexOf(colObj);
            updater.setColumnIndex(colObj, index + 1);
            allVCols.remove(index);
            allVCols.add(index + 1, colObj);
            --i;
        }
        this.visibleViewer.refresh();
        this.handleVisibleSelection((ISelection)selection);
    }

    void handleUpButton(Event e) {
        IStructuredSelection selection = this.visibleViewer.getStructuredSelection();
        List selVCols = selection.toList();
        List<T> allVCols = this.getVisible();
        IColumnUpdater updater = this.doGetColumnUpdater();
        int i = 0;
        while (i < selVCols.size()) {
            Object colObj = selVCols.get(i);
            int index = allVCols.indexOf(colObj);
            updater.setColumnIndex(colObj, index - 1);
            allVCols.remove(index);
            allVCols.add(index - 1, colObj);
            ++i;
        }
        this.visibleViewer.refresh();
        this.handleVisibleSelection((ISelection)selection);
    }

    void handleToVisibleButton(Event e) {
        IStructuredSelection selection = this.nonVisibleViewer.getStructuredSelection();
        List selVCols = selection.toList();
        this.getNonVisible().removeAll(selVCols);
        List<T> list = this.getVisible();
        list.addAll(selVCols);
        this.updateVisibility(selVCols, true);
        this.updateIndices(this.getVisible());
        this.updateIndices(this.getNonVisible());
        this.visibleViewer.refresh();
        this.visibleViewer.setSelection((ISelection)selection);
        this.nonVisibleViewer.refresh();
        this.handleVisibleSelection((ISelection)selection);
        this.handleNonVisibleSelection((ISelection)this.nonVisibleViewer.getStructuredSelection());
    }

    protected void handleToNonVisibleButton(Event e) {
        if (this.visibleViewer.getControl().isFocusControl() && this.getVisible().size() <= 1) {
            this.handleStatusUdpate(1, MarkerMessages.MarkerPreferences_AtLeastOneVisibleColumn);
            return;
        }
        IStructuredSelection structuredSelection = this.visibleViewer.getStructuredSelection();
        List selVCols = structuredSelection.toList();
        this.getVisible().removeAll(selVCols);
        this.getNonVisible().addAll(selVCols);
        this.updateVisibility(selVCols, false);
        this.updateIndices(this.getVisible());
        this.updateIndices(this.getNonVisible());
        this.nonVisibleViewer.refresh();
        this.nonVisibleViewer.setSelection((ISelection)structuredSelection);
        this.visibleViewer.refresh();
        this.handleVisibleSelection((ISelection)structuredSelection);
        this.handleNonVisibleSelection((ISelection)structuredSelection);
    }

    void updateIndices(List<T> list) {
        ListIterator<T> iterator = list.listIterator();
        IColumnUpdater<T> updater = this.doGetColumnUpdater();
        while (iterator.hasNext()) {
            updater.setColumnIndex(iterator.next(), iterator.previousIndex());
        }
    }

    void updateVisibility(List<T> list, boolean visibility) {
        IColumnUpdater<T> updater = this.doGetColumnUpdater();
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            updater.setColumnVisible(iterator.next(), visibility);
        }
    }

    @Override
    protected void performDefaults() {
        this.refreshViewers();
        super.performDefaults();
    }

    void refreshViewers() {
        if (this.nonVisibleViewer != null) {
            this.nonVisibleViewer.refresh();
        }
        if (this.visibleViewer != null) {
            this.visibleViewer.refresh();
        }
    }

    public List<T> getVisible() {
        if (this.visible == null) {
            this.visible = new ArrayList<T>();
        }
        return this.visible;
    }

    public List<T> getNonVisible() {
        if (this.nonVisible == null) {
            this.nonVisible = new ArrayList<T>();
        }
        return this.nonVisible;
    }

    ITableLabelProvider doGetLabelProvider() {
        return this.getLabelProvider();
    }

    protected abstract ITableLabelProvider getLabelProvider();

    IColumnInfoProvider<T> doGetColumnInfoProvider() {
        return this.getColumnInfoProvider();
    }

    protected abstract IColumnInfoProvider<T> getColumnInfoProvider();

    IColumnUpdater<T> doGetColumnUpdater() {
        return this.getColumnUpdater();
    }

    protected abstract IColumnUpdater<T> getColumnUpdater();

    private void updateWidth() {
        try {
            int width = Integer.parseInt(this.widthText.getText());
            Object data = this.visibleViewer.getStructuredSelection().getFirstElement();
            if (data != null) {
                IColumnUpdater<Object> updater = this.getColumnUpdater();
                updater.setColumnWidth(data, width);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static interface IColumnInfoProvider<T> {
        public int getColumnIndex(T var1);

        public int getColumnWidth(T var1);

        public boolean isColumnVisible(T var1);

        public boolean isColumnMovable(T var1);

        public boolean isColumnResizable(T var1);
    }

    public static interface IColumnUpdater<T> {
        public void setColumnVisible(T var1, boolean var2);

        public void setColumnMovable(T var1, boolean var2);

        public void setColumnIndex(T var1, int var2);

        public void setColumnResizable(T var1, boolean var2);

        public void setColumnWidth(T var1, int var2);
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return this.getText(element);
        }
    }

    static class TestData {
        final Object key;
        final int keyIndex;
        int newIndex;
        int width;
        boolean visibility;
        boolean movable;
        boolean resizable;

        TestData(Object key, int currIndex) {
            this.key = key;
            this.keyIndex = currIndex;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this.key);
            return 31 * result + this.keyIndex;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void other;
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TestData)) {
                return false;
            }
            TestData testData = (TestData)obj;
            return Objects.equals(this.key, other.key) && this.keyIndex == other.keyIndex;
        }

        public String toString() {
            return this.key.toString();
        }

        private static ViewerColumnsDialog<TestData> getColumnsDialog(Shell shell, TestData[] colums) {
            ViewerColumnsDialog<TestData> dialog = new ViewerColumnsDialog<TestData>(shell){

                @Override
                protected IColumnInfoProvider<TestData> getColumnInfoProvider() {
                    return TestData.getInfoProvider();
                }

                @Override
                protected ITableLabelProvider getLabelProvider() {
                    return new TableLabelProvider();
                }

                @Override
                protected IColumnUpdater<TestData> getColumnUpdater() {
                    return TestData.getUpdater();
                }
            };
            dialog.setColumnsObjs(colums);
            return dialog;
        }

        private static IColumnUpdater<TestData> getUpdater() {
            return new IColumnUpdater<TestData>(){

                @Override
                public void setColumnWidth(TestData columnObj, int newWidth) {
                    columnObj.width = newWidth;
                }

                @Override
                public void setColumnVisible(TestData columnObj, boolean visible) {
                    columnObj.visibility = visible;
                }

                @Override
                public void setColumnResizable(TestData columnObj, boolean resizable) {
                }

                @Override
                public void setColumnMovable(TestData columnObj, boolean movable) {
                    columnObj.movable = movable;
                }

                @Override
                public void setColumnIndex(TestData columnObj, int index) {
                    columnObj.newIndex = index;
                }
            };
        }

        private static IColumnInfoProvider<TestData> getInfoProvider() {
            return new IColumnInfoProvider<TestData>(){

                @Override
                public boolean isColumnVisible(TestData columnObj) {
                    return columnObj.visibility;
                }

                @Override
                public boolean isColumnResizable(TestData columnObj) {
                    return columnObj.resizable;
                }

                @Override
                public boolean isColumnMovable(TestData columnObj) {
                    return columnObj.movable;
                }

                @Override
                public int getColumnWidth(TestData columnObj) {
                    return columnObj.width;
                }

                @Override
                public int getColumnIndex(TestData columnObj) {
                    return columnObj.newIndex;
                }
            };
        }

        private static TestData[] genData(int count) {
            Object[] cols = new String[count];
            int i = 0;
            while (i < cols.length) {
                cols[i] = "Column-" + (i + 1);
                ++i;
            }
            Random random = new Random();
            boolean[] visibility = new boolean[cols.length];
            Arrays.fill(visibility, true);
            int ranInt = random.nextInt() % cols.length;
            int i2 = 0;
            while (i2 < ranInt) {
                visibility[random.nextInt((int)ranInt)] = false;
                ++i2;
            }
            boolean[] resizable = new boolean[cols.length];
            Arrays.fill(resizable, true);
            ranInt = random.nextInt() % cols.length;
            int i3 = 0;
            while (i3 < ranInt) {
                resizable[random.nextInt((int)ranInt)] = false;
                ++i3;
            }
            boolean[] movable = new boolean[cols.length];
            Arrays.fill(movable, true);
            ranInt = random.nextInt() % cols.length;
            int i4 = 0;
            while (i4 < ranInt) {
                movable[random.nextInt((int)ranInt)] = false;
                ++i4;
            }
            int[] widths = new int[cols.length];
            Arrays.fill(widths, 100);
            return TestData.generateColumnsData(cols, visibility, resizable, movable, widths);
        }

        public static TestData[] generateColumnsData(Object[] keys, boolean[] visibility, boolean[] resizable, boolean[] movable, int[] widths) {
            TestData[] colData = new TestData[keys.length];
            int m = 0;
            int n = 0;
            int i = 0;
            while (i < colData.length) {
                TestData data = new TestData(keys[i], i);
                data.visibility = visibility[i];
                data.resizable = resizable[i];
                data.movable = movable[i];
                data.width = widths[i];
                data.newIndex = data.visibility ? m++ : n++;
                colData[i] = data;
                ++i;
            }
            return colData;
        }

        public static void main(String[] args) {
            Display display = new Display();
            Shell shell = new Shell(display);
            shell.setLayout((Layout)new FillLayout());
            ViewerColumnsDialog<TestData> dialog = TestData.getColumnsDialog(shell, TestData.genData(100));
            dialog.open();
            shell.dispose();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            display.dispose();
        }
    }
}

