/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.utils.CommonUtils;

public class SQLPreferenceConstants {
    public static final String INSERT_SINGLE_PROPOSALS_AUTO = "SQLEditor.ContentAssistant.insert.single.proposal";
    public static final String ENABLE_HIPPIE = "SQLEditor.ContentAssistant.activate.hippie";
    public static final String ENABLE_AUTO_ACTIVATION = "SQLEditor.ContentAssistant.auto.activation.enable";
    public static final String AUTOCOMPLETION_MODE = "SQLEditor.ContentAssistant.experimental.mode";
    public static final String ADVANCED_HIGHLIGHTING_ENABLE = "SQLEditor.Highlighting.advanced.enable";
    public static final String READ_METADATA_FOR_SEMANTIC_ANALYSIS = "SQLEditor.Semantics.metadata.read.enable";
    public static final String VALIDATE_FUNCTIONS = "SQLEditor.Semantics.validate.functions.enable";
    public static final String ENABLE_KEYSTROKE_ACTIVATION = "SQLEditor.ContentAssistant.auto.keystrokes.activation";
    public static final String AUTO_ACTIVATION_DELAY = "SQLEditor.ContentAssistant.auto.activation.delay";
    public static final String PROPOSAL_INSERT_CASE = "SQLEditor.ContentAssistant.insert.case";
    public static final String TAB_AUTOCOMPLETION = "SQLEditor.ContentAssistant.autocompletion.tab";
    public static final String PROPOSAL_REPLACE_WORD = "SQLEditor.ContentAssistant.replace.word";
    public static final String PROPOSAL_SORT_ALPHABETICALLY = "SQLEditor.ContentAssistant.proposals.sort.alphabetically";
    public static final String HIDE_DUPLICATE_PROPOSALS = "SQLEditor.ContentAssistant.hide.duplicates";
    public static final String INSERT_SPACE_AFTER_PROPOSALS = "SQLEditor.ContentAssistant.insert.space.after.proposal";
    public static final String USE_GLOBAL_ASSISTANT = "SQLEditor.ContentAssistant.use.global.search";
    public static final String PROPOSALS_MATCH_CONTAINS = "SQLEditor.ContentAssistant.matching.fuzzy";
    public static final String SHOW_COLUMN_PROCEDURES = "SQLEditor.ContentAssistant.show.column.procedures";
    public static final String SHOW_SERVER_HELP_TOPICS = "SQLEditor.ContentAssistant.show.helpTopics";
    public static final String SHOW_VALUES = "SQLEditor.ContentAssistant.show.values";
    public static final String QUALIFIED_COLUMN_NAMES = "SQLEditor.ContentAssistant.qualified.column.names";
    public static final String MARK_OCCURRENCES_UNDER_CURSOR = "SQLEditor.markOccurrences";
    public static final String MARK_OCCURRENCES_FOR_SELECTION = "SQLEditor.markOccurrences.forSelection";
    public static final String FOLDING_ENABLED = "SQLEditor.Folding.enabled";
    public static final String PROBLEM_MARKERS_ENABLED = "SQLEditor.problemMarkers.enabled";
    public static final String AUTO_SAVE_ON_CHANGE = "SQLEditor.autoSaveOnChange";
    public static final String AUTO_SAVE_ON_CLOSE = "SQLEditor.autoSaveOnClose";
    public static final String AUTO_SAVE_ON_EXECUTE = "SQLEditor.autoSaveOnExecute";
    public static final String AUTO_SAVE_ACTIVE_SCHEMA = "SQLEditor.autoSaveActiveSchema";
    public static final String SQLEDITOR_CLOSE_SINGLE_QUOTES = "SQLEditor.closeSingleQuotes";
    public static final String SQLEDITOR_CLOSE_DOUBLE_QUOTES = "SQLEditor.closeDoubleQuotes";
    public static final String SQLEDITOR_CLOSE_BRACKETS = "SQLEditor.closeBrackets";
    public static final String SQLEDITOR_CLOSE_COMMENTS = "SQLEditor.closeComments";
    public static final String SQLEDITOR_CLOSE_BLOCKS = "SQLEditor.closeBlocks";
    public static final String SMART_WORD_ITERATOR = "SQLEditor.smartWordIterator";
    public static final String MATCHING_BRACKETS = "SQLEditor.matchingBrackets";
    public static final String MATCHING_BRACKETS_HIGHLIGHT = "SQLEditor.matchingBracketsHighlight";
    public static final String MATCHING_BRACKETS_COLOR = "AbstractTextEditor.Color.Foreground";
    public static final String RESET_CURSOR_ON_EXECUTE = "SQLEditor.resetCursorOnExecute";
    public static final String MAXIMIZE_EDITOR_ON_SCRIPT_EXECUTE = "SQLEditor.maxEditorOnScriptExecute";
    public static final String SHOW_STATISTICS_ON_EXECUTION = "SQLEditor.showStatisticsForQueriesWithResults";
    public static final String SET_SELECTION_TO_STATISTICS_TAB = "SQLEditor.setSelectionToStatisticsTab";
    public static final String CLOSE_INCLUDED_SCRIPT_AFTER_EXECUTION = "SQLEditor.closeIncludedScriptAfterExecution";
    public static final String SQL_FORMAT_KEYWORD_CASE_AUTO = "SQLEditor.format.keywordCaseAuto";
    public static final String SQL_FORMAT_EXTRACT_FROM_SOURCE = "SQLEditor.format.extractFromSource";
    public static final String SQL_FORMAT_BOLD_KEYWORDS = "SQLEditor.format.boldKeywords";
    public static final String SQL_FORMAT_ACTIVE_QUERY = "SQLEditor.format.activeQuery";
    public static final String BEEP_ON_QUERY_END = "SQLEditor.beepOnQueryEnd";
    public static final String REFRESH_DEFAULTS_AFTER_EXECUTE = "SQLEditor.refreshDefaultsAfterExecute";
    public static final String CLEAR_OUTPUT_BEFORE_EXECUTE = "SQLEditor.clearOutputBeforeExecute";
    public static final String RESULT_SET_MAX_TABS_PER_QUERY = "SQLEditor.resultSet.queryTabLimit";
    public static final String RESULT_SET_CLOSE_ON_ERROR = "SQLEditor.resultSet.closeOnError";
    public static final String RESULT_SET_REPLACE_CURRENT_TAB = "SQLEditor.resultSet.replaceCurrentTab";
    public static final String RESULT_SET_ORIENTATION = "SQLEditor.resultSet.orientation";
    public static final String RESULTS_PANEL_RATIO = "SQLEditor.resultSet.ratio";
    public static final String MULTIPLE_RESULTS_PER_TAB = "SQLEditor.resultSet.multipleResultsPerTab";
    public static final String EXTRA_PANEL_RATIO = "SQLEditor.extraPanels.ratio";
    public static final String EXTRA_PANEL_LOCATION = "SQLEditor.extraPanels.location";
    public static final String OUTPUT_PANEL_AUTO_SHOW = "SQLEditor.outputPanel.autoShow";
    public static final String SCRIPT_BIND_EMBEDDED_READ = "SQLEditor.script.bind.embedded.read";
    public static final String SCRIPT_BIND_EMBEDDED_WRITE = "SQLEditor.script.bind.embedded.write";
    public static final String SCRIPT_BIND_COMMENT_TYPE = "SQLEditor.script.bind.commentType";
    public static final String SCRIPT_BIG_FILE_LENGTH_BOUNDARY = "SQLEditor.script.bigFileLengthBoundary";
    public static final String SCRIPT_DELETE_EMPTY = "script.delete.empty";
    public static final String SCRIPT_AUTO_FOLDERS = "script.auto.folders";
    public static final String SCRIPT_CREATE_CONNECTION_FOLDERS = "script.auto.connection.folders";
    public static final String SCRIPT_TITLE_PATTERN = "script.title.pattern";
    public static final String SCRIPT_FILE_NAME_PATTERN = "script.file.name.pattern";
    public static final String VAR_CONNECTION_NAME = "connectionName";
    public static final String VAR_FILE_NAME = "fileName";
    public static final String VAR_FILE_EXT = "fileExt";
    public static final String VAR_DRIVER_NAME = "driverName";
    public static final String VAR_ACTIVE_DATABASE = "database";
    public static final String VAR_ACTIVE_SCHEMA = "schema";
    public static final String VAR_ACTIVE_PROJECT = "projectName";
    public static final String SCRIPT_COMMIT_TYPE = "script.commit.type";
    public static final String SCRIPT_COMMIT_LINES = "script.commit.lines";
    public static final String SCRIPT_ERROR_HANDLING = "script.error.handling";
    public static final String SCRIPT_FETCH_RESULT_SETS = "script.fetch.resultset";
    public static final String NEW_SCRIPT_TEMPLATE_ENABLED = "new.script.template.enabled";
    public static final String NEW_SCRIPT_TEMPLATE = "new.script.template";
    public static final String STATEMENT_INVALIDATE_BEFORE_EXECUTE = "statement.invalidate.before.execute";
    public static final String STATEMENT_TIMEOUT = "statement.timeout";
    public static final String EDITOR_SEPARATE_CONNECTION = "database.editor.separate.connection";
    public static final String EDITOR_CONNECT_ON_ACTIVATE = "database.editor.connect.on.activate";
    public static final String EDITOR_CONNECT_ON_EXECUTE = "database.editor.connect.on.execute";
    public static final String CONFIRM_RUNNING_QUERY_CLOSE = "close_running_query";
    public static final String CONFIRM_RESULT_TABS_CLOSE = "close_result_tabs";
    public static final String CONFIRM_SAVE_SQL_CONSOLE = "save_sql_console";
    public static final String DEFAULT_SQL_EDITOR_OPEN_COMMAND = "SQLEditor.defaultOpenCommand";
    public static final String LOCATION_RIGHT = "right";
    public static final String LOCATION_BOTTOM = "bottom";
    public static final String LOCATION_RESULTS = "results";

    public static enum EmptyScriptCloseBehavior {
        NOTHING(SQLEditorMessages.script_close_behavior_do_not_delete),
        DELETE_NEW(SQLEditorMessages.script_close_behavior_delete_only_new_scripts),
        DELETE_ALWAYS(SQLEditorMessages.script_close_behavior_delete_always);

        private final String title;

        private EmptyScriptCloseBehavior(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public static EmptyScriptCloseBehavior getByTitle(String title) {
            EmptyScriptCloseBehavior[] emptyScriptCloseBehaviorArray = EmptyScriptCloseBehavior.values();
            int n = emptyScriptCloseBehaviorArray.length;
            int n2 = 0;
            while (n2 < n) {
                EmptyScriptCloseBehavior escb = emptyScriptCloseBehaviorArray[n2];
                if (escb.getTitle().equals(title)) {
                    return escb;
                }
                ++n2;
            }
            return NOTHING;
        }

        public static EmptyScriptCloseBehavior getByName(String name) {
            return switch (name) {
                case "true" -> DELETE_NEW;
                case "false" -> NOTHING;
                default -> (EmptyScriptCloseBehavior)CommonUtils.valueOf(EmptyScriptCloseBehavior.class, (String)name, (Enum)NOTHING);
            };
        }
    }

    public static enum SQLAutocompletionMode {
        DEFAULT(true, false, SQLEditorMessages.pref_page_sql_completion_label_completion_mode_default),
        NEW(false, true, SQLEditorMessages.pref_page_sql_completion_label_completion_mode_new_engine),
        COMBINED(true, true, SQLEditorMessages.pref_page_sql_completion_label_completion_mode_combined);

        public final boolean useOldAnalyzer;
        public final boolean useNewAnalyzer;
        public final String title;

        private SQLAutocompletionMode(boolean useOldAnalyzer, boolean useNewAnalyzer, String title) {
            this.useOldAnalyzer = useOldAnalyzer;
            this.useNewAnalyzer = useNewAnalyzer;
            this.title = title;
        }

        public String getName() {
            return this.toString();
        }

        public static SQLAutocompletionMode valueByName(String name) {
            return (SQLAutocompletionMode)CommonUtils.valueOf(SQLAutocompletionMode.class, (String)name, (Enum)DEFAULT);
        }

        @NotNull
        public static SQLAutocompletionMode fromPreferences(@NotNull DBPPreferenceStore preferenceStore) {
            return SQLAutocompletionMode.valueByName(preferenceStore.getString(SQLPreferenceConstants.AUTOCOMPLETION_MODE));
        }
    }

    public static enum SQLCompletionObjectNameFormKind {
        DEFAULT(false, false, SQLEditorMessages.pref_page_sql_default),
        UNQUALIFIED(true, false, SQLEditorMessages.pref_page_sql_completion_label_use_short_names),
        QUALIFIED(false, true, SQLEditorMessages.pref_page_sql_completion_label_use_long_names);

        public final boolean unqualified;
        public final boolean qualified;
        @NotNull
        public final String title;

        private SQLCompletionObjectNameFormKind(@NotNull boolean unqualified, boolean qualified, String title) {
            this.unqualified = unqualified;
            this.qualified = qualified;
            this.title = title;
        }

        @NotNull
        public String getName() {
            return this.toString();
        }

        public void setToPreferences(@NotNull DBPPreferenceStore preferenceStore) {
            preferenceStore.setValue("SQLEditor.ContentAssistant.proposals.short.name", this.unqualified);
            preferenceStore.setValue("SQLEditor.ContentAssistant.proposals.long.name", this.qualified);
        }

        @NotNull
        private static SQLCompletionObjectNameFormKind fromBooleanFlags(boolean useShortName, boolean useFqNames) {
            if (useShortName) {
                return UNQUALIFIED;
            }
            if (useFqNames) {
                return QUALIFIED;
            }
            return DEFAULT;
        }

        @NotNull
        public static SQLCompletionObjectNameFormKind getFromPreferences(@NotNull DBPPreferenceStore preferenceStore) {
            return SQLCompletionObjectNameFormKind.fromBooleanFlags(preferenceStore.getBoolean("SQLEditor.ContentAssistant.proposals.short.name"), preferenceStore.getBoolean("SQLEditor.ContentAssistant.proposals.long.name"));
        }

        @NotNull
        public static SQLCompletionObjectNameFormKind getDefaultFromPreferences(@NotNull DBPPreferenceStore preferenceStore) {
            return SQLCompletionObjectNameFormKind.fromBooleanFlags(preferenceStore.getDefaultBoolean("SQLEditor.ContentAssistant.proposals.short.name"), preferenceStore.getDefaultBoolean("SQLEditor.ContentAssistant.proposals.long.name"));
        }
    }

    public static enum StatisticsTabOnExecutionBehavior {
        NEVER("Only when no data"),
        FOR_MULTIPLE_QUERIES("For multiple queries with results"),
        ALWAYS("Always");

        private final String title;

        private StatisticsTabOnExecutionBehavior(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public static StatisticsTabOnExecutionBehavior getByTitle(String title) {
            StatisticsTabOnExecutionBehavior[] statisticsTabOnExecutionBehaviorArray = StatisticsTabOnExecutionBehavior.values();
            int n = statisticsTabOnExecutionBehaviorArray.length;
            int n2 = 0;
            while (n2 < n) {
                StatisticsTabOnExecutionBehavior statisticsTabOnExecution = statisticsTabOnExecutionBehaviorArray[n2];
                if (statisticsTabOnExecution.getTitle().equals(title)) {
                    return statisticsTabOnExecution;
                }
                ++n2;
            }
            return NEVER;
        }

        public static StatisticsTabOnExecutionBehavior getByName(String name) {
            return switch (name) {
                case "true" -> FOR_MULTIPLE_QUERIES;
                case "false" -> NEVER;
                default -> (StatisticsTabOnExecutionBehavior)CommonUtils.valueOf(StatisticsTabOnExecutionBehavior.class, (String)name, (Enum)NEVER);
            };
        }
    }
}

