<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Bundle\TwigBundle\CacheWarmer;

@trigger_error('The '.TemplateCacheCacheWarmer::class.' class is deprecated since version 4.4 and will be removed in 5.0; use Twig instead.', \E_USER_DEPRECATED);

use Psr\Container\ContainerInterface;
use Symfony\Bundle\FrameworkBundle\CacheWarmer\TemplateFinderInterface;
use Symfony\Bundle\TwigBundle\DependencyInjection\CompatibilityServiceSubscriberInterface as ServiceSubscriberInterface;
use Symfony\Component\Finder\Finder;
use Symfony\Component\HttpKernel\CacheWarmer\CacheWarmerInterface;
use Twig\Environment;
use Twig\Error\Error;

/**
 * Generates the Twig cache for all templates.
 *
 * This warmer must be registered after TemplatePathsCacheWarmer,
 * as the Twig loader will need the cache generated by it.
 *
 * @author Fabien Potencier <fabien@symfony.com>
 *
 * @deprecated since version 4.4, to be removed in 5.0; use Twig instead.
 */
class TemplateCacheCacheWarmer implements CacheWarmerInterface, ServiceSubscriberInterface
{
    protected $container;
    protected $finder;
    private $paths;

    /**
     * @param array $paths Additional twig paths to warm
     */
    public function __construct(ContainerInterface $container, TemplateFinderInterface $finder = null, array $paths = [])
    {
        // We don't inject the Twig environment directly as it depends on the
        // template locator (via the loader) which might be a cached one.
        // The cached template locator is available once the TemplatePathsCacheWarmer
        // has been warmed up.
        // But it can also be null if templating has been disabled.
        $this->container = $container;
        $this->finder = $finder;
        $this->paths = $paths;
    }

    /**
     * Warms up the cache.
     *
     * @param string $cacheDir The cache directory
     */
    public function warmUp($cacheDir)
    {
        if (null === $this->finder) {
            return;
        }

        $twig = $this->container->get('twig');

        $templates = $this->finder->findAllTemplates();

        foreach ($this->paths as $path => $namespace) {
            $templates = array_merge($templates, $this->findTemplatesInFolder($namespace, $path));
        }

        foreach ($templates as $template) {
            try {
                $twig->load($template);
            } catch (Error $e) {
                // problem during compilation, give up
            }
        }
    }

    /**
     * Checks whether this warmer is optional or not.
     *
     * @return bool always true
     */
    public function isOptional()
    {
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public static function getSubscribedServices()
    {
        return [
            'twig' => Environment::class,
        ];
    }

    /**
     * Find templates in the given directory.
     */
    private function findTemplatesInFolder(?string $namespace, string $dir): array
    {
        if (!is_dir($dir)) {
            return [];
        }

        $templates = [];
        $finder = new Finder();

        foreach ($finder->files()->followLinks()->in($dir) as $file) {
            $name = $file->getRelativePathname();
            $templates[] = $namespace ? sprintf('@%s/%s', $namespace, $name) : $name;
        }

        return $templates;
    }
}
