/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.get.GetResponse;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.GetDataObjectResponse;
import org.opensearch.remote.metadata.client.SdkClientDelegate;
import org.opensearch.secure_sm.AccessController;

public abstract class AbstractSdkClient
implements SdkClientDelegate {
    protected static final String DEFAULT_TENANT = "DEFAULT_TENANT";
    public static final TimeValue DEFAULT_GLOBAL_RESOURCE_CACHE_TTL = TimeValue.timeValueMillis((long)300000L);
    protected static final Map<String, Tuple<GetDataObjectResponse, Long>> GLOBAL_RESOURCES_CACHE = new ConcurrentHashMap<String, Tuple<GetDataObjectResponse, Long>>();
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected String tenantIdField;
    protected String globalTenantId;
    protected TimeValue globalResourceCacheTTL;
    protected String remoteMetadataType;
    protected String remoteMetadataEndpoint;
    protected String region;
    protected String serviceName;

    @Override
    public void initialize(Map<String, String> metadataSettings) {
        this.tenantIdField = metadataSettings.get("tenant_id");
        this.remoteMetadataType = metadataSettings.get("remote_metadata_type");
        this.remoteMetadataEndpoint = metadataSettings.get("remote_metadata_endpoint");
        this.region = metadataSettings.get("remote_metadata_region");
        this.serviceName = metadataSettings.get("remote_metadata_service_name");
        this.globalTenantId = metadataSettings.get("global_tenant_id");
        this.globalResourceCacheTTL = Optional.ofNullable(metadataSettings.get("remote_metadata_global_resource_cache_ttl")).filter(x -> !Strings.isNullOrEmpty((String)x)).map(x -> TimeValue.parseTimeValue((String)x, (TimeValue)DEFAULT_GLOBAL_RESOURCE_CACHE_TTL, (String)"remote_metadata_global_resource_cache_ttl")).filter(x -> x.getMillis() >= 0L).orElse(DEFAULT_GLOBAL_RESOURCE_CACHE_TTL);
    }

    protected <T> CompletionStage<T> executePrivilegedAsync(Supplier<T> action, Executor executor) {
        return CompletableFuture.supplyAsync(() -> AccessController.doPrivileged((Supplier)action), executor);
    }

    protected boolean shouldUseId(String id) {
        if ("".equals(id)) {
            throw new IllegalArgumentException("if _id is specified it must not be empty");
        }
        return id != null;
    }

    public CompletionStage<GetDataObjectResponse> handleOSDocumentBasedResponse(GetDataObjectRequest request, CompletionStage<GetDataObjectResponse> dataFetched) {
        return dataFetched.thenCompose(response -> {
            if (response == null || response.getResponse() == null || !response.getResponse().isExists()) {
                return CompletableFuture.completedFuture(response);
            }
            if (!this.isGlobalResource((GetDataObjectResponse)response)) {
                return CompletableFuture.completedFuture(response);
            }
            return this.addToGlobalResourceCache(request, dataFetched);
        });
    }

    protected CompletionStage<GetDataObjectResponse> addToGlobalResourceCache(GetDataObjectRequest request, CompletionStage<GetDataObjectResponse> dataFetchedWithGlobalTenantId) {
        return dataFetchedWithGlobalTenantId.thenCompose(res -> {
            GetResponse getResponse = res.getResponse();
            if (getResponse == null || !getResponse.isExists()) {
                return CompletableFuture.completedFuture(res);
            }
            if (this.globalResourceCacheTTL.getMillis() == 0L) {
                return CompletableFuture.completedFuture(this.replaceGlobalTenantId(request, (GetDataObjectResponse)res));
            }
            GLOBAL_RESOURCES_CACHE.put(this.buildGlobalCacheKey(request.index(), request.id()), (Tuple<GetDataObjectResponse, Long>)new Tuple(res, (Object)System.currentTimeMillis()));
            return CompletableFuture.completedFuture(this.getGlobalResourceDataFromCache(request));
        });
    }

    protected GetDataObjectResponse getGlobalResourceDataFromCache(GetDataObjectRequest request) {
        long currentTime;
        String checkingKey = this.buildGlobalCacheKey(request.index(), request.id());
        Tuple tuple = GLOBAL_RESOURCES_CACHE.computeIfPresent(checkingKey, (arg_0, arg_1) -> this.lambda$getGlobalResourceDataFromCache$0(currentTime = System.currentTimeMillis(), arg_0, arg_1));
        return tuple != null ? this.replaceGlobalTenantId(request, (GetDataObjectResponse)tuple.v1()) : null;
    }

    private GetDataObjectResponse replaceGlobalTenantId(GetDataObjectRequest request, GetDataObjectResponse response) {
        GetResponse getResponse = response.getResponse();
        assert (getResponse != null) : "GetResponse shouldn't be null";
        response.source().put("tenant_id", request.tenantId());
        try {
            JsonNode jsonNode = OBJECT_MAPPER.readTree(getResponse.toString());
            ((ObjectNode)jsonNode.get("_source")).put("tenant_id", Optional.ofNullable(request.tenantId()).orElse(DEFAULT_TENANT));
            XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, OBJECT_MAPPER.writeValueAsString((Object)jsonNode));
            return ((GetDataObjectResponse.Builder)((GetDataObjectResponse.Builder)GetDataObjectResponse.builder().id(request.id())).parser(parser)).source(response.source()).build();
        }
        catch (IOException e) {
            throw new OpenSearchStatusException("Failed to parse cached global response, please check configuration with system admin!", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public CompletionStage<Boolean> isGlobalResource(String index, String id, Executor executor, Boolean isMultiTenancyEnabled) {
        if (Boolean.FALSE.equals(isMultiTenancyEnabled) || Strings.isNullOrEmpty((String)this.globalTenantId)) {
            return CompletableFuture.completedFuture(false);
        }
        GetDataObjectRequest request = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(index)).id(id)).tenantId(this.globalTenantId)).build();
        CompletionStage<GetDataObjectResponse> dataFetchedWithGlobalTenantId = this.innerGetDataObjectAsync(request, executor, isMultiTenancyEnabled);
        return dataFetchedWithGlobalTenantId.thenCompose(response -> {
            boolean isGlobalResource = this.isGlobalResource((GetDataObjectResponse)response);
            if (isGlobalResource) {
                this.addToGlobalResourceCache(request, dataFetchedWithGlobalTenantId);
            }
            return CompletableFuture.completedFuture(isGlobalResource);
        });
    }

    protected abstract CompletionStage<GetDataObjectResponse> innerGetDataObjectAsync(GetDataObjectRequest var1, Executor var2, Boolean var3);

    protected String buildGlobalCacheKey(String index, String id) {
        return index + ":" + id;
    }

    protected boolean isGlobalResource(GetDataObjectResponse response) {
        return Optional.ofNullable(response.getResponse()).map(GetResponse::getSourceAsMap).map(x -> x.get("tenant_id")).map(y -> Objects.equals(y, this.globalTenantId)).orElse(false);
    }

    private /* synthetic */ Tuple lambda$getGlobalResourceDataFromCache$0(long currentTime, String key, Tuple value) {
        if (currentTime - (Long)value.v2() > this.globalResourceCacheTTL.getMillis()) {
            return null;
        }
        return value;
    }
}

