/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.provenance.primitives;

import com.oracle.labs.mlrg.olcut.provenance.PrimitiveProvenance;
import java.util.Objects;

public final class CharProvenance
implements PrimitiveProvenance<Character> {
    private static final long serialVersionUID = 1L;
    private final String key;
    private final char value;

    public CharProvenance(String key, char value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Character getValue() {
        return Character.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CharProvenance)) {
            return false;
        }
        CharProvenance that = (CharProvenance)o;
        return this.key.equals(that.key) && this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.key, Character.valueOf(this.value));
    }

    public String toString() {
        return "" + this.value;
    }
}

