/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.tools;

import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.indexInsight.IndexInsight;
import org.opensearch.ml.common.indexInsight.MLIndexInsightType;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.transport.indexInsight.MLIndexInsightGetAction;
import org.opensearch.ml.common.transport.indexInsight.MLIndexInsightGetRequest;
import org.opensearch.ml.common.utils.ToolUtils;
import org.opensearch.ml.engine.tools.MLModelTool;
import org.opensearch.ml.repackage.com.google.common.annotations.VisibleForTesting;
import org.opensearch.transport.client.Client;

@ToolAnnotation(value="IndexInsightTool")
public class IndexInsightTool
implements Tool {
    @Generated
    private static final Logger log = LogManager.getLogger(IndexInsightTool.class);
    public static final String TYPE = "IndexInsightTool";
    private Map<String, Object> attributes;
    private String description = DEFAULT_DESCRIPTION;
    private Client client;
    @VisibleForTesting
    static String DEFAULT_DESCRIPTION = "Use this tool to get details of one index according to different task type, including STATISTICAL_DATA: the data distribution and index mapping of the index, FIELD_DESCRIPTION: The description of each column, LOG_RELATED_INDEX_CHECK: Whether the index is related to log/trace and whether it contains trace/log fields";
    public static final String STRICT_FIELD = "strict";
    public static final String DEFAULT_INPUT_SCHEMA = "        {\n            \"type\": \"object\",\n            \"properties\": {\n                \"index\": {\n                    \"type\": \"string\",\n                    \"description\": \"OpenSearch index name\"\n                },\n                \"question\": {\n                    \"type\": \"string\",\n                    \"description\": \"Natural language question to query data from opensearch index\"\n                }\n            }\n        },\n        \"strict\": false\n      }\n";
    public static final Map<String, Object> DEFAULT_ATTRIBUTES = Map.of("input_schema", "        {\n            \"type\": \"object\",\n            \"properties\": {\n                \"index\": {\n                    \"type\": \"string\",\n                    \"description\": \"OpenSearch index name\"\n                },\n                \"question\": {\n                    \"type\": \"string\",\n                    \"description\": \"Natural language question to query data from opensearch index\"\n                }\n            }\n        },\n        \"strict\": false\n      }\n", "strict", false);

    public IndexInsightTool(Client client) {
        this.client = client;
    }

    public <T> void run(Map<String, String> originalParameters, ActionListener<T> listener) {
        try {
            Map parameters = ToolUtils.extractInputParameters(originalParameters, this.attributes);
            String indexName = (String)parameters.get("indexName");
            MLIndexInsightType taskType = MLIndexInsightType.fromString((String)((String)parameters.get("taskType")));
            MLIndexInsightGetRequest mlIndexInsightGetRequest = new MLIndexInsightGetRequest(indexName, taskType, null);
            this.client.execute((ActionType)MLIndexInsightGetAction.INSTANCE, (ActionRequest)mlIndexInsightGetRequest, ActionListener.wrap(r -> {
                IndexInsight indexInsight = r.getIndexInsight();
                listener.onResponse((Object)indexInsight.toString());
            }, arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            log.error("Failed to run index insight tool.", (Throwable)e);
            listener.onFailure(e);
        }
    }

    public String getType() {
        return TYPE;
    }

    public String getVersion() {
        return null;
    }

    public String getName() {
        return TYPE;
    }

    public void setName(String name) {
    }

    public boolean validate(Map<String, String> parameters) {
        return true;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setClient(Client client) {
        this.client = client;
    }

    public static class Factory
    implements Tool.Factory<IndexInsightTool> {
        private Client client;
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<MLModelTool> clazz = MLModelTool.class;
            synchronized (MLModelTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client) {
            this.client = client;
        }

        public IndexInsightTool create(Map<String, Object> map) {
            return new IndexInsightTool(this.client);
        }

        public String getDefaultDescription() {
            return DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return IndexInsightTool.TYPE;
        }

        public Map<String, Object> getDefaultAttributes() {
            return DEFAULT_ATTRIBUTES;
        }

        public String getDefaultVersion() {
            return null;
        }
    }
}

