"use strict";
// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.CIPHERTEXT_STRUCTURE = exports.KEY_DERIVATION_LABEL = exports.DERIVED_BRANCH_KEY_LENGTH = exports.PROVIDER_ID_HIERARCHY_AS_BYTES = exports.PROVIDER_ID_HIERARCHY = exports.DECRYPT_FLAGS = exports.ENCRYPT_FLAGS = exports.KDF_DIGEST_ALGORITHM_SHA_256 = exports.CACHE_ENTRY_ID_DIGEST_ALGORITHM = exports.ACTIVE_AS_BYTES = void 0;
const material_management_1 = require("@aws-crypto/material-management");
exports.ACTIVE_AS_BYTES = Buffer.from('ACTIVE', 'utf-8');
exports.CACHE_ENTRY_ID_DIGEST_ALGORITHM = 'sha384';
exports.KDF_DIGEST_ALGORITHM_SHA_256 = 'sha256';
exports.ENCRYPT_FLAGS = material_management_1.KeyringTraceFlag.WRAPPING_KEY_ENCRYPTED_DATA_KEY |
    material_management_1.KeyringTraceFlag.WRAPPING_KEY_SIGNED_ENC_CTX;
exports.DECRYPT_FLAGS = material_management_1.KeyringTraceFlag.WRAPPING_KEY_DECRYPTED_DATA_KEY |
    material_management_1.KeyringTraceFlag.WRAPPING_KEY_VERIFIED_ENC_CTX;
exports.PROVIDER_ID_HIERARCHY = 'aws-kms-hierarchy';
exports.PROVIDER_ID_HIERARCHY_AS_BYTES = Buffer.from(exports.PROVIDER_ID_HIERARCHY, 'utf-8');
exports.DERIVED_BRANCH_KEY_LENGTH = 32;
// export const CACHE_ENTRY_ID_LENGTH = 32
exports.KEY_DERIVATION_LABEL = Buffer.from(exports.PROVIDER_ID_HIERARCHY, 'utf-8');
exports.CIPHERTEXT_STRUCTURE = {
    saltLength: 16,
    ivLength: 12,
    branchKeyVersionCompressedLength: 16,
    // Encrypted Key is of variable length
    authTagLength: 16,
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uc3RhbnRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2NvbnN0YW50cy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsb0VBQW9FO0FBQ3BFLHNDQUFzQzs7O0FBRXRDLHlFQUFrRTtBQUVyRCxRQUFBLGVBQWUsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxPQUFPLENBQUMsQ0FBQTtBQUNoRCxRQUFBLCtCQUErQixHQUFHLFFBQVEsQ0FBQTtBQUMxQyxRQUFBLDRCQUE0QixHQUFHLFFBQVEsQ0FBQTtBQUN2QyxRQUFBLGFBQWEsR0FDeEIsc0NBQWdCLENBQUMsK0JBQStCO0lBQ2hELHNDQUFnQixDQUFDLDJCQUEyQixDQUFBO0FBQ2pDLFFBQUEsYUFBYSxHQUN4QixzQ0FBZ0IsQ0FBQywrQkFBK0I7SUFDaEQsc0NBQWdCLENBQUMsNkJBQTZCLENBQUE7QUFDbkMsUUFBQSxxQkFBcUIsR0FBRyxtQkFBbUIsQ0FBQTtBQUMzQyxRQUFBLDhCQUE4QixHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQ3ZELDZCQUFxQixFQUNyQixPQUFPLENBQ1IsQ0FBQTtBQUNZLFFBQUEseUJBQXlCLEdBQUcsRUFBRSxDQUFBO0FBQzNDLDBDQUEwQztBQUM3QixRQUFBLG9CQUFvQixHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsNkJBQXFCLEVBQUUsT0FBTyxDQUFDLENBQUE7QUFDbEUsUUFBQSxvQkFBb0IsR0FBRztJQUNsQyxVQUFVLEVBQUUsRUFBRTtJQUNkLFFBQVEsRUFBRSxFQUFFO0lBQ1osZ0NBQWdDLEVBQUUsRUFBRTtJQUNwQyxzQ0FBc0M7SUFDdEMsYUFBYSxFQUFFLEVBQUU7Q0FDbEIsQ0FBQSJ9