/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util.net;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.NetworkChannel;
import java.util.Arrays;

public class NetUtils {
    public static SocketOption<Integer> getTcpKeepIdleSocketOptionOrNull() {
        return NetUtils.getExtendedSocketOptionOrNull("TCP_KEEPIDLE");
    }

    public static SocketOption<Integer> getTcpKeepIntervalSocketOptionOrNull() {
        return NetUtils.getExtendedSocketOptionOrNull("TCP_KEEPINTERVAL");
    }

    public static SocketOption<Integer> getTcpKeepCountSocketOptionOrNull() {
        return NetUtils.getExtendedSocketOptionOrNull("TCP_KEEPCOUNT");
    }

    private static <T> SocketOption<T> getExtendedSocketOptionOrNull(String fieldName) {
        try {
            Class<?> extendedSocketOptionsClass = Class.forName("jdk.net.ExtendedSocketOptions");
            Field field = extendedSocketOptionsClass.getField(fieldName);
            return (SocketOption)field.get(null);
        }
        catch (Exception t) {
            return null;
        }
    }

    public static void tryEnsureReasonableKeepAliveConfig(NetworkChannel socketChannel) {
        block7: {
            assert (socketChannel != null);
            try {
                if (socketChannel.supportedOptions().contains(StandardSocketOptions.SO_KEEPALIVE)) {
                    Boolean keepalive = socketChannel.getOption(StandardSocketOptions.SO_KEEPALIVE);
                    assert (keepalive != null);
                    if (keepalive.booleanValue()) {
                        for (SocketOption option : Arrays.asList(NetUtils.getTcpKeepIdleSocketOptionOrNull(), NetUtils.getTcpKeepIntervalSocketOptionOrNull())) {
                            NetUtils.setMinValueForSocketOption(socketChannel, option, 300);
                        }
                    }
                }
            }
            catch (Exception e) {
                if ($assertionsDisabled || e instanceof IOException) break block7;
                throw new AssertionError((Object)e);
            }
        }
    }

    private static void setMinValueForSocketOption(NetworkChannel socketChannel, SocketOption<Integer> option, int minValue) {
        block5: {
            if (option != null && socketChannel.supportedOptions().contains(option)) {
                try {
                    Integer currentIdleVal = socketChannel.getOption(option);
                    assert (currentIdleVal != null);
                    if (currentIdleVal > minValue) {
                        socketChannel.setOption(option, minValue);
                    }
                }
                catch (Exception e) {
                    if ($assertionsDisabled || e instanceof IOException) break block5;
                    throw new AssertionError((Object)e);
                }
            }
        }
    }
}

