/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.time.Duration;
import java.util.Objects;
import org.apache.kafka.streams.kstream.EmitStrategy;

public class DslWindowParams {
    private final String name;
    private final Duration retentionPeriod;
    private final Duration windowSize;
    private final boolean retainDuplicates;
    private final EmitStrategy emitStrategy;
    private final boolean isSlidingWindow;
    private final boolean isTimestamped;

    public DslWindowParams(String name, Duration retentionPeriod, Duration windowSize, boolean retainDuplicates, EmitStrategy emitStrategy, boolean isSlidingWindow, boolean isTimestamped) {
        this.isTimestamped = isTimestamped;
        Objects.requireNonNull(name);
        this.name = name;
        this.retentionPeriod = retentionPeriod;
        this.windowSize = windowSize;
        this.retainDuplicates = retainDuplicates;
        this.emitStrategy = emitStrategy;
        this.isSlidingWindow = isSlidingWindow;
    }

    public String name() {
        return this.name;
    }

    public Duration retentionPeriod() {
        return this.retentionPeriod;
    }

    public Duration windowSize() {
        return this.windowSize;
    }

    public boolean retainDuplicates() {
        return this.retainDuplicates;
    }

    public EmitStrategy emitStrategy() {
        return this.emitStrategy;
    }

    public boolean isSlidingWindow() {
        return this.isSlidingWindow;
    }

    public boolean isTimestamped() {
        return this.isTimestamped;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DslWindowParams that = (DslWindowParams)o;
        return this.retainDuplicates == that.retainDuplicates && Objects.equals(this.name, that.name) && Objects.equals(this.retentionPeriod, that.retentionPeriod) && Objects.equals(this.windowSize, that.windowSize) && Objects.equals(this.emitStrategy, that.emitStrategy) && Objects.equals(this.isSlidingWindow, that.isSlidingWindow) && Objects.equals(this.isTimestamped, that.isTimestamped);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.retentionPeriod, this.windowSize, this.retainDuplicates, this.emitStrategy, this.isSlidingWindow, this.isTimestamped);
    }

    public String toString() {
        return "DslWindowParams{name='" + this.name + "', retentionPeriod=" + String.valueOf(this.retentionPeriod) + ", windowSize=" + String.valueOf(this.windowSize) + ", retainDuplicates=" + this.retainDuplicates + ", emitStrategy=" + String.valueOf(this.emitStrategy) + ", isSlidingWindow=" + this.isSlidingWindow + ", isTimestamped=" + this.isTimestamped + "}";
    }
}

