/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.DefaultXmlSuppressionProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.Language;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import icons.OpenapiIcons;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.MavenSchemaProvider;
import org.jetbrains.idea.maven.dom.model.MavenDomConfiguration;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProfile;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomSettingsModel;
import org.jetbrains.idea.maven.dom.references.MavenModelClassesProperties;
import org.jetbrains.idea.maven.dom.references.MavenPsiElementWrapper;
import org.jetbrains.idea.maven.dom.references.MavenPsiReference;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.plugins.api.MavenPluginDescriptor;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenSettingsCache;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.vfs.MavenPropertiesVirtualFileSystem;

public class MavenPropertyPsiReference
extends MavenPsiReference
implements LocalQuickFixProvider {
    public static final String TIMESTAMP_PROP = "maven.build.timestamp";
    public static final String MULTIPROJECT_DIR_PROP = "maven.multiModuleProjectDirectory";
    public static final Set<String> PROPS_RESOLVING_TO_MY_ELEMENT = Set.of("maven.build.timestamp", "build.timestamp", "maven.home", "maven.version", "maven.build.version");
    @Nullable
    protected final MavenDomProjectModel myProjectDom;
    protected final MavenProject myMavenProject;
    private final boolean mySoft;

    public MavenPropertyPsiReference(MavenProject mavenProject, PsiElement element, String text, TextRange range, boolean isSoft) {
        super(element, text, range);
        this.myMavenProject = mavenProject;
        this.mySoft = isSoft;
        this.myProjectDom = MavenDomUtil.getMavenDomProjectModel(this.myProject, mavenProject.getFile());
    }

    @Nullable
    public PsiElement resolve() {
        PsiElement result2 = this.doResolve();
        if (result2 == null && MavenDomUtil.isMavenFile(this.getElement()) && (result2 = this.tryResolveToActivationSection()) == null) {
            return null;
        }
        if (result2 instanceof XmlTag) {
            XmlTagChild[] children = ((XmlTag)result2).getValue().getChildren();
            if (children.length != 1 || !(children[0] instanceof Navigatable)) {
                return result2;
            }
            return new MavenPsiElementWrapper(result2, (Navigatable)children[0]);
        }
        return result2;
    }

    private PsiElement tryResolveToActivationSection() {
        for (XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlTag.class); xmlTag != null; xmlTag = xmlTag.getParentTag()) {
            if (!xmlTag.getName().equals("profile")) continue;
            XmlTag activation = xmlTag.findFirstSubTag("activation");
            if (activation == null) break;
            for (XmlTag propertyTag : activation.findSubTags("property")) {
                XmlTag nameTag = propertyTag.findFirstSubTag("name");
                if (nameTag == null || !nameTag.getValue().getTrimmedText().equals(this.myText)) continue;
                return nameTag;
            }
            break;
        }
        return null;
    }

    @Nullable
    protected PsiElement doResolve() {
        PsiElement res;
        MavenDomProjectModel domProjectModel;
        PsiElement element;
        PsiElement element2;
        String[] split;
        XmlTag result2;
        boolean notFound;
        XmlTag result3;
        PsiElement res2;
        MavenDomProjectModel domProjectModel2;
        boolean hasPrefix = false;
        String unprefixed = this.myText;
        if (this.myText.startsWith("pom.")) {
            unprefixed = this.myText.substring("pom.".length());
            hasPrefix = true;
        } else if (this.myText.startsWith("project.")) {
            unprefixed = this.myText.substring("project.".length());
            hasPrefix = true;
        }
        MavenProject mavenProject = this.myMavenProject;
        while (!(!unprefixed.startsWith("parent.") || unprefixed.equals("parent.groupId") || unprefixed.equals("parent.artifactId") || unprefixed.equals("parent.version") || unprefixed.equals("parent.relativePath"))) {
            MavenId parentId = mavenProject.getParentId();
            if (parentId == null) {
                return null;
            }
            mavenProject = this.myProjectsManager.findProject(parentId);
            if (mavenProject == null) {
                return null;
            }
            unprefixed = unprefixed.substring("parent.".length());
        }
        if (unprefixed.equals("basedir") || hasPrefix && mavenProject == this.myMavenProject && unprefixed.equals("baseUri")) {
            return this.getBaseDir(mavenProject);
        }
        if (PROPS_RESOLVING_TO_MY_ELEMENT.contains(this.myText)) {
            return this.myElement;
        }
        if (this.myText.equals(MULTIPROJECT_DIR_PROP)) {
            MavenProject rootProject = this.myProjectsManager.findRootProject(this.myMavenProject);
            if (rootProject == null) {
                return null;
            }
            return this.getBaseDir(rootProject);
        }
        if (hasPrefix && (domProjectModel2 = MavenDomUtil.getMavenDomProjectModel(this.myProject, mavenProject.getFile())) != null && (res2 = this.resolveModelProperty(domProjectModel2, unprefixed, new HashSet<DomElement>())) != null) {
            return res2;
        }
        if (mavenProject.getMavenConfig().containsKey(this.myText)) {
            return this.resolveConfigFileProperty(".mvn/maven.config", mavenProject.getMavenConfig().get(this.myText));
        }
        if (mavenProject.getJvmConfig().containsKey(this.myText)) {
            return this.resolveConfigFileProperty(".mvn/jvm.config", mavenProject.getJvmConfig().get(this.myText));
        }
        MavenRunnerSettings runnerSettings = MavenRunner.getInstance(this.myProject).getSettings();
        if (runnerSettings.getMavenProperties().containsKey(this.myText) || runnerSettings.getVmOptions().contains("-D" + this.myText + "=")) {
            return this.myElement;
        }
        if (MavenUtil.getPropertiesFromMavenOpts().containsKey(this.myText)) {
            return this.myElement;
        }
        MavenDomProfile profile = (MavenDomProfile)DomUtil.findDomElement((PsiElement)this.myElement, MavenDomProfile.class);
        if (profile != null && (result3 = MavenDomProjectProcessorUtils.findProperty(profile.getProperties(), this.myText)) != null) {
            return result3;
        }
        MavenDomConfiguration pluginCfg = (MavenDomConfiguration)DomUtil.findDomElement((PsiElement)this.myElement, MavenDomConfiguration.class);
        if (pluginCfg != null && !(notFound = MavenPluginDescriptor.processDescriptors((Processor<? super MavenPluginDescriptor>)((Processor)descriptor2 -> {
            if (descriptor2.properties != null) {
                for (MavenPluginDescriptor.ModelProperty property : descriptor2.properties) {
                    if (!property.insideConfigurationOnly || !property.name.equals(this.myText)) continue;
                    return false;
                }
            }
            return true;
        }), pluginCfg))) {
            return this.myElement;
        }
        if (this.myProjectDom != null && (result2 = MavenDomProjectProcessorUtils.searchProperty(this.myText, this.myProjectDom, this.myProject)) != null) {
            return result2;
        }
        if (this.myProjectDom != null && MavenPropertyResolver.containsActiveDependencyPropertiesPlugin(mavenProject) && ((split = this.myText.split(":")).length == 3 || split.length == 4)) {
            String groupId = split[0];
            String artifactId = split[1];
            String type = split[2];
            String classifier = split.length == 4 ? split[3] : null;
            Set<MavenDomDependency> results = MavenDomProjectProcessorUtils.searchDependencyUsages(this.myProjectDom, groupId, artifactId);
            if (results.size() == 1) {
                return results.iterator().next().getXmlTag();
            }
            List filteredResults = ContainerUtil.filter(results, dep -> {
                boolean isClassifierMatched = StringUtil.isEmpty((String)classifier) && StringUtil.isEmpty((String)dep.getClassifier().getStringValue());
                boolean isTypeMatched = "jar".equals(type) && StringUtil.isEmpty((String)dep.getType().getStringValue());
                return (isTypeMatched |= StringUtil.equals((CharSequence)type, (CharSequence)dep.getType().getStringValue())) && (isClassifierMatched |= StringUtil.equals((CharSequence)classifier, (CharSequence)dep.getClassifier().getStringValue()));
            });
            if (!filteredResults.isEmpty()) {
                return ((MavenDomDependency)filteredResults.iterator().next()).getXmlTag();
            }
        }
        if ("java.home".equals(this.myText) && (element2 = this.resolveToCustomSystemProperty("java.home", MavenUtil.getModuleJreHome(this.myProjectsManager, mavenProject))) != null) {
            return element2;
        }
        if ("java.version".equals(this.myText) && (element = this.resolveToCustomSystemProperty("java.version", MavenUtil.getModuleJavaVersion(this.myProjectsManager, mavenProject))) != null) {
            return element;
        }
        MavenPropertiesVirtualFileSystem mavenPropertiesVirtualFileSystem = MavenPropertiesVirtualFileSystem.getInstance();
        IProperty property = mavenPropertiesVirtualFileSystem.findSystemProperty(this.myProject, this.myText);
        if (property != null) {
            return property.getPsiElement();
        }
        if (this.myText.startsWith("env.") && (property = mavenPropertiesVirtualFileSystem.findEnvProperty(this.myProject, this.myText.substring("env.".length()))) != null) {
            return property.getPsiElement();
        }
        String textWithEnv = "env." + this.myText;
        property = mavenPropertiesVirtualFileSystem.findSystemProperty(this.myProject, textWithEnv);
        if (property != null) {
            return property.getPsiElement();
        }
        property = mavenPropertiesVirtualFileSystem.findEnvProperty(this.myProject, textWithEnv);
        if (property != null) {
            return property.getPsiElement();
        }
        if (!hasPrefix && (domProjectModel = MavenDomUtil.getMavenDomProjectModel(this.myProject, mavenProject.getFile())) != null && (res = this.resolveModelProperty(domProjectModel, unprefixed, new HashSet<DomElement>())) != null) {
            return res;
        }
        if (mavenProject.getProperties().containsKey(this.myText)) {
            return this.myElement;
        }
        if (this.myText.startsWith("settings.")) {
            return this.resolveSettingsModelProperty();
        }
        PsiElement resolved = this.resolveAsParsedVersion(this.myText, mavenProject);
        if (resolved != null) {
            return resolved;
        }
        return null;
    }

    @Nullable
    private PsiElement resolveToCustomSystemProperty(@NotNull String propertyName, @Nullable String propertyValue) {
        if (propertyName == null) {
            MavenPropertyPsiReference.$$$reportNull$$$0(0);
        }
        if (propertyValue == null) {
            return null;
        }
        PsiFile propFile = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("SystemProperties.properties", (Language)PropertiesLanguage.INSTANCE, (CharSequence)(propertyName + "=" + propertyValue));
        return ((IProperty)((PropertiesFile)propFile).getProperties().get(0)).getPsiElement();
    }

    private PsiDirectory getBaseDir(@NotNull MavenProject mavenProject) {
        if (mavenProject == null) {
            MavenPropertyPsiReference.$$$reportNull$$$0(1);
        }
        return PsiManager.getInstance((Project)this.myProject).findDirectory(mavenProject.getDirectoryFile());
    }

    private PsiElement resolveConfigFileProperty(@SystemIndependent String fileRelativePath, final String propertyValue) {
        PsiFile psiFile;
        VirtualFile mavenConfigFile;
        VirtualFile baseDir = VfsUtil.findFile((Path)MavenUtil.getBaseDir(this.myMavenProject.getDirectoryFile()), (boolean)false);
        if (baseDir != null && (mavenConfigFile = baseDir.findFileByRelativePath(fileRelativePath)) != null && (psiFile = PsiManager.getInstance((Project)this.myProject).findFile(mavenConfigFile)) != null && psiFile.getChildren().length > 0) {
            return new MavenPsiElementWrapper(psiFile.getFirstChild(), (Navigatable)psiFile){

                @Override
                public String getName() {
                    return propertyValue;
                }
            };
        }
        return this.myElement;
    }

    @Nullable
    private PsiElement resolveSettingsModelProperty() {
        if (!this.schemaHasProperty("http://maven.apache.org/xsd/settings-1.2.0.xsd", this.myText)) {
            return null;
        }
        for (VirtualFile each : MavenSettingsCache.getInstance(this.myProject).getEffectiveVirtualSettingsFiles()) {
            XmlTag result2;
            MavenDomSettingsModel settingsDom = MavenDomUtil.getMavenDomModel(this.myProject, each, MavenDomSettingsModel.class);
            if (settingsDom == null || (result2 = MavenDomUtil.findTag(settingsDom, this.myText)) == null) continue;
            return result2;
        }
        return this.myElement;
    }

    @Nullable
    private PsiElement resolveModelProperty(@NotNull MavenDomProjectModel projectDom, final @NotNull String path, final @NotNull Set<DomElement> recursionGuard) {
        if (projectDom == null) {
            MavenPropertyPsiReference.$$$reportNull$$$0(2);
        }
        if (path == null) {
            MavenPropertyPsiReference.$$$reportNull$$$0(3);
        }
        if (recursionGuard == null) {
            MavenPropertyPsiReference.$$$reportNull$$$0(4);
        }
        if (!recursionGuard.add(projectDom)) {
            return null;
        }
        String pathWithProjectPrefix = "project." + path;
        if (!(MavenModelClassesProperties.isPathValid("org.apache.maven.project.MavenProject", path) || MavenModelClassesProperties.isPathValid("org.apache.maven.model.Model", path) || this.schemaHasProperty(this.getSchemaUrl(), pathWithProjectPrefix))) {
            return null;
        }
        XmlTag result2 = MavenDomUtil.findTag(projectDom, pathWithProjectPrefix);
        if (result2 != null) {
            return result2;
        }
        if (pathWithProjectPrefix.equals("project.groupId") || pathWithProjectPrefix.equals("project.version")) {
            return MavenDomUtil.findTag(projectDom, "project.parent." + path);
        }
        result2 = (PsiElement)new MavenDomProjectProcessorUtils.DomParentProjectFileProcessor<PsiElement>(this.myProjectsManager){

            @Override
            protected PsiElement doProcessParent(VirtualFile parentFile) {
                MavenDomProjectModel parentProjectDom = MavenDomUtil.getMavenDomProjectModel(MavenPropertyPsiReference.this.myProject, parentFile);
                if (parentProjectDom == null) {
                    return null;
                }
                return MavenPropertyPsiReference.this.resolveModelProperty(parentProjectDom, path, recursionGuard);
            }
        }.process(projectDom);
        if (result2 != null) {
            return result2;
        }
        return this.myElement;
    }

    private boolean schemaHasProperty(String schema, String property) {
        return this.processSchema(schema, (eachProperty, descriptor2) -> {
            if (eachProperty.equals(property)) {
                return true;
            }
            return null;
        }) != null;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            MavenPropertyPsiReference.$$$reportNull$$$0(5);
        }
        return ElementManipulators.handleContentChange((PsiElement)this.myElement, (TextRange)this.myRange, (String)newElementName);
    }

    public Object @NotNull [] getVariants() {
        ArrayList<Object> result2 = new ArrayList<Object>();
        this.collectVariants(result2, new HashSet<String>());
        Object[] objectArray = ArrayUtil.toObjectArray(result2);
        if (objectArray == null) {
            MavenPropertyPsiReference.$$$reportNull$$$0(6);
        }
        return objectArray;
    }

    protected void collectVariants(List<Object> result2, Set<String> variants) {
        int prefixLength = 0;
        if (this.myText.startsWith("pom.")) {
            prefixLength = "pom.".length();
        } else if (this.myText.startsWith("project.")) {
            prefixLength = "project.".length();
        }
        MavenProject mavenProject = this.myMavenProject;
        while (this.myText.startsWith("parent.", prefixLength)) {
            MavenId parentId = mavenProject.getParentId();
            if (parentId == null) {
                return;
            }
            mavenProject = this.myProjectsManager.findProject(parentId);
            if (mavenProject == null) {
                return;
            }
            prefixLength += "parent.".length();
        }
        String prefix = prefixLength == 0 ? null : this.myText.substring(0, prefixLength);
        PsiDirectory baseDir = this.getBaseDir(mavenProject);
        MavenPropertyPsiReference.addVariant(result2, "basedir", baseDir, prefix, OpenapiIcons.RepositoryLibraryLogo);
        if (prefix == null) {
            result2.add(MavenPropertyPsiReference.createLookupElement(baseDir, "project.baseUri", OpenapiIcons.RepositoryLibraryLogo));
            result2.add(MavenPropertyPsiReference.createLookupElement(baseDir, "pom.baseUri", OpenapiIcons.RepositoryLibraryLogo));
            result2.add(LookupElementBuilder.create((String)MULTIPROJECT_DIR_PROP).withIcon(OpenapiIcons.RepositoryLibraryLogo));
            for (String string : PROPS_RESOLVING_TO_MY_ELEMENT) {
                result2.add(LookupElementBuilder.create((String)string).withIcon(OpenapiIcons.RepositoryLibraryLogo));
            }
        }
        this.processSchema(this.getSchemaUrl(), (property, descriptor2) -> {
            if (property.startsWith("project.")) {
                MavenPropertyPsiReference.addVariant(result2, property.substring("project.".length()), descriptor2, prefix, OpenapiIcons.RepositoryLibraryLogo);
            }
            return null;
        });
        this.processSchema("http://maven.apache.org/xsd/settings-1.2.0.xsd", (property, descriptor2) -> {
            result2.add(MavenPropertyPsiReference.createLookupElement(descriptor2, property, OpenapiIcons.RepositoryLibraryLogo));
            return null;
        });
        this.collectPropertiesVariants(result2, variants);
        this.collectSystemEnvProperties("System.properties", null, result2, variants);
        this.collectSystemEnvProperties("Environment.properties", "env.", result2, variants);
        MavenRunnerSettings runnerSettings = MavenRunner.getInstance(this.myProject).getSettings();
        for (String prop : runnerSettings.getMavenProperties().keySet()) {
            if (!variants.add(prefix)) continue;
            result2.add(LookupElementBuilder.create((String)prop).withIcon(PlatformIcons.PROPERTY_ICON));
        }
        for (String prop : MavenUtil.getPropertiesFromMavenOpts().keySet()) {
            if (!variants.add(prop)) continue;
            result2.add(LookupElementBuilder.create((String)prop).withIcon(PlatformIcons.PROPERTY_ICON));
        }
        for (String property3 : this.myMavenProject.getMavenConfig().keySet()) {
            if (!variants.add(property3)) continue;
            result2.add(LookupElementBuilder.create((String)property3).withIcon(PlatformIcons.PROPERTY_ICON));
        }
        for (String property2 : this.myMavenProject.getJvmConfig().keySet()) {
            if (!variants.add(property2)) continue;
            result2.add(LookupElementBuilder.create((String)property2).withIcon(PlatformIcons.PROPERTY_ICON));
        }
        for (Object key : this.myMavenProject.getProperties().keySet()) {
            String property4;
            if (!(key instanceof String) || !variants.add(property4 = (String)key)) continue;
            result2.add(LookupElementBuilder.create((String)property4).withIcon(PlatformIcons.PROPERTY_ICON));
        }
        MavenDomConfiguration mavenDomConfiguration = (MavenDomConfiguration)DomUtil.findDomElement((PsiElement)this.myElement, MavenDomConfiguration.class);
        if (mavenDomConfiguration != null) {
            MavenPluginDescriptor.processDescriptors((Processor<? super MavenPluginDescriptor>)((Processor)descriptor2 -> {
                if (descriptor2.properties != null) {
                    for (MavenPluginDescriptor.ModelProperty property : descriptor2.properties) {
                        if (!property.insideConfigurationOnly) continue;
                        result2.add(LookupElementBuilder.create((String)property.name).withIcon(PlatformIcons.PROPERTY_ICON));
                    }
                }
                return true;
            }), mavenDomConfiguration);
        }
    }

    private static void addVariant(List<Object> result2, String name, @NotNull Object element, @Nullable String prefix, @NotNull Icon icon) {
        Object nameWithPrefix;
        if (element == null) {
            MavenPropertyPsiReference.$$$reportNull$$$0(7);
        }
        if (icon == null) {
            MavenPropertyPsiReference.$$$reportNull$$$0(8);
        }
        if (prefix == null) {
            nameWithPrefix = name;
            result2.add(MavenPropertyPsiReference.createLookupElement(element, "pom." + name, icon));
            result2.add(MavenPropertyPsiReference.createLookupElement(element, "project." + name, icon));
        } else {
            nameWithPrefix = prefix + name;
        }
        result2.add(MavenPropertyPsiReference.createLookupElement(element, (String)nameWithPrefix, icon));
    }

    private void collectPropertiesVariants(List<Object> result2, Set<String> variants) {
        if (this.myProjectDom != null) {
            for (XmlTag xmlTag : MavenDomProjectProcessorUtils.collectProperties(this.myProjectDom, this.myProject)) {
                String propertyName = xmlTag.getName();
                if (!variants.add(propertyName)) continue;
                result2.add(MavenPropertyPsiReference.createLookupElement(xmlTag, propertyName, PlatformIcons.PROPERTY_ICON));
            }
        }
    }

    private void collectSystemEnvProperties(String propertiesFileName, @Nullable String prefix, List<Object> result2, Set<String> variants) {
        VirtualFile virtualFile = MavenPropertiesVirtualFileSystem.getInstance().findFileByPath(propertiesFileName);
        PropertiesFile file2 = MavenDomUtil.getPropertiesFile(this.myProject, virtualFile);
        MavenPropertyPsiReference.collectPropertiesFileVariants(file2, prefix, result2, variants);
    }

    protected static void collectPropertiesFileVariants(@Nullable PropertiesFile file2, @Nullable String prefix, List<Object> result2, Set<? super String> variants) {
        if (file2 == null) {
            return;
        }
        for (IProperty each : file2.getProperties()) {
            Object name = each.getKey();
            if (name == null) continue;
            if (prefix != null) {
                name = prefix + (String)name;
            }
            if (!variants.add((String)name)) continue;
            result2.add(MavenPropertyPsiReference.createLookupElement(each, (String)name, PlatformIcons.PROPERTY_ICON));
        }
    }

    private static LookupElement createLookupElement(@NotNull Object element, @NotNull String name, @Nullable Icon icon) {
        if (element == null) {
            MavenPropertyPsiReference.$$$reportNull$$$0(9);
        }
        if (name == null) {
            MavenPropertyPsiReference.$$$reportNull$$$0(10);
        }
        return LookupElementBuilder.create((Object)element, (String)name).withIcon(icon).withPresentableText(name);
    }

    @NotNull
    private String getSchemaUrl() {
        if (MavenDomUtil.isAtLeastMaven4(this.myVirtualFile, this.myProject) && this.myProjectDom != null && "4.1.0".equals(this.myProjectDom.getModelVersion().getValue())) {
            return "https://maven.apache.org/xsd/maven-4.1.0.xsd";
        }
        return "http://maven.apache.org/xsd/maven-4.0.0.xsd";
    }

    @Nullable
    private <T> T processSchema(String schema, SchemaProcessor<T> processor) {
        VirtualFile file2 = MavenSchemaProvider.getSchemaFile(schema);
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        XmlDocument document = xmlFile.getDocument();
        XmlNSDescriptor desc = (XmlNSDescriptor)document.getMetaData();
        XmlElementDescriptor[] descriptors = desc.getRootElementsDescriptors(document);
        return MavenPropertyPsiReference.doProcessSchema(descriptors, null, processor, new HashSet<XmlElementDescriptor>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T doProcessSchema(XmlElementDescriptor[] descriptors, String prefix, SchemaProcessor<T> processor, Set<XmlElementDescriptor> recursionGuard) {
        for (XmlElementDescriptor each : descriptors) {
            if (MavenPropertyPsiReference.isCollection(each) || !recursionGuard.add(each)) continue;
            try {
                T result2;
                Object name = each.getName();
                if (prefix != null) {
                    name = prefix + "." + (String)name;
                }
                if ((result2 = processor.process((String)name, each)) != null) {
                    T t = result2;
                    return t;
                }
                result2 = MavenPropertyPsiReference.doProcessSchema(each.getElementsDescriptors(null), (String)name, processor, recursionGuard);
                if (result2 == null) continue;
                T t = result2;
                return t;
            }
            finally {
                recursionGuard.remove(each);
            }
        }
        return null;
    }

    private static boolean isCollection(XmlElementDescriptor each) {
        XmlTag complexType;
        XmlTag declaration = (XmlTag)each.getDeclaration();
        return declaration != null && (complexType = declaration.findFirstSubTag("xs:complexType")) != null && complexType.findFirstSubTag("xs:sequence") != null;
    }

    @Override
    public boolean isSoft() {
        return this.mySoft;
    }

    public @NotNull LocalQuickFix @Nullable [] getQuickFixes() {
        return new LocalQuickFix[]{new MyLocalQuickFix()};
    }

    @Nullable
    private PsiElement resolveAsParsedVersion(@NotNull String propertyText, @NotNull MavenProject mavenProject) {
        String prefix;
        if (propertyText == null) {
            MavenPropertyPsiReference.$$$reportNull$$$0(11);
        }
        if (mavenProject == null) {
            MavenPropertyPsiReference.$$$reportNull$$$0(12);
        }
        if ((prefix = this.getBuildHelperParseablePrefix()) == null || !propertyText.startsWith(prefix + ".")) {
            return null;
        }
        MavenDomProjectModel domProjectModel = MavenDomUtil.getMavenDomProjectModel(this.myProject, mavenProject.getFile());
        if (domProjectModel == null) {
            return this.myElement;
        }
        XmlTag versionTag = MavenDomUtil.findTag(domProjectModel, "project.version");
        if (versionTag == null) {
            return this.myElement;
        }
        return versionTag;
    }

    @Nullable
    private String getBuildHelperParseablePrefix() {
        Element customPrefix;
        MavenPlugin buildHelperPlugin = this.myMavenProject.findPlugin("org.codehaus.mojo", "build-helper-maven-plugin");
        if (buildHelperPlugin == null) {
            return null;
        }
        Optional<MavenPlugin.Execution> execution = buildHelperPlugin.getExecutions().stream().filter(it -> it.getGoals().contains("parse-version")).findFirst();
        if (execution.isEmpty()) {
            return null;
        }
        String propertyPrefix = "parsedVersion";
        Element configuration = execution.get().getConfigurationElement();
        if (configuration != null && (customPrefix = configuration.getChild("propertyPrefix")) != null) {
            propertyPrefix = customPrefix.getTextTrim();
        }
        return propertyPrefix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDom";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursionGuard";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReference";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveToCustomSystemProperty";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBaseDir";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveModelProperty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addVariant";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveAsParsedVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    private static interface SchemaProcessor<T> {
        @Nullable
        public T process(@NotNull String var1, XmlElementDescriptor var2);
    }

    private static class MyLocalQuickFix
    implements LocalQuickFix {
        private MyLocalQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = MavenDomBundle.message("fix.ignore.unresolved.maven.property", new Object[0]);
            if (string == null) {
                MyLocalQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                MyLocalQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                MyLocalQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor2.getPsiElement();
            PsiElement psiElement = (PsiElement)ObjectUtils.notNull((Object)element.getFirstChild(), (Object)element);
            DefaultXmlSuppressionProvider xmlSuppressionProvider = new DefaultXmlSuppressionProvider();
            xmlSuppressionProvider.suppressForTag(psiElement, "UnresolvedMavenProperty");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReference$MyLocalQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReference$MyLocalQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

