/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledText;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.ProtoBufUtilKt;
import org.jetbrains.kotlin.metadata.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.GeneratedMessageLite;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererModifier;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0000\u001a\f\u0010\u000b\u001a\u00020\t*\u00020\nH\u0002\u001a$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014\u001a&\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"DECOMPILED_CODE_COMMENT", "", "DECOMPILED_COMMENT_FOR_PARAMETER", "FLEXIBLE_TYPE_COMMENT", "DECOMPILED_CONTRACT_STUB", "defaultDecompilerRendererOptions", "", "Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptions;", "mustNotBeWrittenToDecompiledText", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "syntheticMemberMustNotBeWrittenToDecompiledText", "buildDecompiledText", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledText;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "descriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptorRenderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "buildDecompiledTextImpl", "decompiler-to-psi"})
@SourceDebugExtension(value={"SMAP\nbuildDecompiledText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 buildDecompiledText.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/BuildDecompiledTextKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,277:1\n3301#2,10:278\n*S KotlinDebug\n*F\n+ 1 buildDecompiledText.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/BuildDecompiledTextKt\n*L\n233#1:278,10\n*E\n"})
public final class BuildDecompiledTextKt {
    public static final void defaultDecompilerRendererOptions(@NotNull DescriptorRendererOptions $this$defaultDecompilerRendererOptions) {
        Intrinsics.checkNotNullParameter($this$defaultDecompilerRendererOptions, "<this>");
        $this$defaultDecompilerRendererOptions.setWithDefinedIn(false);
        $this$defaultDecompilerRendererOptions.setClassWithPrimaryConstructor(true);
        $this$defaultDecompilerRendererOptions.setSecondaryConstructorsAsPrimary(false);
        $this$defaultDecompilerRendererOptions.setModifiers(DescriptorRendererModifier.ALL);
        $this$defaultDecompilerRendererOptions.setExcludedTypeAnnotationClasses(SetsKt.emptySet());
        $this$defaultDecompilerRendererOptions.setAlwaysRenderModifiers(true);
        $this$defaultDecompilerRendererOptions.setParameterNamesInFunctionalTypes(false);
        $this$defaultDecompilerRendererOptions.setDefaultParameterValueRenderer(BuildDecompiledTextKt::defaultDecompilerRendererOptions$lambda$0);
        $this$defaultDecompilerRendererOptions.setIncludePropertyConstant(true);
        $this$defaultDecompilerRendererOptions.setPropertyConstantRenderer(BuildDecompiledTextKt::defaultDecompilerRendererOptions$lambda$1);
        $this$defaultDecompilerRendererOptions.setPresentableUnresolvedTypes(true);
    }

    public static final boolean mustNotBeWrittenToDecompiledText(@NotNull CallableMemberDescriptor $this$mustNotBeWrittenToDecompiledText) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$mustNotBeWrittenToDecompiledText, "<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$mustNotBeWrittenToDecompiledText.getKind().ordinal()]) {
            case 1: 
            case 2: {
                bl = false;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            case 4: {
                bl = BuildDecompiledTextKt.syntheticMemberMustNotBeWrittenToDecompiledText($this$mustNotBeWrittenToDecompiledText);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final boolean syntheticMemberMustNotBeWrittenToDecompiledText(CallableMemberDescriptor $this$syntheticMemberMustNotBeWrittenToDecompiledText) {
        boolean bl;
        DeclarationDescriptor declarationDescriptor = $this$syntheticMemberMustNotBeWrittenToDecompiledText.getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor containingClass = classDescriptor;
        if (containingClass.getKind() == ClassKind.ENUM_CLASS) {
            Name[] nameArray = new Name[]{StandardNames.ENUM_VALUES, StandardNames.ENUM_ENTRIES, StandardNames.ENUM_VALUE_OF};
            bl = ArraysKt.contains(nameArray, $this$syntheticMemberMustNotBeWrittenToDecompiledText.getName());
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final DecompiledText buildDecompiledText(@NotNull FqName packageFqName, @NotNull List<? extends DeclarationDescriptor> descriptors, @NotNull DescriptorRenderer descriptorRenderer) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(descriptors, "descriptors");
        Intrinsics.checkNotNullParameter(descriptorRenderer, "descriptorRenderer");
        return BuildDecompiledTextKt.buildDecompiledTextImpl(packageFqName, descriptors, descriptorRenderer.withOptions(BuildDecompiledTextKt::buildDecompiledText$lambda$2));
    }

    private static final DecompiledText buildDecompiledTextImpl(FqName packageFqName, List<? extends DeclarationDescriptor> descriptors, DescriptorRenderer descriptorRenderer) {
        StringBuilder builder = new StringBuilder();
        BuildDecompiledTextKt.buildDecompiledTextImpl$appendDecompiledTextAndPackageName(builder, packageFqName);
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            BuildDecompiledTextKt.buildDecompiledTextImpl$appendDescriptor$default(builder, descriptorRenderer, declarationDescriptor, "", null, 16, null);
            builder.append("\n");
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return new DecompiledText(string);
    }

    private static final String defaultDecompilerRendererOptions$lambda$0(ValueParameterDescriptor valueParameterDescriptor) {
        Intrinsics.checkNotNullParameter(valueParameterDescriptor, "<unused var>");
        return "COMPILED_CODE";
    }

    private static final String defaultDecompilerRendererOptions$lambda$1(ConstantValue constantValue) {
        Intrinsics.checkNotNullParameter(constantValue, "<unused var>");
        return "COMPILED_CODE";
    }

    private static final Unit buildDecompiledText$lambda$2(DescriptorRendererOptions $this$withOptions) {
        Intrinsics.checkNotNullParameter($this$withOptions, "$this$withOptions");
        $this$withOptions.setRenderTypeExpansions(true);
        $this$withOptions.setRenderAbbreviatedTypeComments(true);
        return Unit.INSTANCE;
    }

    private static final void buildDecompiledTextImpl$appendDecompiledTextAndPackageName(StringBuilder builder, FqName $packageFqName) {
        builder.append("// IntelliJ API Decompiler stub source generated from a class file\n// Implementation of methods is not available");
        builder.append("\n\n");
        if (!$packageFqName.isRoot()) {
            builder.append("package ").append(RenderingUtilsKt.render($packageFqName)).append("\n\n");
        }
    }

    private static final void buildDecompiledTextImpl$appendDescriptor$newlineExceptFirst(Ref.BooleanRef firstPassed, StringBuilder builder) {
        if (firstPassed.element) {
            builder.append("\n");
        } else {
            firstPassed.element = true;
        }
    }

    private static final void buildDecompiledTextImpl$appendDescriptor(StringBuilder builder, DescriptorRenderer $descriptorRenderer, DeclarationDescriptor descriptor, String indent, Boolean lastEnumEntry) {
        StringBuilder stringBuilder;
        if (DescriptorUtils.isEnumEntry(descriptor)) {
            for (AnnotationDescriptor annotation : descriptor.getAnnotations()) {
                builder.append(DescriptorRenderer.renderAnnotation$default($descriptorRenderer, annotation, null, 2, null));
                builder.append(" ");
            }
            String string = descriptor.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
            builder.append(KtPsiUtilKt.quoteIfNeeded(string));
            Boolean bl = lastEnumEntry;
            Intrinsics.checkNotNull(bl);
            stringBuilder = builder.append(bl != false ? ";" : ",");
        } else {
            stringBuilder = builder.append(StringsKt.replace$default($descriptorRenderer.render(descriptor), "= ...", "/* = compiled code */", false, 4, null));
        }
        if (descriptor instanceof CallableDescriptor) {
            KotlinType kotlinType = ((CallableDescriptor)descriptor).getReturnType();
            Intrinsics.checkNotNull(kotlinType);
            if (FlexibleTypesKt.isFlexible(kotlinType)) {
                builder.append(" ").append("/* platform type */");
            }
        }
        if (descriptor instanceof FunctionDescriptor || descriptor instanceof PropertyDescriptor) {
            Object object2;
            Iterator<PropertyAccessorDescriptor> $this$buildDecompiledTextImpl_u24appendDescriptor_u24lambda_u243;
            if (((MemberDescriptor)descriptor).getModality() != Modality.ABSTRACT) {
                StringBuilder stringBuilder2;
                if (descriptor instanceof FunctionDescriptor) {
                    $this$buildDecompiledTextImpl_u24appendDescriptor_u24lambda_u243 = builder;
                    boolean object2 = false;
                    ((StringBuilder)((Object)$this$buildDecompiledTextImpl_u24appendDescriptor_u24lambda_u243)).append(" { ");
                    AbstractContractProvider abstractContractProvider = (AbstractContractProvider)((FunctionDescriptor)descriptor).getUserData(ContractProviderKey.INSTANCE);
                    if ((abstractContractProvider != null ? abstractContractProvider.getContractDescription() : null) != null) {
                        ((StringBuilder)((Object)$this$buildDecompiledTextImpl_u24appendDescriptor_u24lambda_u243)).append("contract { /* compiled contract */ }").append("; ");
                    }
                    stringBuilder2 = ((StringBuilder)((Object)$this$buildDecompiledTextImpl_u24appendDescriptor_u24lambda_u243)).append("/* compiled code */").append(" }");
                } else {
                    if (descriptor instanceof PropertyDescriptor && ((PropertyDescriptor)descriptor).isDelegated()) {
                        builder.append(" by ").append("COMPILED_CODE");
                    }
                    stringBuilder2 = builder.append(" ").append("/* compiled code */");
                }
            }
            Iterator<PropertyAccessorDescriptor> iterator2 = $this$buildDecompiledTextImpl_u24appendDescriptor_u24lambda_u243 = (object2 = descriptor) instanceof DeserializedPropertyDescriptor ? (DeserializedPropertyDescriptor)object2 : null;
            if ($this$buildDecompiledTextImpl_u24appendDescriptor_u24lambda_u243 != null && (object2 = ((DeserializedPropertyDescriptor)((Object)$this$buildDecompiledTextImpl_u24appendDescriptor_u24lambda_u243)).getProto()) != null) {
                GeneratedMessageLite.ExtendableMessage extendableMessage = (GeneratedMessageLite.ExtendableMessage)object2;
                GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, JvmProtoBuf.JvmPropertySignature> generatedExtension = JvmProtoBuf.propertySignature;
                Intrinsics.checkNotNullExpressionValue(generatedExtension, "propertySignature");
                JvmProtoBuf.JvmPropertySignature jvmPropertySignature = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
                if (jvmPropertySignature != null) {
                    boolean hasBackingField = jvmPropertySignature.hasField();
                    boolean bl = false;
                    builder.append(' ').append("/* hasBackingField: ").append(hasBackingField).append(" */");
                }
            }
            if (descriptor instanceof PropertyDescriptor) {
                for (PropertyAccessorDescriptor accessor : ((PropertyDescriptor)descriptor).getAccessors()) {
                    Modality accessorModality;
                    DescriptorVisibility accessorVisibility;
                    boolean isNonDefault = !accessor.isDefault();
                    Intrinsics.checkNotNullExpressionValue(accessor.getVisibility(), "getVisibility(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)accessor.getModality(), "getModality(...)");
                    boolean isExternalAccessor = accessor.isExternal();
                    boolean isInlineAccessor = accessor.isInline();
                    Annotations accessorAnnotations = accessor.getAnnotations();
                    if (!isNonDefault && Intrinsics.areEqual(accessorVisibility, ((PropertyDescriptor)descriptor).getVisibility()) && accessorModality == ((PropertyDescriptor)descriptor).getModality() && !isExternalAccessor && !isInlineAccessor && accessorAnnotations.isEmpty()) continue;
                    builder.append('\n' + indent + "    ");
                    for (Object annotation : accessorAnnotations) {
                        builder.append(DescriptorRenderer.renderAnnotation$default($descriptorRenderer, (AnnotationDescriptor)annotation, null, 2, null));
                        builder.append(" ");
                    }
                    builder.append(accessorVisibility.getInternalDisplayName()).append(" ");
                    builder.append(CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(accessorModality.name())).append(" ");
                    if (isExternalAccessor) {
                        builder.append("external ");
                    }
                    if (isInlineAccessor) {
                        builder.append("inline ");
                    }
                    if (accessor instanceof PropertyGetterDescriptor) {
                        builder.append("get");
                        if (isNonDefault) {
                            builder.append("()");
                        }
                    } else if (accessor instanceof PropertySetterDescriptor) {
                        builder.append("set");
                        if (isNonDefault) {
                            Object annotation;
                            builder.append("(");
                            ValueParameterDescriptor parameterDescriptor = ((PropertySetterDescriptor)accessor).getValueParameters().get(0);
                            annotation = parameterDescriptor.getAnnotations().iterator();
                            while (annotation.hasNext()) {
                                AnnotationDescriptor annotation2 = (AnnotationDescriptor)annotation.next();
                                builder.append(DescriptorRenderer.renderAnnotation$default($descriptorRenderer, annotation2, null, 2, null));
                                builder.append(" ");
                            }
                            Name name2 = parameterDescriptor.getName();
                            Intrinsics.checkNotNullExpressionValue(name2, "getName(...)");
                            Name parameterName = ClsStubBuildingKt.computeParameterName(name2);
                            StringBuilder stringBuilder3 = builder.append(parameterName.asString()).append(": ");
                            KotlinType kotlinType = parameterDescriptor.getType();
                            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                            stringBuilder3.append($descriptorRenderer.renderType(kotlinType));
                            builder.append(")");
                        }
                    }
                    if (!isNonDefault) continue;
                    builder.append(" {").append("/* compiled code */").append(" }");
                }
            }
        } else if (descriptor instanceof ClassDescriptor && !DescriptorUtils.isEnumEntry(descriptor)) {
            builder.append(" {\n");
            String subindent = indent + "    ";
            Ref.BooleanRef firstPassed = new Ref.BooleanRef();
            List allDescriptors = CollectionsKt.plus((Collection)DescriptorUtilsKt.getSecondaryConstructors((ClassDescriptor)descriptor), (Iterable)ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)descriptor).getDefaultType().getMemberScope(), null, null, 3, null));
            Iterable $this$partition$iv = allDescriptors;
            boolean $i$f$partition = false;
            Object first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                DeclarationDescriptor p0 = (DeclarationDescriptor)element$iv;
                boolean bl = false;
                boolean bl2 = DescriptorUtils.isEnumEntry(p0) ? ((ArrayList)first$iv).add(element$iv) : second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List enumEntries = pair.component1();
            List members = pair.component2();
            first$iv = ((Iterable)enumEntries).iterator();
            int n2 = 0;
            while (first$iv.hasNext()) {
                int index = n2++;
                DeclarationDescriptor enumEntry = (DeclarationDescriptor)first$iv.next();
                BuildDecompiledTextKt.buildDecompiledTextImpl$appendDescriptor$newlineExceptFirst(firstPassed, builder);
                builder.append(subindent);
                BuildDecompiledTextKt.buildDecompiledTextImpl$appendDescriptor(builder, $descriptorRenderer, enumEntry, subindent, index == CollectionsKt.getLastIndex(enumEntries));
            }
            ClassDescriptor companionObject = ((ClassDescriptor)descriptor).getCompanionObjectDescriptor();
            if (companionObject != null) {
                BuildDecompiledTextKt.buildDecompiledTextImpl$appendDescriptor$newlineExceptFirst(firstPassed, builder);
                builder.append(subindent);
                BuildDecompiledTextKt.buildDecompiledTextImpl$appendDescriptor$default(builder, $descriptorRenderer, companionObject, subindent, null, 16, null);
            }
            for (DeclarationDescriptor member : members) {
                if (!Intrinsics.areEqual(member.getContainingDeclaration(), descriptor) || Intrinsics.areEqual(member, companionObject) || member instanceof CallableMemberDescriptor && BuildDecompiledTextKt.mustNotBeWrittenToDecompiledText((CallableMemberDescriptor)member)) continue;
                BuildDecompiledTextKt.buildDecompiledTextImpl$appendDescriptor$newlineExceptFirst(firstPassed, builder);
                builder.append(subindent);
                BuildDecompiledTextKt.buildDecompiledTextImpl$appendDescriptor$default(builder, $descriptorRenderer, member, subindent, null, 16, null);
            }
            builder.append(indent).append("}");
        }
        builder.append("\n");
    }

    static /* synthetic */ void buildDecompiledTextImpl$appendDescriptor$default(StringBuilder stringBuilder, DescriptorRenderer descriptorRenderer, DeclarationDescriptor declarationDescriptor, String string, Boolean bl, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            bl = null;
        }
        BuildDecompiledTextKt.buildDecompiledTextImpl$appendDescriptor(stringBuilder, descriptorRenderer, declarationDescriptor, string, bl);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CallableMemberDescriptor.Kind.values().length];
            try {
                nArray[CallableMemberDescriptor.Kind.DECLARATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.DELEGATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.FAKE_OVERRIDE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.SYNTHESIZED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

