/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.copyPaste;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.configuration.ExperimentalFeatures;
import org.jetbrains.kotlin.idea.editor.KotlinEditorOptions;
import org.jetbrains.kotlin.j2k.ConverterContext;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.ElementResult;
import org.jetbrains.kotlin.j2k.J2KPostProcessingRunner;
import org.jetbrains.kotlin.j2k.J2kConverterExtension;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverter;
import org.jetbrains.kotlin.j2k.ParseContext;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.j2k.Result;
import org.jetbrains.kotlin.j2k.WithProgressProcessor;
import org.jetbrains.kotlin.j2k.copyPaste.ConversionResult;
import org.jetbrains.kotlin.j2k.copyPaste.ElementAndTextList;
import org.jetbrains.kotlin.j2k.copyPaste.ElementsAndTextsProcessor;
import org.jetbrains.kotlin.j2k.copyPaste.KotlinPasteFromJavaDialog;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.nj2k.KotlinNJ2KBundle;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\n\u001a\n\u0010\u0010\u001a\u00020\r*\u00020\u0002\u001a\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a2\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0018"}, d2={"convertCodeToKotlin", "Lorg/jetbrains/kotlin/j2k/copyPaste/ConversionResult;", "Lorg/jetbrains/kotlin/j2k/copyPaste/ElementAndTextList;", "project", "Lcom/intellij/openapi/project/Project;", "targetFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "j2kKind", "Lorg/jetbrains/kotlin/j2k/J2kConverterExtension$Kind;", "isConversionSupportedAtPosition", "", "file", "offset", "", "confirmConvertJavaOnPaste", "isPlainText", "lineCount", "getJ2kKind", "runPostProcessing", "", "bounds", "Lcom/intellij/openapi/util/TextRange;", "converterContext", "Lorg/jetbrains/kotlin/j2k/ConverterContext;", "kotlin.j2k.shared"})
@SourceDebugExtension(value={"SMAP\nCopyPasteConversionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopyPasteConversionUtils.kt\norg/jetbrains/kotlin/j2k/copyPaste/CopyPasteConversionUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n808#2,11:182\n808#2,11:193\n1#3:204\n*S KotlinDebug\n*F\n+ 1 CopyPasteConversionUtils.kt\norg/jetbrains/kotlin/j2k/copyPaste/CopyPasteConversionUtilsKt\n*L\n53#1:182,11\n142#1:193,11\n*E\n"})
public final class CopyPasteConversionUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConversionResult convertCodeToKotlin(@NotNull ElementAndTextList $this$convertCodeToKotlin, @NotNull Project project, @NotNull KtFile targetFile, @NotNull J2kConverterExtension.Kind j2kKind) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$convertCodeToKotlin, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)((Object)j2kKind), (String)"j2kKind");
        JavaToKotlinConverter converter = J2kConverterExtension.Companion.extension(j2kKind).createJavaToKotlinConverter(project, GenericPsiUtils.getModule((PsiElement)targetFile), ConverterSettings.Companion.getDefaultSettings(), targetFile);
        Iterable $this$filterIsInstance$iv = $this$convertCodeToKotlin.toList();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List inputElements = (List)destination$iv$iv;
        Result result2 = (Result)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> CopyPasteConversionUtilsKt.convertCodeToKotlin$lambda$1(converter, inputElements), KotlinNJ2KBundle.message("copy.text.convert.java.to.kotlin.title", new Object[0]), true, project);
        List<ElementResult> results2 = result2.component1();
        ConverterContext converterContext = result2.component3();
        Set importsToAdd = new LinkedHashSet();
        StringBuilder convertedCodeBuilder = new StringBuilder();
        StringBuilder originalCodeBuilder = new StringBuilder();
        Ref.ObjectRef parseContext = new Ref.ObjectRef();
        Ref.IntRef resultIndex = new Ref.IntRef();
        $this$convertCodeToKotlin.process(new ElementsAndTextsProcessor(originalCodeBuilder, results2, resultIndex, convertedCodeBuilder, (Ref.ObjectRef<ParseContext>)parseContext, importsToAdd){
            final /* synthetic */ StringBuilder $originalCodeBuilder;
            final /* synthetic */ List<ElementResult> $results;
            final /* synthetic */ Ref.IntRef $resultIndex;
            final /* synthetic */ StringBuilder $convertedCodeBuilder;
            final /* synthetic */ Ref.ObjectRef<ParseContext> $parseContext;
            final /* synthetic */ Set<FqName> $importsToAdd;
            {
                this.$originalCodeBuilder = $originalCodeBuilder;
                this.$results = $results;
                this.$resultIndex = $resultIndex;
                this.$convertedCodeBuilder = $convertedCodeBuilder;
                this.$parseContext = $parseContext;
                this.$importsToAdd = $importsToAdd;
            }

            public void processElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                String originalText = element.getText();
                this.$originalCodeBuilder.append(originalText);
                ElementResult result2 = this.$results.get(this.$resultIndex.element);
                int n = this.$resultIndex.element;
                this.$resultIndex.element = n + 1;
                if (result2 != null) {
                    char[] cArray = new char[]{'\n'};
                    this.$convertedCodeBuilder.append(StringsKt.trimEnd((String)result2.getText(), (char[])cArray));
                    if (this.$parseContext.element == null) {
                        this.$parseContext.element = result2.getParseContext();
                    }
                    v0 = this.$importsToAdd.addAll((Collection<FqName>)result2.getImportsToAdd());
                } else {
                    v0 = this.$convertedCodeBuilder.append(originalText);
                }
            }

            public void processText(String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.$originalCodeBuilder.append(text);
                this.$convertedCodeBuilder.append(text);
            }
        });
        String string = convertedCodeBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String convertedCode = string;
        String string2 = originalCodeBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String originalCode = string2;
        boolean textChanged = !Intrinsics.areEqual((Object)convertedCode, (Object)originalCode);
        ParseContext parseContext2 = (ParseContext)((Object)parseContext.element);
        if (parseContext2 == null) {
            parseContext2 = ParseContext.CODE_BLOCK;
        }
        return new ConversionResult(convertedCode, parseContext2, importsToAdd, textChanged, converterContext);
    }

    public static final boolean isConversionSupportedAtPosition(@NotNull KtFile file, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (offset == 0) {
            return true;
        }
        PsiElement psiElement = file.findElementAt(offset - 1);
        if (psiElement == null) {
            return false;
        }
        PsiElement token = psiElement;
        if (!(token instanceof PsiWhiteSpace) && PsiUtilsKt.getEndOffset((PsiElement)token) != offset) {
            return false;
        }
        for (PsiElement element : PsiUtilsKt.getParentsWithSelf((PsiElement)token)) {
            PsiElement psiElement2 = element;
            if (psiElement2 instanceof PsiComment) {
                return !Intrinsics.areEqual((Object)((PsiComment)element).getNode().getElementType(), (Object)KtTokens.EOL_COMMENT) && offset == PsiUtilsKt.getEndOffset((PsiElement)element);
            }
            if (psiElement2 instanceof KtStringTemplateEntryWithExpression) {
                return true;
            }
            if (!(psiElement2 instanceof KtStringTemplateExpression)) continue;
            return false;
        }
        return true;
    }

    public static final boolean confirmConvertJavaOnPaste(@NotNull Project project, boolean isPlainText) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (KotlinEditorOptions.getInstance().isDonTShowConversionDialog()) {
            return true;
        }
        KotlinPasteFromJavaDialog dialog2 = new KotlinPasteFromJavaDialog(project, isPlainText);
        dialog2.show();
        return dialog2.isOK();
    }

    /*
     * WARNING - void declaration
     */
    public static final int lineCount(@NotNull ElementAndTextList $this$lineCount) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$lineCount, (String)"<this>");
        Iterable $this$filterIsInstance$iv = $this$lineCount.toList();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List elements = (List)destination$iv$iv;
        Iterable iterable2 = elements;
        int n = 0;
        for (Object e : iterable2) {
            void it;
            PsiElement $i$f$filterIsInstanceTo2 = (PsiElement)e;
            int n2 = n;
            boolean bl = false;
            int n3 = StringUtil.getLineBreakCount((CharSequence)it.getText());
            n = n2 + n3;
        }
        return n;
    }

    @NotNull
    public static final J2kConverterExtension.Kind getJ2kKind(@NotNull KtFile targetFile) {
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        return KotlinPluginModeProvider.Companion.isK2Mode() ? J2kConverterExtension.Kind.K2 : (targetFile instanceof KtCodeFragment || !ExperimentalFeatures.INSTANCE.getNewJ2k().isEnabled() ? J2kConverterExtension.Kind.K1_OLD : J2kConverterExtension.Kind.K1_NEW);
    }

    public static final void runPostProcessing(@NotNull Project project, @NotNull KtFile file, @Nullable TextRange bounds, @Nullable ConverterContext converterContext, @NotNull J2kConverterExtension.Kind j2kKind) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)j2kKind), (String)"j2kKind");
        PostProcessor postProcessor = J2kConverterExtension.createPostProcessor$default(J2kConverterExtension.Companion.extension(j2kKind), false, 1, null);
        if (j2kKind != J2kConverterExtension.Kind.K1_OLD) {
            Function0 runnable = () -> CopyPasteConversionUtilsKt.runPostProcessing$lambda$4(j2kKind, postProcessor, file, converterContext, bounds);
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> CopyPasteConversionUtilsKt.runPostProcessing$lambda$5(runnable), KotlinNJ2KBundle.message("copy.text.convert.java.to.kotlin.title", new Object[0]), true, project);
        } else {
            J2KPostProcessingRunner.run$default(J2KPostProcessingRunner.INSTANCE, postProcessor, file, converterContext, bounds, null, 16, null);
        }
    }

    private static final Result convertCodeToKotlin$lambda$1$lambda$0(JavaToKotlinConverter $converter, List $inputElements) {
        return $converter.elementsToKotlin($inputElements);
    }

    private static final Result convertCodeToKotlin$lambda$1(JavaToKotlinConverter $converter, List $inputElements) {
        return (Result)ReadAction.nonBlocking(() -> CopyPasteConversionUtilsKt.convertCodeToKotlin$lambda$1$lambda$0($converter, $inputElements)).executeSynchronously();
    }

    private static final Unit runPostProcessing$lambda$4$lambda$3(WithProgressProcessor $processor, int phase, String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        $processor.updateState(0, phase, description);
        return Unit.INSTANCE;
    }

    private static final Unit runPostProcessing$lambda$4(J2kConverterExtension.Kind $j2kKind, PostProcessor $postProcessor, KtFile $file, ConverterContext $converterContext, TextRange $bounds) {
        J2kConverterExtension j2kConverterExtension = J2kConverterExtension.Companion.extension($j2kKind);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        Intrinsics.checkNotNull((Object)progressIndicator);
        WithProgressProcessor processor2 = j2kConverterExtension.createWithProgressProcessor(progressIndicator, CollectionsKt.emptyList(), $postProcessor.getPhasesCount());
        J2KPostProcessingRunner.INSTANCE.run($postProcessor, $file, $converterContext, $bounds, (Function2<? super Integer, ? super String, Unit>)((Function2)(arg_0, arg_1) -> CopyPasteConversionUtilsKt.runPostProcessing$lambda$4$lambda$3(processor2, arg_0, arg_1)));
        return Unit.INSTANCE;
    }

    private static final void runPostProcessing$lambda$5(Function0 $tmp0) {
        $tmp0.invoke();
    }
}

