/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.actions.KotlinAddImportAction;
import org.jetbrains.kotlin.idea.actions.KotlinAddImportActionKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.quickfix.ImportFixBase;
import org.jetbrains.kotlin.idea.quickfix.OrdinaryImportFixBase;
import org.jetbrains.kotlin.idea.util.CallTypeAndReceiver;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005H\u0014R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ComponentsImportFix;", "Lorg/jetbrains/kotlin/idea/quickfix/OrdinaryImportFixBase;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "importNames", "", "Lorg/jetbrains/kotlin/name/Name;", "solveSeveralProblems", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/util/Collection;Z)V", "getImportNames", "()Ljava/util/Collection;", "getCallTypeAndReceiver", "Lorg/jetbrains/kotlin/idea/util/CallTypeAndReceiver$OPERATOR;", "createAction", "Lorg/jetbrains/kotlin/idea/actions/KotlinAddImportAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "suggestions", "Lorg/jetbrains/kotlin/name/FqName;", "MyFactory", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nAbstractImportFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractImportFix.kt\norg/jetbrains/kotlin/idea/quickfix/ComponentsImportFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,982:1\n1#2:983\n*E\n"})
public final class ComponentsImportFix
extends OrdinaryImportFixBase<KtExpression> {
    @NotNull
    public static final MyFactory MyFactory = new MyFactory(null);
    @NotNull
    private final Collection<Name> importNames;
    private final boolean solveSeveralProblems;

    public ComponentsImportFix(@NotNull KtExpression element, @NotNull Collection<Name> importNames, boolean solveSeveralProblems) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(importNames, (String)"importNames");
        super(element, MyFactory);
        this.importNames = importNames;
        this.solveSeveralProblems = solveSeveralProblems;
    }

    @Override
    @NotNull
    protected Collection<Name> getImportNames() {
        return this.importNames;
    }

    @Nullable
    protected CallTypeAndReceiver.OPERATOR getCallTypeAndReceiver() {
        CallTypeAndReceiver.OPERATOR oPERATOR;
        KtExpression ktExpression = (KtExpression)this.getElement();
        if (ktExpression != null) {
            KtExpression it = ktExpression;
            boolean bl = false;
            oPERATOR = new CallTypeAndReceiver.OPERATOR(it);
        } else {
            oPERATOR = null;
        }
        return oPERATOR;
    }

    @Override
    @NotNull
    protected KotlinAddImportAction createAction(@NotNull Editor editor, @NotNull KtExpression element, @NotNull Collection<FqName> suggestions) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        if (this.solveSeveralProblems) {
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return KotlinAddImportActionKt.createGroupedImportsAction(project, editor, (KtElement)element, KotlinBundle.message((String)"fix.import.kind.component.functions", (Object[])new Object[0]), suggestions);
        }
        return super.createAction(editor, element, suggestions);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ComponentsImportFix$MyFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/ImportFixBase$FactoryWithUnresolvedReferenceQuickFix;", "<init>", "()V", "importNames", "", "Lorg/jetbrains/kotlin/name/Name;", "Lkotlin/jvm/internal/EnhancedNullability;", "diagnostics", "", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "createImportAction", "Lorg/jetbrains/kotlin/idea/quickfix/ComponentsImportFix;", "diagnostic", "createImportActionsForAllProblems", "sameTypeDiagnostics", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nAbstractImportFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractImportFix.kt\norg/jetbrains/kotlin/idea/quickfix/ComponentsImportFix$MyFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,982:1\n1563#2:983\n1634#2,3:984\n*S KotlinDebug\n*F\n+ 1 AbstractImportFix.kt\norg/jetbrains/kotlin/idea/quickfix/ComponentsImportFix$MyFactory\n*L\n772#1:983\n772#1:984,3\n*E\n"})
    public static final class MyFactory
    extends ImportFixBase.FactoryWithUnresolvedReferenceQuickFix {
        private MyFactory() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<Name> importNames(Collection<? extends Diagnostic> diagnostics) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = diagnostics;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Diagnostic diagnostic = (Diagnostic)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Name.identifier((String)((Name)((DiagnosticWithParameters2)Errors.COMPONENT_FUNCTION_MISSING.cast((UnboundDiagnostic)it)).getA()).getIdentifier()));
            }
            return (List)destination$iv$iv;
        }

        @Nullable
        public ComponentsImportFix createImportAction(@NotNull Diagnostic diagnostic) {
            ComponentsImportFix componentsImportFix;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = diagnostic.getPsiElement();
            KtExpression ktExpression = psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                componentsImportFix = new ComponentsImportFix(it, (Collection<Name>)MyFactory.importNames(CollectionsKt.listOf((Object)diagnostic)), false);
            } else {
                componentsImportFix = null;
            }
            return componentsImportFix;
        }

        @NotNull
        public List<ComponentsImportFix> createImportActionsForAllProblems(@NotNull Collection<? extends Diagnostic> sameTypeDiagnostics) {
            Intrinsics.checkNotNullParameter(sameTypeDiagnostics, (String)"sameTypeDiagnostics");
            PsiElement element = ((Diagnostic)CollectionsKt.first((Iterable)sameTypeDiagnostics)).getPsiElement();
            List<Name> names = this.importNames(sameTypeDiagnostics);
            boolean solveSeveralProblems = sameTypeDiagnostics.size() > 1;
            KtExpression ktExpression = element instanceof KtExpression ? (KtExpression)element : null;
            if (ktExpression == null) {
                return CollectionsKt.emptyList();
            }
            KtExpression expression = ktExpression;
            return CollectionsKt.listOf((Object)new ComponentsImportFix(expression, (Collection<Name>)names, solveSeveralProblems));
        }

        public /* synthetic */ MyFactory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

