/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.quickfix.MissingConstructorBracketsFix;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/MissingConstructorBracketsAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "kotlin.code-insight.fixes.k2"})
public final class MissingConstructorBracketsAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        if (!(element instanceof KtClass)) {
            return;
        }
        KtPrimaryConstructor ktPrimaryConstructor = ((KtClass)element).getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return;
        }
        KtPrimaryConstructor primaryConstructor = ktPrimaryConstructor;
        if (primaryConstructor.getValueParameterList() != null) {
            return;
        }
        PsiElement psiElement = primaryConstructor.getConstructorKeyword();
        if (psiElement == null || (psiElement = psiElement.getTextRange()) == null) {
            return;
        }
        int startRange = psiElement.getEndOffset();
        holder2.newSilentAnnotation(HighlightSeverity.ERROR).range(TextRange.create((int)startRange, (int)(startRange + 1))).withFix((CommonIntentionAction)new MissingConstructorBracketsFix(primaryConstructor)).create();
    }
}

