/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.shared.scratch;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ScratchFileOptions;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ui.ScratchFileOptionsFile;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\"\u0010\u001c\u001a\u00020\u000f2\u001a\u0010\u001d\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u000f0\u001eJ\u001f\u0010#\u001a\u00020\u000f2\u0017\u0010$\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0%\u00a2\u0006\u0002\b&J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(J\u0010\u0010*\u001a\u0004\u0018\u00010)2\u0006\u0010+\u001a\u00020,J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010-\u001a\u00020\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile;", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "moduleListeners", "", "Lkotlin/Function0;", "", "value", "Lcom/intellij/openapi/module/Module;", "module", "getModule", "()Lcom/intellij/openapi/module/Module;", "getPsiFile", "Lcom/intellij/psi/PsiFile;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getKtFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "setModule", "addModuleListener", "f", "Lkotlin/Function2;", "options", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFileOptions;", "getOptions", "()Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFileOptions;", "saveOptions", "update", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "getExpressions", "", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchExpression;", "getExpressionAtLine", "line", "", "psiFile", "kotlin.jvm.shared"})
@SourceDebugExtension(value={"SMAP\nScratchFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScratchFile.kt\norg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n125#2:133\n1869#3,2:134\n1#4:136\n*S KotlinDebug\n*F\n+ 1 ScratchFile.kt\norg/jetbrains/kotlin/idea/jvm/shared/scratch/ScratchFile\n*L\n32#1:133\n36#1:134,2\n*E\n"})
public abstract class ScratchFile {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final List<Function0<Unit>> moduleListeners;
    @Nullable
    private Module module;

    public ScratchFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.project = project;
        this.file = file;
        this.moduleListeners = new ArrayList();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @Nullable
    public final Module getModule() {
        return this.module;
    }

    @Nullable
    public final PsiFile getPsiFile() {
        return (PsiFile)ActionsKt.runReadAction(() -> ScratchFile.getPsiFile$lambda$0(this));
    }

    @Nullable
    public final KtFile getKtFile() {
        PsiFile $this$safeAs$iv = this.getPsiFile();
        boolean $i$f$safeAs = false;
        PsiFile psiFile = $this$safeAs$iv;
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        return (KtFile)psiFile;
    }

    public final void setModule(@Nullable Module value) {
        this.module = value;
        Iterable $this$forEach$iv = this.moduleListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    public final void addModuleListener(@NotNull Function2<? super PsiFile, ? super Module, Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        this.moduleListeners.add((Function0<Unit>)((Function0)() -> ScratchFile.addModuleListener$lambda$2(this, f)));
    }

    @NotNull
    public final ScratchFileOptions getOptions() {
        Object object;
        block3: {
            block2: {
                object = this.getPsiFile();
                if (object == null || (object = object.getVirtualFile()) == null) break block2;
                Object it = object;
                boolean bl = false;
                ScratchFileOptions scratchFileOptions = ScratchFileOptionsFile.Companion.get(this.project, (VirtualFile)it);
                object = scratchFileOptions;
                if (scratchFileOptions != null) break block3;
            }
            object = new ScratchFileOptions(false, false, false, 7, null);
        }
        return object;
    }

    public final void saveOptions(@NotNull Function1<? super ScratchFileOptions, ScratchFileOptions> update2) {
        PsiFile virtualFile;
        Intrinsics.checkNotNullParameter(update2, (String)"update");
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return;
        }
        PsiFile $this$saveOptions_u24lambda_u244 = virtualFile = psiFile;
        boolean bl = false;
        ScratchFileOptions scratchFileOptions = ScratchFileOptionsFile.Companion.get(this.project, (VirtualFile)$this$saveOptions_u24lambda_u244);
        if (scratchFileOptions == null) {
            scratchFileOptions = new ScratchFileOptions(false, false, false, 7, null);
        }
        ScratchFileOptions configToUpdate = scratchFileOptions;
        ScratchFileOptionsFile.Companion.set(this.project, (VirtualFile)$this$saveOptions_u24lambda_u244, (ScratchFileOptions)update2.invoke((Object)configToUpdate));
    }

    @NotNull
    public final List<ScratchExpression> getExpressions() {
        return (List)ActionsKt.runReadAction(() -> ScratchFile.getExpressions$lambda$6(this));
    }

    @Nullable
    public final ScratchExpression getExpressionAtLine(int line) {
        Object v1;
        block1: {
            Iterable iterable = this.getExpressions();
            for (Object t : iterable) {
                ScratchExpression it = (ScratchExpression)t;
                boolean bl = false;
                int n = it.getLineStart();
                boolean bl2 = line <= it.getLineEnd() ? n <= line : false;
                if (!bl2) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @NotNull
    public final List<ScratchExpression> getExpressions(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getLastCommittedDocument(psiFile);
        if (document == null) {
            return CollectionsKt.emptyList();
        }
        Document doc = document;
        int line = 0;
        ArrayList<ScratchExpression> result2 = new ArrayList<ScratchExpression>();
        while (line < doc.getLineCount()) {
            KtElement ktElement;
            PsiElement element;
            int start2;
            block9: {
                block8: {
                    start2 = 0;
                    start2 = doc.getLineStartOffset(line);
                    element = psiFile.findElementAt(start2);
                    if (element instanceof PsiWhiteSpace) break block8;
                    if (!(element instanceof PsiComment)) break block9;
                }
                Class[] classArray = new Class[]{PsiWhiteSpace.class, PsiComment.class};
                PsiElement psiElement = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])classArray);
                start2 = psiElement != null ? PsiUtilsKt.getStartOffset((PsiElement)psiElement) : start2;
                element = psiFile.findElementAt(start2);
            }
            if (element != null) {
                PsiElement it;
                boolean bl = false;
                Class[] classArray = new Class[]{KtImportDirective.class, KtDeclaration.class};
                ktElement = (KtElement)KotlinPsiUtils.getTopmostElementAtOffset(it, start2, classArray);
            } else {
                ktElement = null;
            }
            element = (PsiElement)ktElement;
            if (element == null) {
                ++line;
                continue;
            }
            ScratchExpression scratchExpression = new ScratchExpression(element, doc.getLineNumber(PsiUtilsKt.getStartOffset((PsiElement)element)), doc.getLineNumber(PsiUtilsKt.getEndOffset((PsiElement)element)));
            result2.add(scratchExpression);
            line = scratchExpression.getLineEnd() + 1;
        }
        return result2;
    }

    private static final PsiFile getPsiFile$lambda$0(ScratchFile this$0) {
        return PhysicalFileSystemUtilsKt.toPsiFile(this$0.file, this$0.project);
    }

    private static final Unit addModuleListener$lambda$2(ScratchFile this$0, Function2 $f) {
        Module selectedModule = this$0.module;
        PsiFile psiFile = this$0.getPsiFile();
        if (psiFile != null) {
            $f.invoke((Object)psiFile, (Object)selectedModule);
        }
        return Unit.INSTANCE;
    }

    private static final List getExpressions$lambda$6(ScratchFile this$0) {
        Object object;
        block3: {
            block2: {
                object = this$0.getPsiFile();
                if (object == null) break block2;
                PsiFile it = object;
                boolean bl = false;
                List<ScratchExpression> list2 = this$0.getExpressions(it);
                object = list2;
                if (list2 != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }
}

