/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.highlighting.KotlinBaseHighlightingBundle;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\b\u001a\u00020\u0007*\u00020\u0003H\u0002J\r\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\nH\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J3\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0096\u0002R\u0010\u0010\u0006\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/SafeDeleteFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)V", "name", "", "toNameKey", "getText", "Lcom/intellij/codeInspection/util/IntentionName;", "getFamilyName", "startInWriteAction", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "kotlin.highlighting.k2"})
public final class SafeDeleteFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @Nls
    @NotNull
    private final String name;

    public SafeDeleteFix(@NotNull KtNamedDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        super((PsiElement)declaration);
        String string = this.toNameKey(declaration);
        Object[] objectArray = new Object[1];
        String string2 = declaration.getName();
        if (string2 == null) {
            string2 = declaration.getText();
        }
        String string3 = string2;
        Intrinsics.checkNotNull((Object)string3);
        objectArray[0] = string3;
        this.name = KotlinBaseHighlightingBundle.message(string, objectArray);
    }

    private final String toNameKey(KtNamedDeclaration $this$toNameKey) {
        KtNamedDeclaration ktNamedDeclaration = $this$toNameKey;
        return ktNamedDeclaration instanceof KtPrimaryConstructor ? "safe.delete.primary.ctor.text.0" : (ktNamedDeclaration instanceof KtSecondaryConstructor ? "safe.delete.secondary.ctor.text.0" : (ktNamedDeclaration instanceof KtParameter ? "safe.delete.parameter.text.0" : "safe.delete.text.0"));
    }

    @NotNull
    public String getText() {
        return this.name;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBaseHighlightingBundle.message("safe.delete.family", new Object[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        KtDeclaration ktDeclaration = startElement instanceof KtDeclaration ? (KtDeclaration)startElement : null;
        if (ktDeclaration == null) {
            return;
        }
        KtDeclaration element = ktDeclaration;
        KtDeclaration[] ktDeclarationArray = new KtDeclaration[]{element};
        SafeDeleteHandler.invoke((Project)project, (PsiElement[])((PsiElement[])ktDeclarationArray), (boolean)false);
    }
}

