/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.view;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineDebuggerColors;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.SimpleColoredTextIcon;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0016J\u0015\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0018J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J&\u0010 \u001a\u00020\u00142\u001e\u0010!\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120#\u0012\u0004\u0012\u00020\u00140\"J\u0006\u0010$\u001a\u00020\tJ\u0006\u0010%\u001a\u00020&R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIcon;", "", "icon", "Ljavax/swing/Icon;", "hasChildren", "", "<init>", "(Ljavax/swing/Icon;Z)V", "text", "", "(Ljavax/swing/Icon;ZLjava/lang/String;)V", "getIcon", "()Ljavax/swing/Icon;", "getHasChildren", "()Z", "texts", "", "textKeyAttributes", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "append", "", "value", "append$kotlin_jvm_debugger_coroutines", "appendValue", "appendValue$kotlin_jvm_debugger_coroutines", "appendToComponent", "component", "Lcom/intellij/ui/ColoredTextContainer;", "toSimpleTextAttribute", "Lcom/intellij/ui/SimpleTextAttributes;", "kotlin.jvm.PlatformType", "attribute", "forEachTextBlock", "f", "Lkotlin/Function1;", "Lkotlin/Pair;", "simpleString", "valuePresentation", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "kotlin.jvm-debugger.coroutines"})
public final class SimpleColoredTextIcon {
    @Nullable
    private final Icon icon;
    private final boolean hasChildren;
    @NotNull
    private final List<String> texts;
    @NotNull
    private final List<TextAttributesKey> textKeyAttributes;

    public SimpleColoredTextIcon(@Nullable Icon icon2, boolean hasChildren) {
        this.icon = icon2;
        this.hasChildren = hasChildren;
        this.texts = new ArrayList();
        this.textKeyAttributes = new ArrayList();
    }

    @Nullable
    public final Icon getIcon() {
        return this.icon;
    }

    public final boolean getHasChildren() {
        return this.hasChildren;
    }

    public SimpleColoredTextIcon(@Nullable Icon icon2, boolean hasChildren, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this(icon2, hasChildren);
        this.append$kotlin_jvm_debugger_coroutines(text);
    }

    public final void append$kotlin_jvm_debugger_coroutines(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.texts.add(value);
        this.textKeyAttributes.add(CoroutineDebuggerColors.Companion.getREGULAR_ATTRIBUTES());
    }

    public final void appendValue$kotlin_jvm_debugger_coroutines(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.texts.add(value);
        this.textKeyAttributes.add(CoroutineDebuggerColors.Companion.getVALUE_ATTRIBUTES());
    }

    private final void appendToComponent(ColoredTextContainer component) {
        int size = this.texts.size();
        for (int i2 = 0; i2 < size; ++i2) {
            String text = this.texts.get(i2);
            TextAttributesKey attribute = this.textKeyAttributes.get(i2);
            SimpleTextAttributes simpleTextAttribute = this.toSimpleTextAttribute(attribute);
            component.append(text, simpleTextAttribute);
        }
    }

    private final SimpleTextAttributes toSimpleTextAttribute(TextAttributesKey attribute) {
        TextAttributesKey textAttributesKey = attribute;
        return Intrinsics.areEqual((Object)textAttributesKey, (Object)CoroutineDebuggerColors.Companion.getREGULAR_ATTRIBUTES()) ? SimpleTextAttributes.REGULAR_ATTRIBUTES : (Intrinsics.areEqual((Object)textAttributesKey, (Object)CoroutineDebuggerColors.Companion.getVALUE_ATTRIBUTES()) ? XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public final void forEachTextBlock(@NotNull Function1<? super Pair<String, TextAttributesKey>, Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        for (Pair pair : CollectionsKt.zip((Iterable)this.texts, (Iterable)this.textKeyAttributes)) {
            f.invoke((Object)pair);
        }
    }

    @NotNull
    public final String simpleString() {
        SimpleColoredComponent component = new SimpleColoredComponent();
        this.appendToComponent((ColoredTextContainer)component);
        return ((Object)component.getCharSequence(false)).toString();
    }

    @NotNull
    public final XValuePresentation valuePresentation() {
        return new XValuePresentation(this){
            final /* synthetic */ SimpleColoredTextIcon this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean isShowName() {
                return false;
            }

            public String getSeparator() {
                return "";
            }

            public void renderValue(XValuePresentation.XValueTextRenderer renderer2) {
                Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
                this.this$0.forEachTextBlock((Function1<? super Pair<String, TextAttributesKey>, Unit>)((Function1)arg_0 -> valuePresentation.1.renderValue$lambda$0(renderer2, arg_0)));
            }

            private static final Unit renderValue$lambda$0(XValuePresentation.XValueTextRenderer $renderer, Pair it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                $renderer.renderValue((String)it.getFirst(), (TextAttributesKey)it.getSecond());
                return Unit.INSTANCE;
            }
        };
    }
}

