/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.platforms;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJavaScriptLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.StdlibDetectorFacility;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/KotlinJavaScriptStdlibDetectorFacility;", "Lorg/jetbrains/kotlin/idea/base/platforms/StdlibDetectorFacility;", "<init>", "()V", "KOTLIN_JS_LIBRARY_KLIB_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "supportedLibraryKind", "Lorg/jetbrains/kotlin/idea/base/platforms/KotlinLibraryKind;", "getSupportedLibraryKind", "()Lorg/jetbrains/kotlin/idea/base/platforms/KotlinLibraryKind;", "getStdlibJar", "Lcom/intellij/openapi/vfs/VirtualFile;", "roots", "", "kotlin.base.platforms"})
@ApiStatus.Internal
public final class KotlinJavaScriptStdlibDetectorFacility
extends StdlibDetectorFacility {
    @NotNull
    public static final KotlinJavaScriptStdlibDetectorFacility INSTANCE = new KotlinJavaScriptStdlibDetectorFacility();
    private static final Pattern KOTLIN_JS_LIBRARY_KLIB_PATTERN = Pattern.compile("kotlin-stdlib-js.*\\.klib");

    private KotlinJavaScriptStdlibDetectorFacility() {
        super(null);
    }

    @Override
    @NotNull
    protected KotlinLibraryKind getSupportedLibraryKind() {
        return KotlinJavaScriptLibraryKind.INSTANCE;
    }

    @Override
    @Nullable
    public VirtualFile getStdlibJar(@NotNull List<? extends VirtualFile> roots) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        for (VirtualFile virtualFile : roots) {
            if (virtualFile.getFileSystem().getProtocol() != "jar") continue;
            String string = virtualFile.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            String name2 = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)string, (String)"!/", null, (int)2, null), (char)'/', null, (int)2, null);
            if (!Intrinsics.areEqual((Object)name2, (Object)"kotlin-stdlib-js.klib") && !Intrinsics.areEqual((Object)name2, (Object)"kotlin-jslib.jar") && !PathUtil.INSTANCE.getKOTLIN_STDLIB_JS_JAR_PATTERN().matcher(name2).matches() && !PathUtil.INSTANCE.getKOTLIN_JS_LIBRARY_JAR_PATTERN().matcher(name2).matches() && !KOTLIN_JS_LIBRARY_KLIB_PATTERN.matcher(name2).matches()) continue;
            VirtualFile virtualFile2 = VfsUtilCore.getVirtualFileForJar((VirtualFile)virtualFile);
            if (virtualFile2 == null) continue;
            VirtualFile jar = virtualFile2;
            return jar;
        }
        return null;
    }
}

