/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.analysisApiPlatform.projectStructure;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.caches.UtilsKt;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinModuleDependentsProviderBase;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaBuiltinsModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryFallbackDependenciesModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibrarySourceModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaScriptDependencyModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaScriptModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.ApiKt;
import org.jetbrains.kotlin.idea.base.projectStructure.KaSourceModuleKind;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u000b\u001a\u00020\rH\u0002J\u001e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H$J\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00142\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H$J \u0010\u0015\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\n0\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0004J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R&\u0010\u0019\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/projectStructure/IdeKotlinModuleDependentsProvider;", "Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinModuleDependentsProviderBase;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDirectDependents", "", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "module", "getDirectDependentsForSourceModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaSourceModule;", "addFriendDependentsForSourceModule", "", "", "addAnchorModuleDependents", "to", "getDirectDependentsForLibraryNonSdkModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibraryModule;", "addWorkspaceModelDependents", "symbolicId", "Lcom/intellij/platform/workspace/storage/SymbolicEntityId;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntityWithSymbolicId;", "transitiveDependentsCache", "Lcom/intellij/psi/util/CachedValue;", "Lcom/github/benmanes/caffeine/cache/Cache;", "getTransitiveDependents", "getRefinementDependents", "kotlin.base.analysis-api-platform"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nIdeKotlinModuleDependentsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeKotlinModuleDependentsProvider.kt\norg/jetbrains/kotlin/idea/base/analysisApiPlatform/projectStructure/IdeKotlinModuleDependentsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n1#2:143\n1#2:148\n1321#3,2:144\n1625#4:146\n1869#4:147\n1870#4:149\n1626#4:150\n*S KotlinDebug\n*F\n+ 1 IdeKotlinModuleDependentsProvider.kt\norg/jetbrains/kotlin/idea/base/analysisApiPlatform/projectStructure/IdeKotlinModuleDependentsProvider\n*L\n140#1:148\n99#1:144,2\n140#1:146\n140#1:147\n140#1:149\n140#1:150\n*E\n"})
public abstract class IdeKotlinModuleDependentsProvider
extends KotlinModuleDependentsProviderBase {
    @NotNull
    private final Project project;
    @NotNull
    private final CachedValue<Cache<KaModule, Set<KaModule>>> transitiveDependentsCache;

    public IdeKotlinModuleDependentsProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        CachedValue cachedValue2 = CachedValuesManager.getManager((Project)this.project).createCachedValue(() -> IdeKotlinModuleDependentsProvider.transitiveDependentsCache$lambda$4(this));
        Intrinsics.checkNotNullExpressionValue((Object)cachedValue2, (String)"createCachedValue(...)");
        this.transitiveDependentsCache = cachedValue2;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public Set<KaModule> getDirectDependents(@NotNull KaModule module) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        KaModule kaModule = module;
        if (kaModule instanceof KaSourceModule) {
            set = this.getDirectDependentsForSourceModule((KaSourceModule)module);
        } else {
            if (kaModule instanceof KaLibraryModule) {
                Set set2;
                if (((KaLibraryModule)module).isSdk()) {
                    return SetsKt.emptySet();
                }
                Set $this$getDirectDependents_u24lambda_u240 = set2 = SetsKt.createSetBuilder();
                boolean bl = false;
                this.getDirectDependentsForLibraryNonSdkModule((KaLibraryModule)module, $this$getDirectDependents_u24lambda_u240);
                return SetsKt.build((Set)set2);
            }
            if (kaModule instanceof KaLibrarySourceModule) {
                set = this.getDirectDependents(((KaLibrarySourceModule)module).getBinaryLibrary());
            } else if (kaModule instanceof KaLibraryFallbackDependenciesModule) {
                Set set3;
                Set $this$getDirectDependents_u24lambda_u241 = set3 = SetsKt.createSetBuilder();
                boolean bl = false;
                $this$getDirectDependents_u24lambda_u241.add(((KaLibraryFallbackDependenciesModule)module).getDependentLibrary());
                CollectionsKt.addIfNotNull((Collection)$this$getDirectDependents_u24lambda_u241, (Object)((KaLibraryFallbackDependenciesModule)module).getDependentLibrary().getLibrarySources());
                set = SetsKt.build((Set)set3);
            } else if (kaModule instanceof KaBuiltinsModule) {
                set = SetsKt.emptySet();
            } else if (kaModule instanceof KaDanglingFileModule) {
                set = SetsKt.emptySet();
            } else if (kaModule instanceof KaScriptModule || kaModule instanceof KaScriptDependencyModule) {
                set = SetsKt.emptySet();
            } else if (kaModule instanceof KaNotUnderContentRootModule) {
                set = SetsKt.emptySet();
            } else {
                throw new KotlinExceptionWithAttachments("Unexpected " + Reflection.getOrCreateKotlinClass(module.getClass()).getSimpleName()).withAttachment("module.txt", (Object)module);
            }
        }
        return set;
    }

    private final Set<KaModule> getDirectDependentsForSourceModule(KaSourceModule module) {
        Set set;
        Set $this$getDirectDependentsForSourceModule_u24lambda_u242 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        this.addFriendDependentsForSourceModule($this$getDirectDependentsForSourceModule_u24lambda_u242, module);
        this.addWorkspaceModelDependents($this$getDirectDependentsForSourceModule_u24lambda_u242, (SymbolicEntityId<? extends WorkspaceEntityWithSymbolicId>)((SymbolicEntityId)ApiKt.getSymbolicId(module)));
        this.addAnchorModuleDependents(module, $this$getDirectDependentsForSourceModule_u24lambda_u242);
        return SetsKt.build((Set)set);
    }

    private final void addFriendDependentsForSourceModule(Set<KaModule> $this$addFriendDependentsForSourceModule, KaSourceModule module) {
        if (ApiKt.getSourceModuleKind(module) == KaSourceModuleKind.PRODUCTION) {
            CollectionsKt.addIfNotNull((Collection)$this$addFriendDependentsForSourceModule, (Object)ApiKt.toKaSourceModuleForTest(ApiKt.getOpenapiModule(module)));
        }
    }

    protected abstract void addAnchorModuleDependents(@NotNull KaSourceModule var1, @NotNull Set<KaModule> var2);

    protected abstract void getDirectDependentsForLibraryNonSdkModule(@NotNull KaLibraryModule var1, @NotNull Set<KaModule> var2);

    /*
     * WARNING - void declaration
     */
    protected final void addWorkspaceModelDependents(@NotNull Set<KaModule> $this$addWorkspaceModelDependents, @NotNull SymbolicEntityId<? extends WorkspaceEntityWithSymbolicId> symbolicId) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter($this$addWorkspaceModelDependents, (String)"<this>");
        Intrinsics.checkNotNullParameter(symbolicId, (String)"symbolicId");
        ImmutableEntityStorage snapshot = WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot();
        Sequence sequence = snapshot.referrers(symbolicId, ModuleEntity.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleEntity moduleEntity = (ModuleEntity)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)moduleEntity.getSymbolicId(), symbolicId)) continue;
            CollectionsKt.addIfNotNull((Collection)$this$addWorkspaceModelDependents, (Object)ApiKt.toKaSourceModuleForProductionOrTest(moduleEntity.getSymbolicId(), this.project));
        }
    }

    @Override
    @NotNull
    public Set<KaModule> getTransitiveDependents(@NotNull KaModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Object object = this.transitiveDependentsCache.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Set)UtilsKt.getOrPut((Cache)object, module, arg_0 -> IdeKotlinModuleDependentsProvider.getTransitiveDependents$lambda$5(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<KaModule> getRefinementDependents(@NotNull KaModule module) {
        Iterable iterable;
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (!(module instanceof KaSourceModule)) {
            return SetsKt.emptySet();
        }
        List<Module> implementingModules = KotlinFacetUtils.getImplementingModules(ApiKt.getOpenapiModule((KaSourceModule)module));
        Iterable iterable2 = implementingModules;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KaSourceModule it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            Module it = (Module)element$iv;
            boolean bl2 = false;
            if (ApiKt.toKaSourceModuleForProductionOrTest(it) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        iterable2 = destination$iv;
        if (iterable2.isEmpty()) {
            boolean bl = false;
            iterable = SetsKt.emptySet();
        } else {
            iterable = iterable2;
        }
        return (Set)iterable;
    }

    private static final CachedValueProvider.Result transitiveDependentsCache$lambda$4(IdeKotlinModuleDependentsProvider this$0) {
        Object[] objectArray = new Object[]{ProjectRootModificationTracker.getInstance((Project)this$0.project)};
        return CachedValueProvider.Result.create((Object)Caffeine.newBuilder().maximumSize(100L).build(), (Object[])objectArray);
    }

    private static final Set getTransitiveDependents$lambda$5(IdeKotlinModuleDependentsProvider this$0, KaModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.computeTransitiveDependents(it);
    }
}

