/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory4;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirExpectActualMatchingContext;
import org.jetbrains.kotlin.fir.FirExpectActualMatchingContextFactory;
import org.jetbrains.kotlin.fir.FirExpectActualMatchingContextKt;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.mpp.DeclarationSymbolMarker;
import org.jetbrains.kotlin.mpp.RegularClassSymbolMarker;
import org.jetbrains.kotlin.mpp.SourceElementMarker;
import org.jetbrains.kotlin.resolve.calls.mpp.AbstractExpectActualAnnotationMatchChecker;
import org.jetbrains.kotlin.resolve.calls.mpp.ExpectActualMatchingContext;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualAnnotationsIncompatibilityType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJG\u0010\u000e\u001a\u00020\u00072\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualAnnotationsMatchExpectChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkAnnotationsMatch", "expectSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "actualSymbol", "expectContainingClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirActualAnnotationsMatchExpectChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirActualAnnotationsMatchExpectChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualAnnotationsMatchExpectChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,70:1\n35#2:71\n*S KotlinDebug\n*F\n+ 1 FirActualAnnotationsMatchExpectChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualAnnotationsMatchExpectChecker\n*L\n35#1:71\n*E\n"})
public final class FirActualAnnotationsMatchExpectChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirActualAnnotationsMatchExpectChecker INSTANCE = new FirActualAnnotationsMatchExpectChecker();

    private FirActualAnnotationsMatchExpectChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        FirRegularClassSymbol actualContainingClass;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!(declaration instanceof FirMemberDeclaration)) {
            return;
        }
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiPlatformProjects)) {
            return;
        }
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiplatformRestrictions)) {
            return;
        }
        FirMemberDeclaration $this$isActual$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isActual = false;
        if (!$this$isActual$iv.getStatus().isActual()) {
            return;
        }
        FirBasedSymbol<FirDeclaration> actualSymbol = ((FirMemberDeclaration)declaration).getSymbol();
        FirBasedSymbol<?> firBasedSymbol = ExpectActualAttributesKt.getSingleMatchedExpectForActualOrNull(actualSymbol);
        if (firBasedSymbol == null) {
            return;
        }
        FirBasedSymbol<?> expectSymbol = firBasedSymbol;
        Object object = CollectionsKt.lastOrNull(context.getContainingDeclarations());
        FirRegularClassSymbol firRegularClassSymbol = actualContainingClass = object instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)object : null;
        FirBasedSymbol<?> firBasedSymbol2 = firRegularClassSymbol != null ? ExpectActualAttributesKt.getSingleMatchedExpectForActualOrNull(firRegularClassSymbol) : null;
        FirRegularClassSymbol expectContainingClass = firBasedSymbol2 instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firBasedSymbol2 : null;
        this.checkAnnotationsMatch(context, reporter, expectSymbol, actualSymbol, expectContainingClass);
    }

    private final void checkAnnotationsMatch(CheckerContext context, DiagnosticReporter reporter, FirBasedSymbol<?> expectSymbol, FirBasedSymbol<?> actualSymbol, FirRegularClassSymbol expectContainingClass) {
        FirExpectActualMatchingContext matchingContext = FirExpectActualMatchingContextFactory.create$default(FirExpectActualMatchingContextKt.getExpectActualMatchingContextFactory(context.getSession()), context.getSession(), context.getScopeSession(), false, 4, null);
        AbstractExpectActualAnnotationMatchChecker.Incompatibility incompatibility = AbstractExpectActualAnnotationMatchChecker.INSTANCE.areAnnotationsCompatible((DeclarationSymbolMarker)expectSymbol, (DeclarationSymbolMarker)actualSymbol, (RegularClassSymbolMarker)expectContainingClass, (ExpectActualMatchingContext)matchingContext);
        if (incompatibility == null) {
            return;
        }
        AbstractExpectActualAnnotationMatchChecker.Incompatibility incompatibility2 = incompatibility;
        SourceElementMarker sourceElementMarker = incompatibility2.getActualAnnotationTargetElement();
        Intrinsics.checkNotNull((Object)sourceElementMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirSourceElement");
        KtSourceElement actualAnnotationTargetSourceElement = ((FirSourceElement)sourceElementMarker).getElement();
        DiagnosticContext diagnosticContext = context;
        AbstractKtSourceElement abstractKtSourceElement = KtDiagnosticReportHelpersKt.requireNotNull((AbstractKtSourceElement)((AbstractKtSourceElement)actualSymbol.getSource()));
        KtDiagnosticFactory4<FirBasedSymbol<?>, FirBasedSymbol<?>, KtSourceElement, ExpectActualAnnotationsIncompatibilityType<FirAnnotation>> ktDiagnosticFactory4 = FirErrors.INSTANCE.getACTUAL_ANNOTATIONS_NOT_MATCH_EXPECT();
        DeclarationSymbolMarker declarationSymbolMarker = incompatibility2.getExpectSymbol();
        Intrinsics.checkNotNull((Object)declarationSymbolMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.FirBasedSymbol<*>");
        FirBasedSymbol firBasedSymbol = (FirBasedSymbol)declarationSymbolMarker;
        DeclarationSymbolMarker declarationSymbolMarker2 = incompatibility2.getActualSymbol();
        Intrinsics.checkNotNull((Object)declarationSymbolMarker2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.FirBasedSymbol<*>");
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)reporter, (AbstractKtSourceElement)abstractKtSourceElement, ktDiagnosticFactory4, (Object)firBasedSymbol, (Object)((FirBasedSymbol)declarationSymbolMarker2), (Object)actualAnnotationTargetSourceElement, (Object)incompatibility2.getType().mapAnnotationType(FirActualAnnotationsMatchExpectChecker::checkAnnotationsMatch$lambda$0), null, (int)128, null);
    }

    private static final FirAnnotation checkAnnotationsMatch$lambda$0(ExpectActualMatchingContext.AnnotationCallInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getAnnotationSymbol();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirAnnotation");
        return (FirAnnotation)object;
    }
}

