/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.shellcheck;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShNotification;
import com.intellij.sh.settings.ShSettings;
import com.intellij.sh.statistics.ShCounterUsagesCollector;
import com.intellij.sh.utils.ExternalServicesUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.Decompressor;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class ShShellcheckUtil {
    private static final Logger LOG = Logger.getInstance(ShShellcheckUtil.class);
    private static final Key<Boolean> UPDATE_NOTIFICATION_SHOWN = Key.create((String)"SHELLCHECK_UPDATE");
    @NlsSafe
    static final String SHELLCHECK = "shellcheck";
    private static final String SHELLCHECK_VERSION = "0.10.0";
    private static final String SHELLCHECK_ARTIFACT_VERSION = "0.10.0-1";
    private static final String SHELLCHECK_ARCHIVE_EXTENSION = ".tar.gz";
    private static final String SHELLCHECK_URL = "https://cache-redirector.jetbrains.com/intellij-dependencies/org/jetbrains/intellij/deps/shellcheck/shellcheck/";
    public static final Map<@NlsSafe String, @Nls String> SHELLCHECK_CODES = new TreeMap<String, String>(){
        {
            this.put("SC1000", ShBundle.message("check1000.is.not.used.specially.and.should.therefore.be.escaped", new Object[0]));
            this.put("SC1001", ShBundle.message("check1001.this.o.will.be.a.regular.o.in.this.context", new Object[0]));
            this.put("SC1003", ShBundle.message("check1003.want.to.escape.a.single.quote.echo.this.is.how.it.s.done", new Object[0]));
            this.put("SC1004", ShBundle.message("check1004.this.backslash.linefeed.is.literal.break.outside.single.quotes.if.you.just.want.to.break.the.line", new Object[0]));
            this.put("SC1007", ShBundle.message("check1007.remove.space.after.if.trying.to.assign.a.value.or.for.empty.string.use.var", new Object[0]));
            this.put("SC1008", ShBundle.message("check.1008.this.shebang.was.unrecognized.shellcheck.only.supports.sh.bash.dash.ksh.add.a.shell.directive.to.specify", new Object[0]));
            this.put("SC1009", ShBundle.message("check.1009.the.mentioned.parser.error.was.in", new Object[0]));
            this.put("SC1010", ShBundle.message("check.1010.use.semicolon.or.linefeed.before.done.or.quote.to.make.it.literal", new Object[0]));
            this.put("SC1011", ShBundle.message("check.1011.this.apostrophe.terminated.the.single.quoted.string", new Object[0]));
            this.put("SC1012", ShBundle.message("check.1012.is.just.literal.t.here.for.tab.use.printf.instead", new Object[0]));
            this.put("SC1014", ShBundle.message("check.1014.use.if.cmd.then.to.check.exit.code.or.if.cmd.to.check.output", new Object[0]));
            this.put("SC1015", ShBundle.message("check.1015.this.is.a.unicode.double.quote.delete.and.retype.it", new Object[0]));
            this.put("SC1016", ShBundle.message("check.1016.this.is.a.unicode.single.quote.delete.and.retype.it", new Object[0]));
            this.put("SC1017", ShBundle.message("check.1017.literal.carriage.return.run.script.through.tr.d", new Object[0]));
            this.put("SC1018", ShBundle.message("check.1018.this.is.a.unicode.non.breaking.space.delete.it.and.retype.as.space", new Object[0]));
            this.put("SC1019", ShBundle.message("check.1019.expected.this.to.be.an.argument.to.the.unary.condition", new Object[0]));
            this.put("SC1020", ShBundle.message("check.1020.you.need.a.space.before.the.if.single.then.else", new Object[0]));
            this.put("SC1026", ShBundle.message("check.1026.if.grouping.expressions.inside.use", new Object[0]));
            this.put("SC1028", ShBundle.message("check.1028.in.you.have.to.escape.or.preferably.combine.expressions", new Object[0]));
            this.put("SC1029", ShBundle.message("check.1029.in.you.shouldn.t.escape.or", new Object[0]));
            this.put("SC1035", ShBundle.message("check.1035.you.need.a.space.here", new Object[0]));
            this.put("SC1036", ShBundle.message("check.1036.is.invalid.here.did.you.forget.to.escape.it", new Object[0]));
            this.put("SC1037", ShBundle.message("check.1037.braces.are.required.for.positionals.over.9.e.g.10", new Object[0]));
            this.put("SC1038", ShBundle.message("check.1038.shells.are.space.sensitive.use.cmd.not.cmd", new Object[0]));
            this.put("SC1039", ShBundle.message("check.1039.remove.indentation.before.end.token.or.use.and.indent.with.tabs", new Object[0]));
            this.put("SC1040", ShBundle.message("check.1040.when.using.you.can.only.indent.with.tabs", new Object[0]));
            this.put("SC1041", ShBundle.message("check.1041.found.eof.further.down.but.not.on.a.separate.line", new Object[0]));
            this.put("SC1042", ShBundle.message("check.1042.found.eof.further.down.but.not.on.a.separate.line", new Object[0]));
            this.put("SC1044", ShBundle.message("check.1044.couldn.t.find.end.token.eof.in.the.here.document", new Object[0]));
            this.put("SC1045", ShBundle.message("check.1045.it.s.not.foo.bar.just.foo.bar", new Object[0]));
            this.put("SC1046", ShBundle.message("check.1046.couldn.t.find.fi.for.this.if", new Object[0]));
            this.put("SC1047", ShBundle.message("check.1047.expected.fi.matching.previously.mentioned.if", new Object[0]));
            this.put("SC1048", ShBundle.message("check.1048.can.t.have.empty.then.clauses.use.true.as.a.no.op", new Object[0]));
            this.put("SC1049", ShBundle.message("check.1049.did.you.forget.the.then.for.this.if", new Object[0]));
            this.put("SC1050", ShBundle.message("check.1045.expected.then", new Object[0]));
            this.put("SC1051", ShBundle.message("check.1051.semicolons.directly.after.then.are.not.allowed.just.remove.it", new Object[0]));
            this.put("SC1052", ShBundle.message("check.1052.semicolons.directly.after.then.are.not.allowed.just.remove.it", new Object[0]));
            this.put("SC1053", ShBundle.message("check.1053.semicolons.directly.after.else.are.not.allowed.just.remove.it", new Object[0]));
            this.put("SC1054", ShBundle.message("check.1054.you.need.a.space.after.the", new Object[0]));
            this.put("SC1058", ShBundle.message("check.1058.expected.do", new Object[0]));
            this.put("SC1061", ShBundle.message("check.1061.couldn.t.find.done.for.this.do", new Object[0]));
            this.put("SC1062", ShBundle.message("check.1062.expected.done.matching.previously.mentioned.do", new Object[0]));
            this.put("SC1064", ShBundle.message("check.1064.expected.a.to.open.the.function.definition", new Object[0]));
            this.put("SC1065", ShBundle.message("check.1065.trying.to.declare.parameters.don.t.use.and.refer.to.params.as.1.2", new Object[0]));
            this.put("SC1066", ShBundle.message("check.1066.don.t.use.on.the.left.side.of.assignments", new Object[0]));
            this.put("SC1068", ShBundle.message("check.1068.don.t.put.spaces.around.the.in.assignments", new Object[0]));
            this.put("SC1069", ShBundle.message("check.1069.you.need.a.space.before.the", new Object[0]));
            this.put("SC1071", ShBundle.message("check.1071.shellcheck.only.supports.sh.bash.dash.ksh.scripts.sorry", new Object[0]));
            this.put("SC1072", ShBundle.message("check.1072.unexpected", new Object[0]));
            this.put("SC1073", ShBundle.message("check.1073.couldn.t.parse.this.thing.fix.to.allow.more.checks", new Object[0]));
            this.put("SC1075", ShBundle.message("check.1075.use.elif.instead.of.else.if", new Object[0]));
            this.put("SC1077", ShBundle.message("check.1077.for.command.expansion.the.tick.should.slant.left.vs", new Object[0]));
            this.put("SC1078", ShBundle.message("check.1078.did.you.forget.to.close.this.double.quoted.string", new Object[0]));
            this.put("SC1079", ShBundle.message("check.1079.this.is.actually.an.end.quote.but.due.to.next.char.it.looks.suspect", new Object[0]));
            this.put("SC1081", ShBundle.message("check.1081.scripts.are.case.sensitive.use.if.not.if", new Object[0]));
            this.put("SC1082", ShBundle.message("check.1082.this.file.has.a.utf.8.bom.remove.it.with.lc.ctype.c.sed.1s.yourscript", new Object[0]));
            this.put("SC1083", ShBundle.message("check.1083.this.is.literal.check.expression.missing.or.quote.it", new Object[0]));
            this.put("SC1084", ShBundle.message("check.1084.use.not.for.the.shebang", new Object[0]));
            this.put("SC1086", ShBundle.message("check.1086.don.t.use.on.the.iterator.name.in.for.loops", new Object[0]));
            this.put("SC1087", ShBundle.message("check.1087.use.braces.when.expanding.arrays.e.g.array.idx.or.var.to.quiet", new Object[0]));
            this.put("SC1088", ShBundle.message("check.1088.parsing.stopped.here.invalid.use.of.parentheses", new Object[0]));
            this.put("SC1089", ShBundle.message("check.1089.parsing.stopped.here.is.this.keyword.correctly.matched.up", new Object[0]));
            this.put("SC1090", ShBundle.message("check.1090.can.t.follow.non.constant.source.use.a.directive.to.specify.location", new Object[0]));
            this.put("SC1091", ShBundle.message("check.1091.not.following.error.message.here", new Object[0]));
            this.put("SC1094", ShBundle.message("check.1094.parsing.of.sourced.file.failed.ignoring.it", new Object[0]));
            this.put("SC1095", ShBundle.message("check.1095.you.need.a.space.or.linefeed.between.the.function.name.and.body", new Object[0]));
            this.put("SC1097", ShBundle.message("check.1097.unexpected.for.assignment.use.for.comparison.use", new Object[0]));
            this.put("SC1098", ShBundle.message("check.1098.quote.escape.special.characters.when.using.eval.e.g.eval.a.b", new Object[0]));
            this.put("SC1099", ShBundle.message("check.1099.you.need.a.space.before.the", new Object[0]));
            this.put("SC1100", ShBundle.message("check.1100.this.is.a.unicode.dash.delete.and.retype.as.ascii.minus", new Object[0]));
            this.put("SC1101", ShBundle.message("check.1101.delete.trailing.spaces.after.to.break.line.or.use.quotes.for.literal.space", new Object[0]));
            this.put("SC1102", ShBundle.message("check.1102.shells.disambiguate.differently.or.not.at.all.if.the.first.should.start.command.substitution.add.a.space.after.it", new Object[0]));
            this.put("SC1104", ShBundle.message("check.1104.use.not.just.for.the.shebang", new Object[0]));
            this.put("SC1105", ShBundle.message("check.1105.shells.disambiguate.differently.or.not.at.all.if.the.first.should.start.a.subshell.add.a.space.after.it", new Object[0]));
            this.put("SC1107", ShBundle.message("check.1107.this.directive.is.unknown.it.will.be.ignored", new Object[0]));
            this.put("SC1108", ShBundle.message("check.1108.you.need.a.space.before.and.after.the", new Object[0]));
            this.put("SC1109", ShBundle.message("check.1109.this.is.an.unquoted.html.entity.replace.with.corresponding.character", new Object[0]));
            this.put("SC1110", ShBundle.message("check.1110.this.is.a.unicode.quote.delete.and.retype.it.or.quote.to.make.literal", new Object[0]));
            this.put("SC1111", ShBundle.message("check.1111.this.is.a.unicode.quote.delete.and.retype.it.or.ignore.singlequote.for.literal", new Object[0]));
            this.put("SC1112", ShBundle.message("check.1112.this.is.a.unicode.quote.delete.and.retype.it.or.ignore.doublequote.for.literal", new Object[0]));
            this.put("SC1113", ShBundle.message("check.1113.use.not.just.for.the.sheban", new Object[0]));
            this.put("SC1114", ShBundle.message("check.1114.remove.leading.spaces.before.the.shebang", new Object[0]));
            this.put("SC1115", ShBundle.message("check.1115.remove.spaces.between.and.in.the.shebang", new Object[0]));
            this.put("SC1116", ShBundle.message("check.1116.missing.on.a.expression.or.use.for.arrays", new Object[0]));
            this.put("SC1117", ShBundle.message("check.1117.backslash.is.literal.in.prefer.explicit.escaping.n", new Object[0]));
            this.put("SC1118", ShBundle.message("check.1118.delete.whitespace.after.the.here.doc.end.token", new Object[0]));
            this.put("SC1119", ShBundle.message("check.1119.add.a.linefeed.between.end.token.and.terminating", new Object[0]));
            this.put("SC1120", ShBundle.message("check.1120.no.comments.allowed.after.here.doc.token.comment.the.next.line.instead", new Object[0]));
            this.put("SC1121", ShBundle.message("check.1121.add.terminators.and.other.syntax.on.the.line.with.the.not.here", new Object[0]));
            this.put("SC1122", ShBundle.message("check.1122.nothing.allowed.after.end.token.to.continue.a.command.put.it.on.the.line.with.the", new Object[0]));
            this.put("SC1123", ShBundle.message("check.1123.shellcheck.directives.are.only.valid.in.front.of.complete.compound.commands.like.if.not.e.g.individual.elif.branches", new Object[0]));
            this.put("SC1124", ShBundle.message("check.1124.shellcheck.directives.are.only.valid.in.front.of.complete.commands.like.case.statements.not.individual.case.branches", new Object[0]));
            this.put("SC1126", ShBundle.message("check.1126.place.shellcheck.directives.before.commands.not.after", new Object[0]));
            this.put("SC1127", ShBundle.message("check.1127.was.this.intended.as.a.comment.use.in.sh", new Object[0]));
            this.put("SC1128", ShBundle.message("check.1128.the.shebang.must.be.on.the.first.line.delete.blanks.and.move.comments", new Object[0]));
            this.put("SC1129", ShBundle.message("check.1129.you.need.a.space.before.the", new Object[0]));
            this.put("SC1130", ShBundle.message("check.1130.you.need.a.space.before.the", new Object[0]));
            this.put("SC1131", ShBundle.message("check.1131.use.elif.to.start.another.branch", new Object[0]));
            this.put("SC1132", ShBundle.message("this.terminates.the.command.escape.it.or.add.space.after.to.silence", new Object[0]));
            this.put("SC1133", ShBundle.message("unexpected.start.of.line.if.breaking.lines.should.be.at.the.end.of.the.previous.one", new Object[0]));
            this.put("SC2001", ShBundle.message("sc2001.see.if.you.can.use.variable.search.replace.instead", new Object[0]));
            this.put("SC2002", ShBundle.message("useless.cat.consider.cmd.file.or.cmd.file.instead", new Object[0]));
            this.put("SC2003", ShBundle.message("expr.is.antiquated.consider.rewriting.this.using.or", new Object[0]));
            this.put("SC2004", ShBundle.message("is.unnecessary.on.arithmetic.variables", new Object[0]));
            this.put("SC2005", ShBundle.message("useless.echo.instead.of.echo.cmd.just.use.cmd", new Object[0]));
            this.put("SC2006", ShBundle.message("use.notation.instead.of.legacy.backticked", new Object[0]));
            this.put("SC2007", ShBundle.message("use.instead.of.deprecated", new Object[0]));
            this.put("SC2008", ShBundle.message("echo.doesn.t.read.from.stdin.are.you.sure.you.should.be.piping.to.it", new Object[0]));
            this.put("SC2009", ShBundle.message("sc2009.consider.using.pgrep.instead.of.grepping.ps.output", new Object[0]));
            this.put("SC2010", ShBundle.message("don.t.use.ls.grep.use.a.glob.or.a.for.loop.with.a.condition.to.allow.non.alphanumeric.filenames", new Object[0]));
            this.put("SC2012", ShBundle.message("use.find.instead.of.ls.to.better.handle.non.alphanumeric.filenames", new Object[0]));
            this.put("SC2013", ShBundle.message("to.read.lines.rather.than.words.pipe.redirect.to.a.while.read.loop", new Object[0]));
            this.put("SC2014", ShBundle.message("this.will.expand.once.before.find.runs.not.per.file.found", new Object[0]));
            this.put("SC2015", ShBundle.message("note.that.a.b.c.is.not.if.then.else.c.may.run.when.a.is.true", new Object[0]));
            this.put("SC2016", ShBundle.message("expressions.don.t.expand.in.single.quotes.use.double.quotes.for.that", new Object[0]));
            this.put("SC2017", ShBundle.message("increase.precision.by.replacing.a.b.c.with.a.c.b", new Object[0]));
            this.put("SC2018", ShBundle.message("use.lower.to.support.accents.and.foreign.alphabets", new Object[0]));
            this.put("SC2019", ShBundle.message("use.upper.to.support.accents.and.foreign.alphabets", new Object[0]));
            this.put("SC2020", ShBundle.message("tr.replaces.sets.of.chars.not.words.mentioned.due.to.duplicates", new Object[0]));
            this.put("SC2021", ShBundle.message("don.t.use.around.ranges.in.tr.it.replaces.literal.square.brackets", new Object[0]));
            this.put("SC2022", ShBundle.message("note.that.unlike.globs.o.here.matches.ooo.but.not.oscar", new Object[0]));
            this.put("SC2024", ShBundle.message("sudo.doesn.t.affect.redirects.use.sudo.tee.file", new Object[0]));
            this.put("SC2025", ShBundle.message("make.sure.all.escape.sequences.are.enclosed.in.to.prevent.line.wrapping.issues", new Object[0]));
            this.put("SC2026", ShBundle.message("this.word.is.outside.of.quotes.did.you.intend.to.nest.single.quotes.instead", new Object[0]));
            this.put("SC2027", ShBundle.message("the.surrounding.quotes.actually.unquote.this.remove.or.escape.them", new Object[0]));
            this.put("SC2028", ShBundle.message("echo.won.t.expand.escape.sequences.consider.printf", new Object[0]));
            this.put("SC2029", ShBundle.message("note.that.unescaped.this.expands.on.the.client.side", new Object[0]));
            this.put("SC2030", ShBundle.message("modification.of.var.is.local.to.subshell.caused.by.pipeline", new Object[0]));
            this.put("SC2031", ShBundle.message("var.was.modified.in.a.subshell.that.change.might.be.lost", new Object[0]));
            this.put("SC2032", ShBundle.message("use.own.script.or.sh.c.to.run.this.from.su", new Object[0]));
            this.put("SC2033", ShBundle.message("shell.functions.can.t.be.passed.to.external.commands", new Object[0]));
            this.put("SC2034", ShBundle.message("foo.appears.unused.verify.it.or.export.it", new Object[0]));
            this.put("SC2035", ShBundle.message("use.glob.or.glob.so.names.with.dashes.won.t.become.options", new Object[0]));
            this.put("SC2036", ShBundle.message("if.you.wanted.to.assign.the.output.of.the.pipeline.use.a.b.c", new Object[0]));
            this.put("SC2037", ShBundle.message("to.assign.the.output.of.a.command.use.var.cmd", new Object[0]));
            this.put("SC2038", ShBundle.message("use.print0.0.or.find.exec.to.allow.for.non.alphanumeric.filenames", new Object[0]));
            this.put("SC2039", ShBundle.message("in.posix.sh.something.is.undefined", new Object[0]));
            this.put("SC2040", ShBundle.message("bin.sh.was.specified.so.is.not.supported.even.when.sh.is.actually.bash", new Object[0]));
            this.put("SC2041", ShBundle.message("this.is.a.literal.string.to.run.as.a.command.use.instead.of", new Object[0]));
            this.put("SC2043", ShBundle.message("this.loop.will.only.ever.run.once.for.a.constant.value.did.you.perhaps.mean.to.loop.over.dir.var.or.cmd", new Object[0]));
            this.put("SC2044", ShBundle.message("for.loops.over.find.output.are.fragile.use.find.exec.or.a.while.read.loop", new Object[0]));
            this.put("SC2045", ShBundle.message("iterating.over.ls.output.is.fragile.use.globs", new Object[0]));
            this.put("SC2046", ShBundle.message("quote.this.to.prevent.word.splitting", new Object[0]));
            this.put("SC2048", ShBundle.message("use.with.quotes.to.prevent.whitespace.problems", new Object[0]));
            this.put("SC2049", ShBundle.message("is.for.regex.but.this.looks.like.a.glob.use.instead", new Object[0]));
            this.put("SC2050", ShBundle.message("this.expression.is.constant.did.you.forget.the.on.a.variable", new Object[0]));
            this.put("SC2051", ShBundle.message("bash.doesn.t.support.variables.in.brace.range.expansions", new Object[0]));
            this.put("SC2053", ShBundle.message("quote.the.rhs.of.in.to.prevent.glob.matching", new Object[0]));
            this.put("SC2054", ShBundle.message("use.spaces.not.commas.to.separate.array.elements", new Object[0]));
            this.put("SC2055", ShBundle.message("you.probably.wanted.here", new Object[0]));
            this.put("SC2056", ShBundle.message("you.probably.wanted.here", new Object[0]));
            this.put("SC2057", ShBundle.message("unknown.binary.operator", new Object[0]));
            this.put("SC2058", ShBundle.message("unknown.unaryoperator", new Object[0]));
            this.put("SC2059", ShBundle.message("don.t.use.variables.in.the.printf.format.string.use.printf.s.foo", new Object[0]));
            this.put("SC2060", ShBundle.message("quote.parameters.to.tr.to.prevent.glob.expansion", new Object[0]));
            this.put("SC2061", ShBundle.message("quote.the.parameter.to.name.so.the.shell.won.t.interpret.it", new Object[0]));
            this.put("SC2062", ShBundle.message("quote.the.grep.pattern.so.the.shell.won.t.interpret.it", new Object[0]));
            this.put("SC2063", ShBundle.message("grep.uses.regex.but.this.looks.like.a.glob", new Object[0]));
            this.put("SC2064", ShBundle.message("use.single.quotes.otherwise.this.expands.now.rather.than.when.signalled", new Object[0]));
            this.put("SC2065", ShBundle.message("this.is.interpreted.as.a.shell.file.redirection.not.a.comparison", new Object[0]));
            this.put("SC2066", ShBundle.message("since.you.double.quoted.this.it.will.not.word.split.and.the.loop.will.only.run.once", new Object[0]));
            this.put("SC2067", ShBundle.message("missing.or.terminating.exec.you.can.t.use.and.has.to.be.a.separate.quoted.argument", new Object[0]));
            this.put("SC2068", ShBundle.message("double.quote.array.expansions.to.avoid.re.splitting.elements", new Object[0]));
            this.put("SC2069", ShBundle.message("to.redirect.stdout.stderr.2.1.must.be.last.or.use.cmd.file.2.1.to.clarify", new Object[0]));
            this.put("SC2070", ShBundle.message("n.doesn.t.work.with.unquoted.arguments.quote.or.use", new Object[0]));
            this.put("SC2071", ShBundle.message("is.for.string.comparisons.use.gt.instead", new Object[0]));
            this.put("SC2072", ShBundle.message("decimals.are.not.supported.either.use.integers.only.or.use.bc.or.awk.to.compare", new Object[0]));
            this.put("SC2074", ShBundle.message("can.t.use.in.use.instead", new Object[0]));
            this.put("SC2076", ShBundle.message("don.t.quote.rhs.of.it.ll.match.literally.rather.than.as.a.regex", new Object[0]));
            this.put("SC2077", ShBundle.message("you.need.spaces.around.the.comparison.operator", new Object[0]));
            this.put("SC2078", ShBundle.message("this.expression.is.constant.did.you.forget.a.somewhere", new Object[0]));
            this.put("SC2079", ShBundle.message("doesn.t.support.decimals.use.bc.or.awk", new Object[0]));
            this.put("SC2080", ShBundle.message("numbers.with.leading.0.are.considered.octal", new Object[0]));
            this.put("SC2081", ShBundle.message("can.t.match.globs.use.or.grep", new Object[0]));
            this.put("SC2082", ShBundle.message("to.expand.via.indirection.use.name.foo.n.echo.name", new Object[0]));
            this.put("SC2084", ShBundle.message("remove.or.use.expr.to.avoid.executing.output", new Object[0]));
            this.put("SC2086", ShBundle.message("double.quote.to.prevent.globbing.and.word.splitting", new Object[0]));
            this.put("SC2087", ShBundle.message("quote.eof.to.make.here.document.expansions.happen.on.the.server.side.rather.than.on.the.client", new Object[0]));
            this.put("SC2088", ShBundle.message("tilde.does.not.expand.in.quotes.use.home", new Object[0]));
            this.put("SC2089", ShBundle.message("quotes.backslashes.will.be.treated.literally.use.an.array", new Object[0]));
            this.put("SC2090", ShBundle.message("quotes.backslashes.in.this.variable.will.not.be.respected", new Object[0]));
            this.put("SC2091", ShBundle.message("remove.surrounding.to.avoid.executing.output", new Object[0]));
            this.put("SC2092", ShBundle.message("remove.backticks.to.avoid.executing.output", new Object[0]));
            this.put("SC2093", ShBundle.message("remove.exec.if.script.should.continue.after.this.command", new Object[0]));
            this.put("SC2094", ShBundle.message("sc2094.make.sure.not.to.read.and.write.the.same.file.in.the.same.pipeline", new Object[0]));
            this.put("SC2095", ShBundle.message("add.dev.null.to.prevent.ssh.from.swallowing.stdin", new Object[0]));
            this.put("SC2096", ShBundle.message("on.most.os.shebangs.can.only.specify.a.single.parameter", new Object[0]));
            this.put("SC2097", ShBundle.message("this.assignment.is.only.seen.by.the.forked.process", new Object[0]));
            this.put("SC2098", ShBundle.message("this.expansion.will.not.see.the.mentioned.assignment", new Object[0]));
            this.put("SC2099", ShBundle.message("use.for.arithmetics.e.g.i.i.2", new Object[0]));
            this.put("SC2100", ShBundle.message("use.for.arithmetics.e.g.i.i.2", new Object[0]));
            this.put("SC2101", ShBundle.message("named.class.needs.outer.e.g.digit", new Object[0]));
            this.put("SC2102", ShBundle.message("ranges.can.only.match.single.chars.mentioned.due.to.duplicates", new Object[0]));
            this.put("SC2103", ShBundle.message("use.a.subshell.to.avoid.having.to.cd.back", new Object[0]));
            this.put("SC2104", ShBundle.message("in.functions.use.return.instead.of.break", new Object[0]));
            this.put("SC2105", ShBundle.message("break.is.only.valid.in.loops", new Object[0]));
            this.put("SC2106", ShBundle.message("sc2106.this.only.exits.the.subshell.caused.by.the.pipeline", new Object[0]));
            this.put("SC2107", ShBundle.message("instead.of.a.b.use.a.b2", new Object[0]));
            this.put("SC2108", ShBundle.message("in.use.instead.of.a", new Object[0]));
            this.put("SC2109", ShBundle.message("instead.of.a.b.use.a.b", new Object[0]));
            this.put("SC2110", ShBundle.message("in.use.instead.of.o", new Object[0]));
            this.put("SC2112", ShBundle.message("function.keyword.is.non.standard.delete.it", new Object[0]));
            this.put("SC2114", ShBundle.message("warning.deletes.a.system.directory", new Object[0]));
            this.put("SC2115", ShBundle.message("use.var.to.ensure.this.never.expands.to", new Object[0]));
            this.put("SC2116", ShBundle.message("useless.echo.instead.of.cmd.echo.foo.just.use.cmd.foo", new Object[0]));
            this.put("SC2117", ShBundle.message("to.run.commands.as.another.user.use.su.c.or.sudo", new Object[0]));
            this.put("SC2119", ShBundle.message("use.foo.if.function.s.1.should.mean.script.s.1", new Object[0]));
            this.put("SC2120", ShBundle.message("foo.references.arguments.but.none.are.ever.passed", new Object[0]));
            this.put("SC2121", ShBundle.message("to.assign.a.variable.use.just.var.value.no.set", new Object[0]));
            this.put("SC2122", ShBundle.message("is.not.a.valid.operator.use.a.b.instead", new Object[0]));
            this.put("SC2123", ShBundle.message("path.is.the.shell.search.path.use.another.name", new Object[0]));
            this.put("SC2124", ShBundle.message("assigning.an.array.to.a.string.assign.as.array.or.use.instead.of.to.concatenate", new Object[0]));
            this.put("SC2125", ShBundle.message("brace.expansions.and.globs.are.literal.in.assignments.quote.it.or.use.an.array", new Object[0]));
            this.put("SC2126", ShBundle.message("consider.using.grep.c.instead.of.grep.wc", new Object[0]));
            this.put("SC2128", ShBundle.message("expanding.an.array.without.an.index.only.gives.the.first.element", new Object[0]));
            this.put("SC2129", ShBundle.message("consider.using.cmd1.cmd2.file.instead.of.individual.redirects", new Object[0]));
            this.put("SC2130", ShBundle.message("eq.is.for.integer.comparisons.use.instead", new Object[0]));
            this.put("SC2139", ShBundle.message("this.expands.when.defined.not.when.used.consider.escaping", new Object[0]));
            this.put("SC2140", ShBundle.message("word.is.on.the.form.a.b.c.b.indicated.did.you.mean.abc.or.a.b.c", new Object[0]));
            this.put("SC2141", ShBundle.message("did.you.mean.ifs", new Object[0]));
            this.put("SC2142", ShBundle.message("aliases.can.t.use.positional.parameters.use.a.function", new Object[0]));
            this.put("SC2143", ShBundle.message("use.grep.q.instead.of.comparing.output.with.n", new Object[0]));
            this.put("SC2144", ShBundle.message("e.doesn.t.work.with.globs.use.a.for.loop", new Object[0]));
            this.put("SC2145", ShBundle.message("argument.mixes.string.and.array.use.or.separate.argument", new Object[0]));
            this.put("SC2146", ShBundle.message("this.action.ignores.everything.before.the.o.use.to.group", new Object[0]));
            this.put("SC2147", ShBundle.message("literal.tilde.in.path.works.poorly.across.programs", new Object[0]));
            this.put("SC2148", ShBundle.message("tips.depend.on.target.shell.and.yours.is.unknown.add.a.shebang", new Object[0]));
            this.put("SC2149", ShBundle.message("remove.for.numeric.index.or.escape.it.for.string", new Object[0]));
            this.put("SC2150", ShBundle.message("exec.does.not.automatically.invoke.a.shell.use.exec.sh.c.for.that", new Object[0]));
            this.put("SC2151", ShBundle.message("only.one.integer.0.255.can.be.returned.use.stdout.for.other.data", new Object[0]));
            this.put("SC2152", ShBundle.message("can.only.return.0.255.other.data.should.be.written.to.stdout", new Object[0]));
            this.put("SC2153", ShBundle.message("possible.misspelling.myvariable.may.not.be.assigned.but.my.variable.is", new Object[0]));
            this.put("SC2154", ShBundle.message("var.is.referenced.but.not.assigned", new Object[0]));
            this.put("SC2155", ShBundle.message("declare.and.assign.separately.to.avoid.masking.return.values", new Object[0]));
            this.put("SC2156", ShBundle.message("injecting.filenames.is.fragile.and.insecure.use.parameters", new Object[0]));
            this.put("SC2157", ShBundle.message("argument.to.implicit.n.is.always.true.due.to.literal.strings", new Object[0]));
            this.put("SC2158", ShBundle.message("false.is.true.remove.the.brackets", new Object[0]));
            this.put("SC2159", ShBundle.message("0.is.true.use.false.instead", new Object[0]));
            this.put("SC2160", ShBundle.message("instead.of.true.just.use.true", new Object[0]));
            this.put("SC2161", ShBundle.message("instead.of.1.use.true", new Object[0]));
            this.put("SC2162", ShBundle.message("read.without.r.will.mangle.backslashes", new Object[0]));
            this.put("SC2163", ShBundle.message("this.does.not.export.foo.remove.for.that.or.use.var.to.quiet", new Object[0]));
            this.put("SC2164", ShBundle.message("use.cd.exit.in.case.cd.fails", new Object[0]));
            this.put("SC2165", ShBundle.message("this.nested.loop.overrides.the.index.variable.of.its.parent", new Object[0]));
            this.put("SC2166", ShBundle.message("prefer.p.q.as.p.a.q.is.not.well.defined", new Object[0]));
            this.put("SC2167", ShBundle.message("this.parent.loop.has.its.index.variable.overridden", new Object[0]));
            this.put("SC2168", ShBundle.message("local.is.only.valid.in.functions", new Object[0]));
            this.put("SC2169", ShBundle.message("in.dash.something.is.not.supported", new Object[0]));
            this.put("SC2170", ShBundle.message("numerical.eq.does.not.dereference.in.expand.or.use.string.operator", new Object[0]));
            this.put("SC2172", ShBundle.message("trapping.signals.by.number.is.not.well.defined.prefer.signal.names", new Object[0]));
            this.put("SC2173", ShBundle.message("sigkill.sigstop.can.not.be.trapped", new Object[0]));
            this.put("SC2174", ShBundle.message("when.used.with.p.m.only.applies.to.the.deepest.directory", new Object[0]));
            this.put("SC2175", ShBundle.message("quote.this.invalid.brace.expansion.since.it.should.be.passed.literally.to.eval", new Object[0]));
            this.put("SC2176", ShBundle.message("time.is.undefined.for.pipelines.time.single.stage.or.bash.c.instead", new Object[0]));
            this.put("SC2177", ShBundle.message("time.is.undefined.for.compound.commands.time.sh.c.instead", new Object[0]));
            this.put("SC2178", ShBundle.message("variable.was.used.as.an.array.but.is.now.assigned.a.string", new Object[0]));
            this.put("SC2179", ShBundle.message("use.array.item.to.append.items.to.an.array", new Object[0]));
            this.put("SC2180", ShBundle.message("bash.does.not.support.multidimensional.arrays.use.1d.or.associative.arrays", new Object[0]));
            this.put("SC2181", ShBundle.message("check.exit.code.directly.with.e.g.if.mycmd.not.indirectly.with", new Object[0]));
            this.put("SC2182", ShBundle.message("this.printf.format.string.has.no.variables.other.arguments.are.ignored", new Object[0]));
            this.put("SC2183", ShBundle.message("this.format.string.has.2.variables.but.is.passed.1.arguments", new Object[0]));
            this.put("SC2184", ShBundle.message("quote.arguments.to.unset.so.they.re.not.glob.expanded", new Object[0]));
            this.put("SC2185", ShBundle.message("some.finds.don.t.have.a.default.path.specify.explicitly", new Object[0]));
            this.put("SC2186", ShBundle.message("tempfile.is.deprecated.use.mktemp.instead", new Object[0]));
            this.put("SC2187", ShBundle.message("ash.scripts.will.be.checked.as.dash.add.shellcheck.shell.dash.to.silence", new Object[0]));
            this.put("SC2188", ShBundle.message("this.redirection.doesn.t.have.a.command.move.to.its.command.or.use.true.as.no.op", new Object[0]));
            this.put("SC2189", ShBundle.message("you.can.t.have.between.this.redirection.and.the.command.it.should.apply.to", new Object[0]));
            this.put("SC2190", ShBundle.message("elements.in.associative.arrays.need.index.e.g.array.index.value", new Object[0]));
            this.put("SC2191", ShBundle.message("the.here.is.literal.to.assign.by.index.use.index.value.with.no.spaces.to.keep.as.literal.quote.it", new Object[0]));
            this.put("SC2192", ShBundle.message("this.array.element.has.no.value.remove.spaces.after.or.use.for.empty.string", new Object[0]));
            this.put("SC2193", ShBundle.message("the.arguments.to.this.comparison.can.never.be.equal.make.sure.your.syntax.is.correct", new Object[0]));
            this.put("SC2194", ShBundle.message("this.word.is.constant.did.you.forget.the.on.a.variable", new Object[0]));
            this.put("SC2195", ShBundle.message("this.pattern.will.never.match.the.case.statement.s.word.double.check.them", new Object[0]));
            this.put("SC2196", ShBundle.message("egrep.is.non.standard.and.deprecated.use.grep.e.instead", new Object[0]));
            this.put("SC2197", ShBundle.message("fgrep.is.non.standard.and.deprecated.use.grep.f.instead", new Object[0]));
            this.put("SC2198", ShBundle.message("arrays.don.t.work.as.operands.in.use.a.loop.or.concatenate.with.instead.of", new Object[0]));
            this.put("SC2199", ShBundle.message("arrays.implicitly.concatenate.in.use.a.loop.or.explicit.instead.of", new Object[0]));
            this.put("SC2200", ShBundle.message("brace.expansions.don.t.work.as.operands.in.use.a.loop", new Object[0]));
            this.put("SC2201", ShBundle.message("brace.expansion.doesn.t.happen.in.use.a.loop", new Object[0]));
            this.put("SC2202", ShBundle.message("globs.don.t.work.as.operands.in.use.a.loop", new Object[0]));
            this.put("SC2203", ShBundle.message("globs.are.ignored.in.except.right.of.use.a.loop", new Object[0]));
            this.put("SC2204", ShBundle.message("is.a.subshell.did.you.mean.a.test.expression", new Object[0]));
            this.put("SC2205", ShBundle.message("is.a.subshell.did.you.mean.a.test.expression", new Object[0]));
            this.put("SC2206", ShBundle.message("quote.to.prevent.word.splitting.or.split.robustly.with.mapfile.or.read.a", new Object[0]));
            this.put("SC2207", ShBundle.message("prefer.mapfile.or.read.a.to.split.command.output.or.quote.to.avoid.splitting", new Object[0]));
            this.put("SC2208", ShBundle.message("use.or.quote.arguments.to.v.to.avoid.glob.expansion", new Object[0]));
            this.put("SC2209", ShBundle.message("use.var.command.to.assign.output.or.quote.to.assign.string", new Object[0]));
            this.put("SC2210", ShBundle.message("this.is.a.file.redirection.was.it.supposed.to.be.a.comparison.or.fd.operation", new Object[0]));
            this.put("SC2211", ShBundle.message("this.is.a.glob.used.as.a.command.name.was.it.supposed.to.be.in.array.or.is.it.missing.quoting", new Object[0]));
            this.put("SC2212", ShBundle.message("use.false.instead.of.empty.conditionals", new Object[0]));
            this.put("SC2213", ShBundle.message("getopts.specified.n.but.it.s.not.handled.by.this.case", new Object[0]));
            this.put("SC2214", ShBundle.message("this.case.is.not.specified.by.getopts", new Object[0]));
            this.put("SC2215", ShBundle.message("this.flag.is.used.as.a.command.name.bad.line.break.or.missing", new Object[0]));
            this.put("SC2216", ShBundle.message("piping.to.rm.a.command.that.doesn.t.read.stdin.wrong.command.or.missing.xargs", new Object[0]));
            this.put("SC2217", ShBundle.message("redirecting.to.echo.a.command.that.doesn.t.read.stdin.bad.quoting.or.missing.xargs", new Object[0]));
            this.put("SC2218", ShBundle.message("this.function.is.only.defined.later.move.the.definition.up", new Object[0]));
            this.put("SC2219", ShBundle.message("instead.of.let.expr.prefer.expr", new Object[0]));
            this.put("SC2220", ShBundle.message("invalid.flags.are.not.handled.add.a.case", new Object[0]));
            this.put("SC2221", ShBundle.message("this.pattern.always.overrides.a.later.one", new Object[0]));
            this.put("SC2222", ShBundle.message("this.pattern.never.matches.because.of.a.previous.pattern", new Object[0]));
            this.put("SC2223", ShBundle.message("this.default.assignment.may.cause.dos.due.to.globbing.quote.it", new Object[0]));
            this.put("SC2224", ShBundle.message("this.mv.has.no.destination.check.the.arguments", new Object[0]));
            this.put("SC2225", ShBundle.message("this.cp.has.no.destination.check.the.arguments", new Object[0]));
            this.put("SC2226", ShBundle.message("this.ln.has.no.destination.check.the.arguments.or.specify.explicitly", new Object[0]));
            this.put("SC2227", ShBundle.message("redirection.applies.to.the.find.command.itself.rewrite.to.work.per.action.or.move.to.end", new Object[0]));
            this.put("SC2229", ShBundle.message("this.does.not.read.foo.remove.for.that.or.use.var.to.quiet", new Object[0]));
            this.put("SC2230", ShBundle.message("which.is.non.standard.use.builtin.command.v.instead", new Object[0]));
            this.put("SC2231", ShBundle.message("quote.expansions.in.this.for.loop.glob.to.prevent.wordsplitting.e.g.dir.txt", new Object[0]));
            this.put("SC2232", ShBundle.message("can.t.use.sudo.with.builtins.like.cd.did.you.want.sudo.sh.c.instead", new Object[0]));
            this.put("SC2233", ShBundle.message("remove.superfluous.around.condition", new Object[0]));
            this.put("SC2234", ShBundle.message("remove.superfluous.around.test.command", new Object[0]));
            this.put("SC2235", ShBundle.message("use.instead.of.to.avoid.subshell.overhead", new Object[0]));
            this.put("SC2236", ShBundle.message("use.n.instead.of.z2", new Object[0]));
            this.put("SC2237", ShBundle.message("use.n.instead.of.z", new Object[0]));
            this.put("SC2238", ShBundle.message("redirecting.to.from.command.name.instead.of.file.did.you.want.pipes.xargs.or.quote.to.ignore", new Object[0]));
            this.put("SC2239", ShBundle.message("ensure.the.shebang.uses.the.absolute.path.to.the.interpreter", new Object[0]));
            this.put("SC2240", ShBundle.message("the.dot.command.does.not.support.arguments.in.sh.dash.set.them.as.variables", new Object[0]));
            this.put("SC2241", ShBundle.message("the.exit.status.can.only.be.one.integer.0.255.use.stdout.for.other.data", new Object[0]));
            this.put("SC2242", ShBundle.message("can.only.exit.with.status.0.255.other.data.should.be.written.to.stdout.stderr", new Object[0]));
            this.put("SC2243", ShBundle.message("prefer.explicit.n.to.check.for.output.or.run.command.without.to.check.for.success", new Object[0]));
            this.put("SC2244", ShBundle.message("prefer.explicit.n.to.check.non.empty.string.or.use.ne.to.check.boolean.integer", new Object[0]));
            this.put("SC2245", ShBundle.message("d.only.applies.to.the.first.expansion.of.this.glob.use.a.loop.to.check.any.all", new Object[0]));
            this.put("SC2246", ShBundle.message("this.shebang.specifies.a.directory.ensure.the.interpreter.is.a.file", new Object[0]));
            this.put("SC2247", ShBundle.message("flip.leading.and.if.this.should.be.a.quoted.substitution", new Object[0]));
            this.put("SC2249", ShBundle.message("consider.adding.a.default.case.even.if.it.just.exits.with.error", new Object[0]));
        }
    };

    public static void download(@NotNull Project project, @NotNull Runnable onSuccess, @NotNull Runnable onFailure) {
        if (project == null) {
            ShShellcheckUtil.$$$reportNull$$$0(0);
        }
        if (onSuccess == null) {
            ShShellcheckUtil.$$$reportNull$$$0(1);
        }
        if (onFailure == null) {
            ShShellcheckUtil.$$$reportNull$$$0(2);
        }
        ShShellcheckUtil.download(project, onSuccess, onFailure, false);
    }

    @VisibleForTesting
    @NotNull
    public static String spellcheckBin(@NotNull EelPlatform platform) {
        if (platform == null) {
            ShShellcheckUtil.$$$reportNull$$$0(3);
        }
        return EelPlatformKt.isWindows((EelPlatform)platform) ? "shellcheck.exe" : SHELLCHECK;
    }

    private static void download(final @NotNull Project project, final @NotNull Runnable onSuccess, final @NotNull Runnable onFailure, final boolean withReplace) {
        if (project == null) {
            ShShellcheckUtil.$$$reportNull$$$0(4);
        }
        if (onSuccess == null) {
            ShShellcheckUtil.$$$reportNull$$$0(5);
        }
        if (onFailure == null) {
            ShShellcheckUtil.$$$reportNull$$$0(6);
        }
        Task.Backgroundable task = new Task.Backgroundable(project, ShBundle.message("sh.shellcheck.download.label.text", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                String url;
                EelDescriptor eelDescriptor;
                EelApi eel;
                Path downloadPath;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!Files.exists(downloadPath = ExternalServicesUtil.computeDownloadPath(eel = EelProviderUtil.toEelApiBlocking((EelDescriptor)(eelDescriptor = EelProviderUtil.getEelDescriptor((Project)project)))), new LinkOption[0])) {
                    try {
                        Files.createDirectory(downloadPath, new FileAttribute[0]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                Path shellcheck = downloadPath.resolve(ShShellcheckUtil.spellcheckBin(eel.getPlatform()));
                Path oldShellcheck = downloadPath.resolve("old_" + ShShellcheckUtil.spellcheckBin(eel.getPlatform()));
                if (Files.exists(shellcheck, new LinkOption[0])) {
                    if (withReplace) {
                        boolean successful = ShShellcheckUtil.renameOldShellcheck(shellcheck.toFile(), oldShellcheck.toFile(), onFailure);
                        if (!successful) {
                            return;
                        }
                    } else {
                        ShShellcheckUtil.setupShellcheckPath(project, shellcheck.toFile(), onSuccess, onFailure);
                        return;
                    }
                }
                if (StringUtil.isEmpty((String)(url = ShShellcheckUtil.getShellcheckDistributionLink(eel.getPlatform())))) {
                    LOG.debug("Unsupported OS for shellcheck");
                    return;
                }
                String downloadName = "shellcheck.tar.gz";
                DownloadableFileService service = DownloadableFileService.getInstance();
                DownloadableFileDescription description = service.createFileDescription(url, downloadName);
                FileDownloader downloader = service.createDownloader(Collections.singletonList(description), downloadName);
                try {
                    String path;
                    File file;
                    List pairs = downloader.download(downloadPath.toFile());
                    Pair first = (Pair)ContainerUtil.getFirstItem((List)pairs);
                    File file2 = file = first != null ? (File)first.first : null;
                    if (file != null && Strings.isNotEmpty((String)(path = ShShellcheckUtil.decompressShellcheck(file.toPath(), downloadPath, eel.getPlatform())))) {
                        FileUtil.setExecutable((File)new File(path));
                        ShSettings.setShellcheckPath(project, path);
                        if (withReplace) {
                            LOG.debug("Remove old shellcheck");
                            FileUtil.delete((Path)oldShellcheck);
                        }
                        ApplicationManager.getApplication().invokeLater(onSuccess);
                        ShCounterUsagesCollector.EXTERNAL_ANNOTATOR_DOWNLOADED_EVENT_ID.log();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Can't download shellcheck", (Throwable)e);
                    if (withReplace) {
                        ShShellcheckUtil.rollbackToOldShellcheck(shellcheck.toFile(), oldShellcheck.toFile());
                    }
                    ApplicationManager.getApplication().invokeLater(onFailure);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/sh/shellcheck/ShShellcheckUtil$1", "run"));
            }
        };
        BackgroundableProcessIndicator processIndicator = new BackgroundableProcessIndicator(task);
        processIndicator.setIndeterminate(false);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)processIndicator);
    }

    private static void setupShellcheckPath(@NotNull Project project, @NotNull File shellcheck, @NotNull Runnable onSuccess, @NotNull Runnable onFailure) {
        if (project == null) {
            ShShellcheckUtil.$$$reportNull$$$0(7);
        }
        if (shellcheck == null) {
            ShShellcheckUtil.$$$reportNull$$$0(8);
        }
        if (onSuccess == null) {
            ShShellcheckUtil.$$$reportNull$$$0(9);
        }
        if (onFailure == null) {
            ShShellcheckUtil.$$$reportNull$$$0(10);
        }
        try {
            String path = ShSettings.getShellcheckPath(project);
            String shellcheckPath = shellcheck.getPath();
            if (StringUtil.isNotEmpty((String)path) && path.equals(shellcheckPath)) {
                LOG.debug("Shellcheck already downloaded");
            } else {
                ShSettings.setShellcheckPath(project, shellcheckPath);
            }
            if (!shellcheck.canExecute()) {
                FileUtil.setExecutable((File)shellcheck);
            }
            ApplicationManager.getApplication().invokeLater(onSuccess);
        }
        catch (IOException e) {
            LOG.warn("Can't evaluate shellcheck path or make it executable", (Throwable)e);
            ApplicationManager.getApplication().invokeLater(onFailure);
        }
    }

    private static boolean renameOldShellcheck(@NotNull File shellcheck, @NotNull File oldShellcheck, @NotNull Runnable onFailure) {
        if (shellcheck == null) {
            ShShellcheckUtil.$$$reportNull$$$0(11);
        }
        if (oldShellcheck == null) {
            ShShellcheckUtil.$$$reportNull$$$0(12);
        }
        if (onFailure == null) {
            ShShellcheckUtil.$$$reportNull$$$0(13);
        }
        LOG.info("Rename shellcheck to the temporary filename");
        try {
            FileUtil.rename((File)shellcheck, (File)oldShellcheck);
        }
        catch (IOException e) {
            LOG.info("Can't rename shellcheck to the temporary filename", (Throwable)e);
            ApplicationManager.getApplication().invokeLater(onFailure);
            return false;
        }
        return true;
    }

    private static void rollbackToOldShellcheck(@NotNull File shellcheck, @NotNull File oldShellcheck) {
        if (shellcheck == null) {
            ShShellcheckUtil.$$$reportNull$$$0(14);
        }
        if (oldShellcheck == null) {
            ShShellcheckUtil.$$$reportNull$$$0(15);
        }
        LOG.info("Update failed, rollback");
        try {
            FileUtil.rename((File)oldShellcheck, (File)shellcheck);
        }
        catch (IOException e) {
            LOG.info("Can't rollback shellcheck after failed update", (Throwable)e);
        }
        FileUtil.delete((File)oldShellcheck);
    }

    @VisibleForTesting
    public static boolean isExecutionValidPath(@Nullable String path) {
        if (path == null || ShSettings.I_DO_MIND_SUPPLIER.get().equals(path)) {
            return false;
        }
        File file = new File(path);
        return file.canExecute() && file.getName().contains(SHELLCHECK);
    }

    static boolean isValidPath(@Nullable String path) {
        if (path == null) {
            return false;
        }
        if (ShSettings.I_DO_MIND_SUPPLIER.get().equals(path)) {
            return true;
        }
        File file = new File(path);
        return file.canExecute() && file.getName().contains(SHELLCHECK);
    }

    static void checkShellCheckForUpdate(@NotNull Project project) {
        Application application;
        if (project == null) {
            ShShellcheckUtil.$$$reportNull$$$0(16);
        }
        if ((application = ApplicationManager.getApplication()).getUserData(UPDATE_NOTIFICATION_SHOWN) != null) {
            return;
        }
        application.putUserData(UPDATE_NOTIFICATION_SHOWN, (Object)true);
        if (application.isDispatchThread()) {
            application.executeOnPooledThread(() -> ShShellcheckUtil.checkForUpdateInBackgroundThread(project));
        } else {
            ShShellcheckUtil.checkForUpdateInBackgroundThread(project);
        }
    }

    @RequiresBackgroundThread
    private static void checkForUpdateInBackgroundThread(@NotNull Project project) {
        Pair<String, String> newVersionAvailable;
        if (project == null) {
            ShShellcheckUtil.$$$reportNull$$$0(17);
        }
        if ((newVersionAvailable = ShShellcheckUtil.getVersionUpdate(project)) == null) {
            return;
        }
        String currentVersion = (String)newVersionAvailable.first;
        String newVersion = (String)newVersionAvailable.second;
        Notification notification = ShNotification.NOTIFICATION_GROUP.createNotification(ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.shellcheck.update.question", currentVersion, newVersion), NotificationType.INFORMATION);
        notification.setDisplayId("sh.update.shellcheck");
        notification.setSuggestionType(true);
        notification.addAction((AnAction)NotificationAction.createSimple(ShBundle.messagePointer("sh.update", new Object[0]), () -> {
            notification.expire();
            ShShellcheckUtil.download(project, () -> ShNotification.NOTIFICATION_GROUP.createNotification(ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.shellcheck.success.update", new Object[0]), NotificationType.INFORMATION).setDisplayId("sh.update.shellcheck.success").notify(project), () -> ShNotification.NOTIFICATION_GROUP.createNotification(ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.shellcheck.cannot.update", new Object[0]), NotificationType.ERROR).setDisplayId("sh.update.shellcheck.error").notify(project), true);
        }));
        notification.addAction((AnAction)NotificationAction.createSimple(ShBundle.messagePointer("sh.skip.version", new Object[0]), () -> {
            notification.expire();
            ShSettings.setSkippedShellcheckVersion(SHELLCHECK_VERSION);
        }));
        notification.notify(project);
    }

    private static Pair<String, String> getVersionUpdate(@NotNull Project project) {
        if (project == null) {
            ShShellcheckUtil.$$$reportNull$$$0(18);
        }
        String updateVersion = SHELLCHECK_VERSION;
        SemVer updateVersionVer = SemVer.parseFromText((String)SHELLCHECK_VERSION);
        if (updateVersionVer == null) {
            return null;
        }
        if (ShSettings.getSkippedShellcheckVersion().equals(SHELLCHECK_VERSION)) {
            return null;
        }
        String path = ShSettings.getShellcheckPath(project);
        if (ShSettings.I_DO_MIND_SUPPLIER.get().equals(path)) {
            return null;
        }
        File file = new File(path);
        if (!file.canExecute()) {
            return null;
        }
        if (!file.getName().contains(SHELLCHECK)) {
            return null;
        }
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine().withExePath(path).withParameters(new String[]{"--version"});
            ProcessOutput processOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine, (int)3000);
            String stdout = processOutput.getStdout();
            String current = ShShellcheckUtil.getVersionFromStdOut(stdout);
            if (current == null) {
                current = "unknown";
                return Pair.create((Object)current, (Object)SHELLCHECK_VERSION);
            }
            SemVer currentVersion = SemVer.parseFromText((String)current);
            if (currentVersion == null || updateVersionVer.isGreaterThan(currentVersion)) {
                return Pair.create((Object)current, (Object)SHELLCHECK_VERSION);
            }
            return null;
        }
        catch (ExecutionException e) {
            LOG.debug("Exception in process execution", (Throwable)e);
            return null;
        }
    }

    private static String getVersionFromStdOut(String stdout) {
        String[] lines;
        for (String line : lines = StringUtil.splitByLines((String)stdout)) {
            String prefix;
            if (!(line = line.trim().toLowerCase(Locale.ENGLISH)).contains(prefix = "version:")) continue;
            return line.substring(prefix.length()).trim();
        }
        return null;
    }

    @NotNull
    public static String decompressShellcheck(Path tarPath, Path directory, @NotNull EelPlatform eelPlatform) throws IOException {
        if (eelPlatform == null) {
            ShShellcheckUtil.$$$reportNull$$$0(19);
        }
        new Decompressor.Tar(tarPath).extract(directory);
        NioFiles.deleteRecursively((Path)tarPath);
        File shellcheck = new File(directory.toFile(), ShShellcheckUtil.spellcheckBin(eelPlatform));
        return shellcheck.exists() ? shellcheck.getPath() : "";
    }

    @VisibleForTesting
    @NlsSafe
    @Nullable
    public static String getShellcheckDistributionLink(@NotNull EelPlatform platform) {
        String arch;
        String platformString;
        if (platform == null) {
            ShShellcheckUtil.$$$reportNull$$$0(20);
        }
        String string = EelPlatformKt.isMac((EelPlatform)platform) ? "mac" : (EelPlatformKt.isWindows((EelPlatform)platform) ? "windows" : (platformString = EelPlatformKt.isLinux((EelPlatform)platform) ? "linux" : null));
        if (platformString == null) {
            return null;
        }
        String string2 = arch = EelPlatformKt.isArm64((EelPlatform)platform) ? "arm64" : "amd64";
        if (platformString.equals("windows") && arch.equals("arm64")) {
            return null;
        }
        return "https://cache-redirector.jetbrains.com/intellij-dependencies/org/jetbrains/intellij/deps/shellcheck/shellcheck/0.10.0-1/shellcheck-0.10.0-1-" + platformString + "-" + arch + SHELLCHECK_ARCHIVE_EXTENSION;
    }

    static int calcOffset(CharSequence sequence, int startOffset, int column) {
        int i = 1;
        while (i < column) {
            int c = Character.codePointAt(sequence, startOffset);
            i += c == 9 ? 8 : 1;
            ++startOffset;
        }
        return startOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccess";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFailure";
                break;
            }
            case 3: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = SHELLCHECK;
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldShellcheck";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eelPlatform";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sh/shellcheck/ShShellcheckUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "download";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "spellcheckBin";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "setupShellcheckPath";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "renameOldShellcheck";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "rollbackToOldShellcheck";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "checkShellCheckForUpdate";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForUpdateInBackgroundThread";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "getVersionUpdate";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "decompressShellcheck";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "getShellcheckDistributionLink";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

