/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.CellAttributes;
import org.jetbrains.kotlinx.dataframe.api.DataFrameGetKt;
import org.jetbrains.kotlinx.dataframe.api.FormatClause;
import org.jetbrains.kotlinx.dataframe.api.FormattedFrame;
import org.jetbrains.kotlinx.dataframe.api.FormattingDSL;
import org.jetbrains.kotlinx.dataframe.api.RGBColor;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPathKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\tH\u0000\u001a2\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000eH\u0000\u001a0\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\tH\u0000\u001as\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0017\"\u0004\b\u0000\u0010\u0018\"\u0004\b\u0001\u0010\u0019*\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00190\u001a2C\b\u0004\u0010\u001b\u001a=\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00190\u001f\u0012\u0006\u0012\u0004\u0018\u00010 0\u001cj\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u0019`\"\u00a2\u0006\u0002\b!H\u0080\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006#"}, d2={"encRgb", "", "r", "", "g", "b", "encHex", "v", "encode", "Lorg/jetbrains/kotlinx/dataframe/api/RGBColor;", "componentWise", "color1", "color2", "f", "Lkotlin/Function2;", "linearGradient", "x", "", "minValue", "minColor", "maxValue", "maxColor", "formatImpl", "Lorg/jetbrains/kotlinx/dataframe/api/FormattedFrame;", "T", "C", "Lorg/jetbrains/kotlinx/dataframe/api/FormatClause;", "formatter", "Lkotlin/Function3;", "Lorg/jetbrains/kotlinx/dataframe/api/FormattingDSL;", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/api/CellAttributes;", "Lkotlin/ExtensionFunctionType;", "Lorg/jetbrains/kotlinx/dataframe/api/RowColFormatter;", "core"})
@SourceDebugExtension(value={"SMAP\nformat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 format.kt\norg/jetbrains/kotlinx/dataframe/impl/api/FormatKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1611#2,9:77\n1863#2:86\n1864#2:88\n1620#2:89\n1#3:87\n*S KotlinDebug\n*F\n+ 1 format.kt\norg/jetbrains/kotlinx/dataframe/impl/api/FormatKt\n*L\n57#1:77,9\n57#1:86\n57#1:88\n57#1:89\n57#1:87\n*E\n"})
public final class FormatKt {
    @NotNull
    public static final String encRgb(short r, short g, short b) {
        return '#' + FormatKt.encHex(r) + FormatKt.encHex(g) + FormatKt.encHex(b);
    }

    @NotNull
    public static final String encHex(short v) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Integer.toString(v / 16, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        String string2 = Integer.toString(v % 16, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return stringBuilder2.append(string2).toString();
    }

    @NotNull
    public static final String encode(@NotNull RGBColor $this$encode) {
        Intrinsics.checkNotNullParameter((Object)$this$encode, (String)"<this>");
        return FormatKt.encRgb($this$encode.getR(), $this$encode.getG(), $this$encode.getB());
    }

    @NotNull
    public static final RGBColor componentWise(@NotNull RGBColor color1, @NotNull RGBColor color2, @NotNull Function2<? super Short, ? super Short, Short> f) {
        Intrinsics.checkNotNullParameter((Object)color1, (String)"color1");
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color2");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        return new RGBColor(((Number)f.invoke((Object)color1.getR(), (Object)color2.getR())).shortValue(), ((Number)f.invoke((Object)color1.getG(), (Object)color2.getG())).shortValue(), ((Number)f.invoke((Object)color1.getB(), (Object)color2.getB())).shortValue());
    }

    @NotNull
    public static final RGBColor linearGradient(double x, double minValue, @NotNull RGBColor minColor, double maxValue, @NotNull RGBColor maxColor) {
        Intrinsics.checkNotNullParameter((Object)minColor, (String)"minColor");
        Intrinsics.checkNotNullParameter((Object)maxColor, (String)"maxColor");
        if (x < minValue) {
            return minColor;
        }
        if (x > maxValue) {
            return maxColor;
        }
        double t = (x - minValue) / (maxValue - minValue);
        return FormatKt.componentWise(minColor, maxColor, (Function2<? super Short, ? super Short, Short>)((Function2)(arg_0, arg_1) -> FormatKt.linearGradient$lambda$0(t, arg_0, arg_1)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, C> FormattedFrame<T> formatImpl(@NotNull FormatClause<T, C> $this$formatImpl, @NotNull Function3<? super FormattingDSL, ? super DataRow<? extends T>, ? super DataColumn<? extends C>, ? extends CellAttributes> formatter) {
        Set set;
        Intrinsics.checkNotNullParameter($this$formatImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter(formatter, (String)"formatter");
        boolean $i$f$formatImpl = false;
        if ($this$formatImpl.getColumns$core() != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = DataFrameGetKt.getColumnsWithPaths($this$formatImpl.getDf$core(), $this$formatImpl.getColumns$core());
            boolean $i$f$mapNotNull = false;
            void var6_5 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                ColumnWithPath it = (ColumnWithPath)element$iv$iv;
                boolean bl2 = false;
                if ((ColumnWithPathKt.getDepth(it) == 0 ? it.getName() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else {
            set = null;
        }
        Set columns2 = set;
        return new FormattedFrame<T>($this$formatImpl.getDf$core(), (Function3)new Function3<FormattingDSL, DataRow<? extends T>, DataColumn<?>, CellAttributes>($this$formatImpl, columns2, formatter){
            final /* synthetic */ FormatClause<T, C> $this_formatImpl;
            final /* synthetic */ Set<String> $columns;
            final /* synthetic */ Function3<FormattingDSL, DataRow<? extends T>, DataColumn<? extends C>, CellAttributes> $formatter;
            {
                this.$this_formatImpl = $receiver;
                this.$columns = $columns;
                this.$formatter = $formatter;
            }

            public final CellAttributes invoke(FormattingDSL $this$FormattedFrame, DataRow<? extends T> row, DataColumn<?> col) {
                CellAttributes cellAttributes;
                CellAttributes oldAttributes;
                Intrinsics.checkNotNullParameter((Object)$this$FormattedFrame, (String)"$this$FormattedFrame");
                Intrinsics.checkNotNullParameter(row, (String)"row");
                Intrinsics.checkNotNullParameter(col, (String)"col");
                Function3<FormattingDSL, DataRow<T>, DataColumn<C>, CellAttributes> function3 = this.$this_formatImpl.getOldFormatter$core();
                CellAttributes cellAttributes2 = oldAttributes = function3 != null ? (CellAttributes)function3.invoke((Object)FormattingDSL.INSTANCE, row, CastKt.cast(col)) : null;
                if (this.$columns == null || this.$columns.contains(col.name())) {
                    R value = row.get((ColumnReference)col);
                    cellAttributes = this.$this_formatImpl.getFilter$core() == null || ((Boolean)this.$this_formatImpl.getFilter$core().invoke(row, value)).booleanValue() ? org.jetbrains.kotlinx.dataframe.api.FormatKt.and(oldAttributes, (CellAttributes)this.$formatter.invoke((Object)FormattingDSL.INSTANCE, CastKt.cast(row), CastKt.cast(col))) : oldAttributes;
                } else {
                    cellAttributes = oldAttributes;
                }
                return cellAttributes;
            }
        });
    }

    private static final short linearGradient$lambda$0(double $t, short cmin, short cmax) {
        return (short)((double)cmin + $t * (double)(cmax - cmin));
    }
}

