/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.encrypt.mindmapmode;

import java.awt.event.ActionEvent;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.EnterPasswordDialog;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.menubuilders.generic.UserRole;
import org.freeplane.features.encrypt.EncryptionHelper;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.IEncrypter;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.url.mindmapmode.MFileManager;

class EncryptedMap
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    EncryptedMap() {
        super("EncryptedMap");
    }

    public void actionPerformed(ActionEvent e) {
        this.newEncryptedMap();
    }

    private StringBuilder getUsersPassword() {
        EnterPasswordDialog pwdDialog = new EnterPasswordDialog(UITools.getCurrentFrame(), true);
        pwdDialog.setModal(true);
        pwdDialog.show();
        if (pwdDialog.getResult() == -1) {
            return null;
        }
        StringBuilder password = pwdDialog.getPassword();
        return password;
    }

    private void newEncryptedMap() {
        StringBuilder password = this.getUsersPassword();
        if (password == null) {
            return;
        }
        ModeController modeController = Controller.getCurrentModeController();
        MapModel newMap = MFileManager.getController(modeController).newMapFromDefaultTemplate();
        if (newMap != null) {
            EncryptionModel encryptedMindMapNode;
            NodeModel node = newMap.getRootNode();
            IEncrypter encrypter = EncryptionHelper.createEncrypter((StringBuilder)password);
            try {
                encryptedMindMapNode = new EncryptionModel(node, encrypter);
            }
            catch (Exception e) {
                encrypter.destroy();
                throw e;
            }
            node.addExtension((IExtension)encryptedMindMapNode);
            Controller.getCurrentModeController().getMapController().nodeChanged(node);
        }
    }

    public void afterMapChange(UserRole userRole) {
    }
}

