/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.TypedObject;

public class EnumDataTypeInfo
implements TypedObject<EnumDataTypeTypes> {
    public static final EnumDataTypeInfo EMPTY_ENUM_DATA_TYPE_INFO = new EnumDataTypeInfo(EnumDataTypeTypes.not_enumerated, Collections.emptyList());
    private final EnumDataTypeTypes type;
    private final List<String> enumValues;

    public EnumDataTypeInfo(EnumDataTypeTypes type, List<String> enumValues) {
        this.type = Objects.requireNonNull(type, "No enumeration data-type type provided");
        this.enumValues = new ArrayList<String>((Collection)Objects.requireNonNull(enumValues, "No enum values list provided"));
    }

    public List<String> getEnumValues() {
        return List.copyOf(this.enumValues);
    }

    @Override
    public EnumDataTypeTypes getType() {
        return this.type;
    }

    public String toString() {
        return "EnumDataTypeInfo [" + String.valueOf((Object)this.type) + ", " + String.valueOf(this.enumValues) + "]";
    }

    public static enum EnumDataTypeTypes {
        not_enumerated,
        enumerated_data_type,
        enumerated_column;

    }
}

