/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.pegparser;

import com.oracle.graal.python.pegparser.AbstractParser;
import com.oracle.graal.python.pegparser.ParserCallbacks;
import com.oracle.graal.python.pegparser.sst.ConstantValue;
import com.oracle.graal.python.pegparser.tokenizer.CodePoints;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import com.oracle.graal.python.pegparser.tokenizer.Token;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.graalvm.shadowed.com.ibm.icu.lang.UCharacter;

final class StringParser {
    private static final Map<String, Integer> CONTROL_CHAR_NAMES = new HashMap<String, Integer>(32);
    private static final String UNICODE_ERROR = "(unicode error) 'unicodeescape' codec can't decode bytes in position %d-%d:";
    private static final String ILLEGAL_CHARACTER = "illegal Unicode character";
    private static final String TRAILING_S_IN_STR = "Trailing %s in string";
    private static final String MALFORMED_ERROR = " malformed \\N character escape";
    private static final String TRUNCATED_XXX_ERROR = "truncated \\xXX escape";
    private static final String TRUNCATED_UXXXX_ERROR = "truncated \\uXXXX escape";
    private static final String TRUNCATED_UXXXXXXXX_ERROR = "truncated \\UXXXXXXXX escape";
    private static final String UNKNOWN_UNICODE_ERROR = " unknown Unicode character name";
    private static final String INVALID_ESCAPE = "invalid escape sequence '\\%c'";
    private static final String INVALID_OCTAL_ESCAPE = "invalid octal escape sequence '\\%c%c%c'";
    private static final String INVALID_ESCAPE_AT = "invalid %s escape at position %d";
    private static final String BYTES_ONLY_ASCII = "bytes can only contain ASCII literal characters";

    private StringParser() {
    }

    static ConstantValue parseString(AbstractParser parser, CodePoints cp, Token token) {
        int[] codePoints = cp.getBuffer();
        int s = cp.getOffset();
        boolean bytesmode = false;
        boolean rawmode = false;
        int quote = codePoints[s];
        while (!bytesmode || !rawmode) {
            if (quote == 98 || quote == 66) {
                quote = codePoints[++s];
                bytesmode = true;
                continue;
            }
            if (quote == 117 || quote == 85) {
                quote = codePoints[++s];
                continue;
            }
            if (quote != 114 && quote != 82) break;
            quote = codePoints[++s];
            rawmode = true;
        }
        assert (quote == 39 || quote == 34);
        int len = cp.getLength() - (++s - cp.getOffset());
        assert (len >= 1);
        assert (codePoints[s + --len] == quote) : "last quote char must match the first";
        if (len >= 4 && codePoints[s] == quote && codePoints[s + 1] == quote) assert (codePoints[(s += 2) + (len -= 4)] == quote && codePoints[s + len + 1] == quote) : "invalid ending triple quote";
        if (bytesmode) {
            if (rawmode || StringParser.indexOf(codePoints, s, s + len, 92) == -1) {
                byte[] result = new byte[len];
                for (int i = 0; i < len; ++i) {
                    if (codePoints[s + i] >= 128) {
                        throw parser.raiseSyntaxErrorKnownLocation(token, BYTES_ONLY_ASCII, new Object[0]);
                    }
                    result[i] = (byte)codePoints[s + i];
                }
                return ConstantValue.ofBytes(result);
            }
            return ConstantValue.ofBytes(StringParser.decodeBytesWithEscapes(parser, codePoints, s, len, token));
        }
        return ConstantValue.ofCodePoints(StringParser.decodeString(parser, rawmode, CodePoints.fromBuffer(codePoints, s, len), token));
    }

    static CodePoints decodeString(AbstractParser parser, boolean raw, CodePoints cp, Token token) {
        if (raw) {
            return cp;
        }
        return StringParser.decodeUnicodeWithEscapes(parser, cp, token);
    }

    private static byte[] decodeBytesWithEscapes(AbstractParser parser, int[] codePoints, int sInput, int len, Token token) {
        ByteArrayBuilder writer = new ByteArrayBuilder(len);
        int s = sInput;
        int end = s + len;
        boolean wasInvalidEscapeWarning = false;
        block15: while (s < end) {
            int chr = codePoints[s];
            ++s;
            if (chr != 92) {
                if (chr >= 128) {
                    throw parser.raiseSyntaxErrorKnownLocation(token, BYTES_ONLY_ASCII, new Object[0]);
                }
                writer.append((byte)chr);
                continue;
            }
            if (s == end) {
                throw parser.callbacks.onError(ParserCallbacks.ErrorType.Value, token.sourceRange, TRAILING_S_IN_STR, "\\");
            }
            chr = codePoints[s++];
            switch (chr) {
                case 10: {
                    continue block15;
                }
                case 92: {
                    writer.append(92);
                    continue block15;
                }
                case 39: {
                    writer.append(39);
                    continue block15;
                }
                case 34: {
                    writer.append(34);
                    continue block15;
                }
                case 98: {
                    writer.append(8);
                    continue block15;
                }
                case 102: {
                    writer.append(12);
                    continue block15;
                }
                case 116: {
                    writer.append(9);
                    continue block15;
                }
                case 110: {
                    writer.append(10);
                    continue block15;
                }
                case 114: {
                    writer.append(13);
                    continue block15;
                }
                case 118: {
                    writer.append(11);
                    continue block15;
                }
                case 97: {
                    writer.append(7);
                    continue block15;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    int nextChar;
                    int c = chr - 48;
                    if (s < end && 48 <= (nextChar = codePoints[s]) && nextChar <= 55) {
                        c = (c << 3) + nextChar - 48;
                        if (++s < end && 48 <= (nextChar = codePoints[s]) && nextChar <= 55) {
                            c = (c << 3) + nextChar - 48;
                            ++s;
                        }
                    }
                    if (c > 255 && !wasInvalidEscapeWarning) {
                        wasInvalidEscapeWarning = true;
                        StringParser.warnInvalidEscapeSequence(parser, codePoints, s - 3, token);
                    }
                    writer.append(c);
                    continue block15;
                }
                case 120: {
                    if (s + 1 < end) {
                        int digit1 = Character.digit(codePoints[s], 16);
                        int digit2 = Character.digit(codePoints[s + 1], 16);
                        if (digit1 >= 0 && digit2 >= 0) {
                            writer.append(digit1 << 4 | digit2);
                            s += 2;
                            continue block15;
                        }
                    }
                    throw parser.callbacks.onError(ParserCallbacks.ErrorType.Value, token.sourceRange, INVALID_ESCAPE_AT, "\\x", s - 2 - (end - len));
                }
            }
            if (!wasInvalidEscapeWarning) {
                wasInvalidEscapeWarning = true;
                StringParser.warnInvalidEscapeSequence(parser, codePoints, s - 1, token);
            }
            writer.append(92);
            --s;
        }
        return writer.build();
    }

    private static CodePoints decodeUnicodeWithEscapes(AbstractParser parser, CodePoints cp, Token token) {
        int end;
        int start;
        int[] codePoints = cp.getBuffer();
        int backslashIndex = StringParser.indexOf(codePoints, start = cp.getOffset(), end = start + cp.getLength(), 92);
        if (backslashIndex < 0) {
            return cp;
        }
        CodePoints.Builder sb = new CodePoints.Builder(end - start);
        boolean emittedDeprecationWarning = false;
        int substringStart = start;
        do {
            if (backslashIndex != substringStart) {
                sb.appendCodePoints(codePoints, substringStart, backslashIndex - substringStart);
            }
            if (backslashIndex + 1 < end) {
                substringStart = StringParser.processEscapeSequence(token.sourceRange, parser.callbacks, codePoints, backslashIndex + 1, end, sb);
                if (substringStart != backslashIndex + 1) continue;
                sb.appendCodePoint(92);
                if (emittedDeprecationWarning) continue;
                emittedDeprecationWarning = true;
                StringParser.warnInvalidEscapeSequence(parser, codePoints, substringStart, token);
                continue;
            }
            substringStart = backslashIndex;
            break;
        } while ((backslashIndex = StringParser.indexOf(codePoints, substringStart, end, 92)) >= 0);
        if (substringStart < end) {
            sb.appendCodePoints(codePoints, substringStart, end - substringStart);
        }
        return sb.build();
    }

    private static int processEscapeSequence(SourceRange sourceRange, ParserCallbacks parserCallbacks, int[] codePoints, int startIndex, int end, CodePoints.Builder sb) {
        int cp = codePoints[startIndex];
        int i = startIndex + 1;
        return switch (cp) {
            case 92 -> {
                sb.appendCodePoint(92);
                yield i;
            }
            case 97 -> {
                sb.appendCodePoint(7);
                yield i;
            }
            case 98 -> {
                sb.appendCodePoint(8);
                yield i;
            }
            case 102 -> {
                sb.appendCodePoint(12);
                yield i;
            }
            case 110 -> {
                sb.appendCodePoint(10);
                yield i;
            }
            case 114 -> {
                sb.appendCodePoint(13);
                yield i;
            }
            case 116 -> {
                sb.appendCodePoint(9);
                yield i;
            }
            case 118 -> {
                sb.appendCodePoint(11);
                yield i;
            }
            case 34 -> {
                sb.appendCodePoint(34);
                yield i;
            }
            case 39 -> {
                sb.appendCodePoint(39);
                yield i;
            }
            case 10, 13 -> i;
            case 48, 49, 50, 51, 52, 53, 54, 55 -> {
                int octalValue = cp - 48;
                int v1 = cp = i < end ? codePoints[i] : 0;
                if (cp >= 48 && cp <= 55) {
                    octalValue = octalValue * 8 + cp - 48;
                    int v2 = cp = ++i < end ? codePoints[i] : 0;
                    if (cp >= 48 && cp <= 55) {
                        octalValue = octalValue * 8 + cp - 48;
                    }
                }
                sb.appendCodePoint(octalValue);
                yield ++i;
            }
            case 117 -> {
                int code = StringParser.getHexValue(codePoints, sourceRange, i, end, 4, parserCallbacks);
                if (code < 0) {
                    yield startIndex;
                }
                sb.appendCodePoint(code);
                yield i + 4;
            }
            case 85 -> {
                int code = StringParser.getHexValue(codePoints, sourceRange, i, end, 8, parserCallbacks);
                if (!Character.isValidCodePoint(code)) {
                    throw parserCallbacks.onError(ParserCallbacks.ErrorType.Encoding, sourceRange, String.format("(unicode error) 'unicodeescape' codec can't decode bytes in position %d-%d:illegal Unicode character", i, i + 9));
                }
                sb.appendCodePoint(code);
                yield i + 8;
            }
            case 120 -> {
                int code = StringParser.getHexValue(codePoints, sourceRange, i, end, 2, parserCallbacks);
                if (code < 0) {
                    yield startIndex;
                }
                sb.appendCodePoint(code);
                yield i + 2;
            }
            case 78 -> {
                i = StringParser.doCharacterName(codePoints, sourceRange, sb, i, end, parserCallbacks);
                if (i < 0) {
                    yield startIndex;
                }
                yield i;
            }
            default -> startIndex;
        };
    }

    private static int getHexValue(int[] codePoints, SourceRange sourceRange, int start, int end, int len, ParserCallbacks errorCb) {
        int result = 0;
        for (int index = start; index < start + len; ++index) {
            int digit;
            if (index < end) {
                digit = Character.digit(codePoints[index], 16);
                if (digit == -1) {
                    return StringParser.createTruncatedError(sourceRange, start - 2, index - 1, len, errorCb);
                }
            } else {
                return StringParser.createTruncatedError(sourceRange, start - 2, index - 1, len, errorCb);
            }
            result = result * 16 + digit;
        }
        return result;
    }

    private static int createTruncatedError(SourceRange sourceRange, int startIndex, int endIndex, int len, ParserCallbacks errorCb) {
        String truncatedMessage = null;
        switch (len) {
            case 2: {
                truncatedMessage = TRUNCATED_XXX_ERROR;
                break;
            }
            case 4: {
                truncatedMessage = TRUNCATED_UXXXX_ERROR;
                break;
            }
            case 8: {
                truncatedMessage = TRUNCATED_UXXXXXXXX_ERROR;
            }
        }
        throw errorCb.onError(ParserCallbacks.ErrorType.Encoding, sourceRange, UNICODE_ERROR + truncatedMessage, startIndex, endIndex);
    }

    private static int doCharacterName(int[] codePoints, SourceRange sourceRange, CodePoints.Builder sb, int offset, int end, ParserCallbacks parserCallbacks) {
        if (offset >= end) {
            throw parserCallbacks.onError(ParserCallbacks.ErrorType.Encoding, sourceRange, "(unicode error) 'unicodeescape' codec can't decode bytes in position %d-%d: malformed \\N character escape", offset - 2, offset - 1);
        }
        int ch = codePoints[offset];
        if (ch != 123) {
            throw parserCallbacks.onError(ParserCallbacks.ErrorType.Encoding, sourceRange, "(unicode error) 'unicodeescape' codec can't decode bytes in position %d-%d: malformed \\N character escape", offset - 2, offset - 1);
        }
        int closeIndex = StringParser.indexOf(codePoints, offset + 1, end, 125);
        if (closeIndex == -1) {
            throw parserCallbacks.onError(ParserCallbacks.ErrorType.Encoding, sourceRange, "(unicode error) 'unicodeescape' codec can't decode bytes in position %d-%d: malformed \\N character escape", offset - 2, offset - 1);
        }
        String charName = new String(codePoints, offset + 1, closeIndex - offset - 1).toUpperCase();
        int cp = StringParser.getCodePoint(charName);
        if (cp < 0) {
            throw parserCallbacks.onError(ParserCallbacks.ErrorType.Encoding, sourceRange, "(unicode error) 'unicodeescape' codec can't decode bytes in position %d-%d: unknown Unicode character name", offset - 2, closeIndex);
        }
        sb.appendCodePoint(cp);
        return closeIndex + 1;
    }

    private static int getCodePoint(String charName) {
        int possibleChar = CONTROL_CHAR_NAMES.getOrDefault(charName.toUpperCase(Locale.ROOT), -1);
        if (possibleChar > -1) {
            return possibleChar;
        }
        possibleChar = UCharacter.getCharFromName((String)charName);
        if (possibleChar > -1) {
            return possibleChar;
        }
        possibleChar = UCharacter.getCharFromExtendedName((String)charName);
        if (possibleChar > -1) {
            return possibleChar;
        }
        possibleChar = UCharacter.getCharFromNameAlias((String)charName);
        if (possibleChar > -1) {
            return possibleChar;
        }
        return -1;
    }

    private static void warnInvalidEscapeSequence(AbstractParser parser, int[] codePoints, int firstInvalidEscape, Token token) {
        if (parser.callInvalidRules) {
            return;
        }
        int c = codePoints[firstInvalidEscape];
        if (!(token.type != 62 && token.type != 63 || c != 123 && c != 125)) {
            return;
        }
        boolean octal = 52 <= c && c <= 55;
        ParserCallbacks.WarningType category = parser.featureVersion >= 12 ? ParserCallbacks.WarningType.Syntax : ParserCallbacks.WarningType.Deprecation;
        if (octal) {
            parser.callbacks.onWarning(category, token.sourceRange, INVALID_OCTAL_ESCAPE, c, codePoints[firstInvalidEscape + 1], codePoints[firstInvalidEscape + 2]);
        } else {
            parser.callbacks.onWarning(category, token.sourceRange, INVALID_ESCAPE, c);
        }
    }

    public static int indexOf(int[] codePoints, int start, int end, int cp) {
        for (int i = start; i < end; ++i) {
            if (codePoints[i] != cp) continue;
            return i;
        }
        return -1;
    }

    static {
        CONTROL_CHAR_NAMES.put("NULL", 0);
        CONTROL_CHAR_NAMES.put("START OF HEADING", 1);
        CONTROL_CHAR_NAMES.put("START OF TEXT", 2);
        CONTROL_CHAR_NAMES.put("END OF TEXT", 3);
        CONTROL_CHAR_NAMES.put("END OF TRANSMISSION", 4);
        CONTROL_CHAR_NAMES.put("ENQUIRY", 5);
        CONTROL_CHAR_NAMES.put("ACKNOWLEDGE", 6);
        CONTROL_CHAR_NAMES.put("BELL", 7);
        CONTROL_CHAR_NAMES.put("BACKSPACE", 8);
        CONTROL_CHAR_NAMES.put("CHARACTER TABULATION", 9);
        CONTROL_CHAR_NAMES.put("LINE FEED", 10);
        CONTROL_CHAR_NAMES.put("LINE TABULATION", 11);
        CONTROL_CHAR_NAMES.put("FORM FEED", 12);
        CONTROL_CHAR_NAMES.put("CARRIAGE RETURN", 13);
        CONTROL_CHAR_NAMES.put("SHIFT OUT", 14);
        CONTROL_CHAR_NAMES.put("SHIFT IN", 15);
        CONTROL_CHAR_NAMES.put("DATA LINK ESCAPE", 16);
        CONTROL_CHAR_NAMES.put("DEVICE CONTROL ONE", 17);
        CONTROL_CHAR_NAMES.put("DEVICE CONTROL TWO", 18);
        CONTROL_CHAR_NAMES.put("DEVICE CONTROL THREE", 19);
        CONTROL_CHAR_NAMES.put("DEVICE CONTROL FOUR", 20);
        CONTROL_CHAR_NAMES.put("NEGATIVE ACKNOWLEDGE", 21);
        CONTROL_CHAR_NAMES.put("SYNCHRONOUS IDLE", 22);
        CONTROL_CHAR_NAMES.put("END OF TRANSMISSION BLOCK", 23);
        CONTROL_CHAR_NAMES.put("CANCEL", 24);
        CONTROL_CHAR_NAMES.put("END OF MEDIUM", 25);
        CONTROL_CHAR_NAMES.put("SUBSTITUTE", 26);
        CONTROL_CHAR_NAMES.put("ESCAPE", 27);
        CONTROL_CHAR_NAMES.put("INFORMATION SEPARATOR FOUR", 28);
        CONTROL_CHAR_NAMES.put("INFORMATION SEPARATOR THREE", 29);
        CONTROL_CHAR_NAMES.put("INFORMATION SEPARATOR TWO", 30);
        CONTROL_CHAR_NAMES.put("INFORMATION SEPARATOR ONE", 31);
        CONTROL_CHAR_NAMES.put("BYTE ORDER MARK", 65279);
    }

    private static final class ByteArrayBuilder {
        private byte[] data;
        private int size;

        ByteArrayBuilder(int capacity) {
            this.data = new byte[capacity];
        }

        void append(int item) {
            assert (item >= 0 && item <= 255);
            if (this.size + 1 > this.data.length) {
                this.data = Arrays.copyOf(this.data, Math.max(this.size + 1, this.size * 2));
            }
            this.data[this.size++] = (byte)item;
        }

        byte[] build() {
            return Arrays.copyOf(this.data, this.size);
        }
    }
}

