/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.io.AbstractBufferedIOBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedIOMixinBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.io.BufferedIOMixinBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.io.BufferedIOMixinBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.io.BufferedIONodes;
import com.oracle.graal.python.builtins.modules.io.BufferedIOUtil;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.modules.io.PBuffered;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyErrChainExceptions;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PBufferedReader, PythonBuiltinClassType.PBufferedWriter, PythonBuiltinClassType.PBufferedRandom})
public final class BufferedIOMixinBuiltins
extends AbstractBufferedIOBuiltins {
    public static final TpSlots SLOTS = BufferedIOMixinBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BufferedIOMixinBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static TruffleString repr(VirtualFrame frame, PBuffered self, @Bind Node inliningTarget, @Cached PyObjectLookupAttr lookup, @Cached TypeNodes.GetNameNode getNameNode, @Cached GetClassNode getClassNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isValueError, @Cached PyObjectReprAsTruffleStringNode repr, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode, @Cached PRaiseNode raiseNode) {
            TruffleString typeName = getNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, self));
            Object nameobj = PNone.NO_VALUE;
            try {
                nameobj = lookup.execute((Frame)frame, inliningTarget, self, IONodes.T_NAME);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonErrorType.ValueError, isValueError);
            }
            if (nameobj instanceof PNone) {
                return simpleTruffleStringFormatNode.format("<%s>", typeName);
            }
            if (!PythonContext.get(inliningTarget).reprEnter(self)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.REENTRANT_CALL_INSIDE_S_REPR, typeName);
            }
            try {
                TruffleString name = repr.execute((Frame)frame, inliningTarget, nameobj);
                TruffleString truffleString = simpleTruffleStringFormatNode.format("<%s name=%s>", typeName, name);
                return truffleString;
            }
            finally {
                PythonContext.get(inliningTarget).reprLeave(self);
            }
        }
    }

    @Builtin(name="mode", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ModeNode
    extends AbstractBufferedIOBuiltins.PythonUnaryWithInitErrorBuiltinNode {
        ModeNode() {
        }

        @Specialization(guards={"self.isOK()"})
        static Object doit(VirtualFrame frame, PBuffered self, @Bind Node inliningTarget, @Cached PyObjectGetAttr getAttr) {
            return getAttr.execute((Frame)frame, inliningTarget, self.getRaw(), IONodes.T_MODE);
        }
    }

    @Builtin(name="name", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class NameNode
    extends AbstractBufferedIOBuiltins.PythonUnaryWithInitErrorBuiltinNode {
        NameNode() {
        }

        @Specialization(guards={"self.isOK()"})
        static Object doit(VirtualFrame frame, PBuffered self, @Bind Node inliningTarget, @Cached PyObjectGetAttr getAttr) {
            return getAttr.execute((Frame)frame, inliningTarget, self.getRaw(), IONodes.T_NAME);
        }
    }

    @Builtin(name="closed", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ClosedNode
    extends AbstractBufferedIOBuiltins.PythonUnaryWithInitErrorBuiltinNode {
        ClosedNode() {
        }

        @Specialization(guards={"self.isOK()"})
        static Object doit(VirtualFrame frame, PBuffered self, @Bind Node inliningTarget, @Cached BufferedIONodes.IsClosedNode isClosedNode) {
            return isClosedNode.execute(frame, inliningTarget, self);
        }
    }

    @Builtin(name="_finalizing", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class FinalizingNode
    extends PythonUnaryBuiltinNode {
        FinalizingNode() {
        }

        @Specialization
        static Object doit(PBuffered self) {
            return self.isFinalizing();
        }
    }

    @Builtin(name="raw", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class RawNode
    extends PythonUnaryBuiltinNode {
        RawNode() {
        }

        @Specialization
        static Object doit(PBuffered self) {
            return self.getRaw();
        }
    }

    @Builtin(name="truncate", minNumOfPositionalArgs=1, parameterNames={"$self", "pos"})
    @ArgumentClinic(name="pos", defaultValue="PNone.NONE", useDefaultForNone=true)
    @ImportStatic(value={IONodes.class})
    @GenerateNodeFactory
    static abstract class TruncateNode
    extends AbstractBufferedIOBuiltins.PythonBinaryWithInitErrorClinicBuiltinNode {
        TruncateNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BufferedIOMixinBuiltinsClinicProviders.TruncateNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.isOK()", "self.isWritable()"})
        static Object doit(VirtualFrame frame, PBuffered self, Object pos, @Bind Node inliningTarget, @Cached BufferedIONodes.EnterBufferedNode lock, @Cached(value="create(T_TRUNCATE)") BufferedIONodes.CheckIsClosedNode checkIsClosedNode, @Cached BufferedIONodes.RawTellNode rawTellNode, @Cached BufferedIONodes.FlushAndRewindUnlockedNode flushAndRewindUnlockedNode, @Cached PyObjectCallMethodObjArgs callMethodTruncate) {
            checkIsClosedNode.execute(frame, self);
            try {
                lock.enter(inliningTarget, self);
                flushAndRewindUnlockedNode.execute(frame, inliningTarget, self);
                Object res = callMethodTruncate.execute((Frame)frame, inliningTarget, self.getRaw(), IONodes.T_TRUNCATE, pos);
                rawTellNode.execute(frame, inliningTarget, self);
                Object object = res;
                return object;
            }
            finally {
                BufferedIONodes.EnterBufferedNode.leave(self);
            }
        }

        @Specialization(guards={"self.isOK()", "!self.isWritable()"})
        static Object notWritable(PBuffered self, Object pos, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.IOUnsupportedOperation, IONodes.T_TRUNCATE);
        }
    }

    @Builtin(name="tell", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class TellNode
    extends AbstractBufferedIOBuiltins.PythonUnaryWithInitErrorBuiltinNode {
        TellNode() {
        }

        @Specialization(guards={"self.isOK()"})
        static long doit(VirtualFrame frame, PBuffered self, @Bind Node inliningTarget, @Cached BufferedIONodes.RawTellNode rawTellNode) {
            long pos = rawTellNode.execute(frame, inliningTarget, self);
            return pos -= BufferedIOUtil.rawOffset(self);
        }
    }

    @Builtin(name="seek", minNumOfPositionalArgs=2, parameterNames={"$self", "$offset", "whence"})
    @ArgumentClinic(name="whence", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="BufferedIOUtil.SEEK_SET", useDefaultForNone=true)
    @GenerateNodeFactory
    @ImportStatic(value={IONodes.class})
    static abstract class SeekNode
    extends PythonTernaryClinicBuiltinNode {
        SeekNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BufferedIOMixinBuiltinsClinicProviders.SeekNodeClinicProviderGen.INSTANCE;
        }

        protected static boolean isSupportedWhence(int whence) {
            return whence == 0 || whence == 1 || whence == 2;
        }

        @Specialization(guards={"self.isOK()", "isSupportedWhence(whence)"})
        static long doit(VirtualFrame frame, PBuffered self, Object off, int whence, @Bind Node inliningTarget, @Cached(value="create(T_SEEK)") BufferedIONodes.CheckIsClosedNode checkIsClosedNode, @Cached BufferedIONodes.CheckIsSeekabledNode checkIsSeekabledNode, @Cached BufferedIONodes.AsOffNumberNode asOffNumberNode, @Cached(inline=true) BufferedIONodes.SeekNode seekNode) {
            checkIsClosedNode.execute(frame, self);
            checkIsSeekabledNode.execute(frame, self);
            long pos = asOffNumberNode.execute(frame, inliningTarget, off, PythonBuiltinClassType.TypeError);
            return seekNode.execute(frame, inliningTarget, self, pos, whence);
        }

        @Specialization(guards={"self.isOK()", "!isSupportedWhence(whence)"})
        static Object whenceError(PBuffered self, int off, int whence, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.UNSUPPORTED_WHENCE, whence);
        }

        @Specialization(guards={"!self.isOK()"})
        static Object initError(PBuffered self, int off, int whence, @Bind Node inliningTarget) {
            if (self.isDetached()) {
                throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.IO_STREAM_DETACHED);
            }
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.IO_UNINIT);
        }
    }

    @Builtin(name="_dealloc_warn", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class DeallocWarnNode
    extends PythonBinaryBuiltinNode {
        DeallocWarnNode() {
        }

        @Specialization(guards={"self.isOK()", "self.getRaw() != null"})
        static Object doit(VirtualFrame frame, PBuffered self, Object source, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            callMethod.execute((Frame)frame, inliningTarget, self.getRaw(), IONodes.T__DEALLOC_WARN, source);
            return PNone.NONE;
        }

        @Fallback
        static Object none(Object self, Object source) {
            return PNone.NONE;
        }
    }

    @Builtin(name="isatty", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsAttyNode
    extends AbstractBufferedIOBuiltins.PythonUnaryWithInitErrorBuiltinNode {
        IsAttyNode() {
        }

        @Specialization(guards={"self.isOK()"})
        static Object doit(VirtualFrame frame, PBuffered self, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getRaw(), IONodes.T_ISATTY, new Object[0]);
        }
    }

    @Builtin(name="fileno", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class FileNoNode
    extends AbstractBufferedIOBuiltins.PythonUnaryWithInitErrorBuiltinNode {
        FileNoNode() {
        }

        @Specialization(guards={"self.isOK()"})
        static Object doit(VirtualFrame frame, PBuffered self, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getRaw(), IONodes.T_FILENO, new Object[0]);
        }
    }

    @Builtin(name="seekable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SeekableNode
    extends AbstractBufferedIOBuiltins.PythonUnaryWithInitErrorBuiltinNode {
        SeekableNode() {
        }

        @Specialization(guards={"self.isOK()"})
        static Object doit(VirtualFrame frame, PBuffered self, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getRaw(), IONodes.T_SEEKABLE, new Object[0]);
        }
    }

    @Builtin(name="detach", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class DetachNode
    extends AbstractBufferedIOBuiltins.PythonUnaryWithInitErrorBuiltinNode {
        DetachNode() {
        }

        @Specialization(guards={"self.isOK()"})
        static Object doit(VirtualFrame frame, PBuffered self, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethodFlush) {
            callMethodFlush.execute((Frame)frame, inliningTarget, self, IONodes.T_FLUSH, new Object[0]);
            Object raw = self.getRaw();
            self.clearRaw();
            self.setDetached(true);
            self.setOK(false);
            return raw;
        }
    }

    @Builtin(name="close", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CloseNode
    extends AbstractBufferedIOBuiltins.PythonUnaryWithInitErrorBuiltinNode {
        CloseNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Object close(VirtualFrame frame, Node inliningTarget, PBuffered self, BufferedIONodes.EnterBufferedNode lock, PyObjectCallMethodObjArgs callMethodClose) {
            try {
                lock.enter(inliningTarget, self);
                Object res = callMethodClose.execute((Frame)frame, inliningTarget, self.getRaw(), IONodes.T_CLOSE, new Object[0]);
                if (self.getBuffer() != null) {
                    self.setBuffer(null);
                }
                Object object = res;
                return object;
            }
            finally {
                BufferedIONodes.EnterBufferedNode.leave(self);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.isOK()"})
        static Object doit(VirtualFrame frame, PBuffered self, @Bind Node inliningTarget, @Cached BufferedIONodes.IsClosedNode isClosedNode, @Cached PyObjectCallMethodObjArgs callMethodFlush, @Cached PyObjectCallMethodObjArgs callMethodClose, @Cached PyObjectCallMethodObjArgs callMethodDeallocWarn, @Cached BufferedIONodes.EnterBufferedNode lock, @Cached InlinedConditionProfile profile, @Cached PyErrChainExceptions chainExceptions) {
            try {
                lock.enter(inliningTarget, self);
                if (profile.profile(inliningTarget, isClosedNode.execute(frame, inliningTarget, self))) {
                    PNone pNone = PNone.NONE;
                    return pNone;
                }
                if (self.isFinalizing() && self.getRaw() != null) {
                    callMethodDeallocWarn.execute((Frame)frame, inliningTarget, self.getRaw(), IONodes.T__DEALLOC_WARN, self);
                }
            }
            finally {
                BufferedIONodes.EnterBufferedNode.leave(self);
            }
            try {
                callMethodFlush.execute((Frame)frame, inliningTarget, self, IONodes.T_FLUSH, new Object[0]);
            }
            catch (PException e) {
                try {
                    CloseNode.close(frame, inliningTarget, self, lock, callMethodClose);
                }
                catch (PException ee) {
                    throw chainExceptions.execute(inliningTarget, ee, e);
                }
                throw e;
            }
            return CloseNode.close(frame, inliningTarget, self, lock, callMethodClose);
        }
    }
}

