/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.FaulthandlerModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.FaulthandlerModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyTimeFromObjectNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@CoreFunctions(defineModule="faulthandler")
public final class FaulthandlerModuleBuiltins
extends PythonBuiltins {
    public static final TruffleString T_FAULTHANDLER = PythonUtils.tsLiteral("faulthandler");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return FaulthandlerModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PythonModule module = core.lookupBuiltinModule(T_FAULTHANDLER);
        module.setModuleState(new ModuleState());
    }

    @CompilerDirectives.TruffleBoundary
    private static void dumpTraceback(int fd) {
        ExceptionUtils.printPythonLikeStackTraceNoMessage(FaulthandlerModuleBuiltins.newRawFdPrintWriter(fd), new RuntimeException());
    }

    @CompilerDirectives.TruffleBoundary
    private static void cancelDumpTracebackLater(ModuleState moduleState, PythonContext context) {
        if (moduleState.dumpTracebackLaterThread != null && moduleState.dumpTracebackLaterThread.isAlive()) {
            context.getEnv().submitThreadLocal(new Thread[]{moduleState.dumpTracebackLaterThread}, new ThreadLocalAction(true, false){

                protected void perform(ThreadLocalAction.Access access) {
                    throw new ThreadDeath();
                }
            });
        }
    }

    private static PrintWriter newRawFdPrintWriter(int fd) {
        return new PrintWriter(new RawFdOutputStream(fd), true, StandardCharsets.US_ASCII);
    }

    private static void sleepInterruptibly(Node inliningTarget, long timeoutNs) {
        long deadlineNs = System.nanoTime() + timeoutNs;
        TruffleSafepoint.setBlockedThreadInterruptible((Node)inliningTarget, deadline -> {
            long remainingNs = deadline - System.nanoTime();
            if (remainingNs > 0L) {
                Thread.sleep(remainingNs / 1000000L, (int)(remainingNs % 1000000L));
            }
        }, (Object)deadlineNs);
    }

    private static class ModuleState {
        boolean enabled;
        Thread dumpTracebackLaterThread;

        private ModuleState() {
        }
    }

    private static class RawFdOutputStream
    extends OutputStream {
        private final int fd;

        private RawFdOutputStream(int fd) {
            this.fd = fd;
        }

        @Override
        public void write(byte[] bytes, int off, int len) {
            if (off != 0 || len != bytes.length) {
                bytes = Arrays.copyOfRange(bytes, off, off + len);
            }
            try {
                PosixSupportLibrary.getUncached().write(PythonContext.get(null).getPosixSupport(), this.fd, PosixSupportLibrary.Buffer.wrap(bytes));
            }
            catch (PosixSupportLibrary.PosixException posixException) {
                // empty catch block
            }
        }

        @Override
        public void write(int b) {
            this.write(new byte[]{(byte)b}, 0, 0);
        }
    }

    @Builtin(name="cancel_dump_traceback_later")
    @GenerateNodeFactory
    static abstract class CancelDumpTracebackLaterNode
    extends PythonBuiltinNode {
        CancelDumpTracebackLaterNode() {
        }

        @Specialization
        PNone doit() {
            return PNone.NONE;
        }
    }

    @Builtin(name="is_enabled", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class IsEnabledNode
    extends PythonUnaryBuiltinNode {
        IsEnabledNode() {
        }

        @Specialization
        static boolean doit(PythonModule module) {
            ModuleState moduleState = module.getModuleState(ModuleState.class);
            return moduleState.enabled;
        }
    }

    @Builtin(name="disable", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class DisableNode
    extends PythonUnaryBuiltinNode {
        DisableNode() {
        }

        @Specialization
        static PNone doit(PythonModule module) {
            ModuleState moduleState = module.getModuleState(ModuleState.class);
            moduleState.enabled = false;
            return PNone.NONE;
        }
    }

    @Builtin(name="enable", minNumOfPositionalArgs=1, declaresExplicitSelf=true, parameterNames={"$self", "file", "all_threads"})
    @GenerateNodeFactory
    static abstract class EnableNode
    extends PythonTernaryBuiltinNode {
        EnableNode() {
        }

        @Specialization
        static PNone doit(PythonModule module, Object file, Object allThreads) {
            ModuleState moduleState = module.getModuleState(ModuleState.class);
            moduleState.enabled = true;
            return PNone.NONE;
        }
    }

    @Builtin(name="cancel_dump_traceback_later", declaresExplicitSelf=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CancelDumpTracebackLater
    extends PythonUnaryBuiltinNode {
        CancelDumpTracebackLater() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PNone cancel(PythonModule module) {
            ModuleState moduleState = module.getModuleState(ModuleState.class);
            FaulthandlerModuleBuiltins.cancelDumpTracebackLater(moduleState, PythonContext.get(null));
            return PNone.NONE;
        }
    }

    @Builtin(name="dump_traceback_later", minNumOfPositionalArgs=2, declaresExplicitSelf=true, parameterNames={"$mod", "timeout", "repeat", "file", "exit"})
    @ArgumentsClinic(value={@ArgumentClinic(name="repeat", conversion=ArgumentClinic.ClinicConversion.IntToBoolean, defaultValue="false"), @ArgumentClinic(name="exit", conversion=ArgumentClinic.ClinicConversion.IntToBoolean, defaultValue="false")})
    @GenerateNodeFactory
    static abstract class DumpTracebackLaterNode
    extends PythonClinicBuiltinNode {
        DumpTracebackLaterNode() {
        }

        @Specialization
        static Object dumpLater(VirtualFrame frame, PythonModule module, Object timeoutObj, boolean repeat, Object file, boolean exit, @Bind Node inliningTarget, @Cached PyTimeFromObjectNode pyTimeFromObjectNode, @Cached GetFilenoNode getFilenoNode) {
            long timeoutNs = pyTimeFromObjectNode.fromSeconds(frame, inliningTarget, timeoutObj, PyTimeFromObjectNode.RoundType.TIMEOUT);
            int fd = getFilenoNode.execute(frame, inliningTarget, file);
            DumpTracebackLaterNode.doDumpLater(inliningTarget, module, timeoutNs, repeat, fd, file, exit);
            return PNone.NONE;
        }

        @CompilerDirectives.TruffleBoundary
        private static void doDumpLater(Node inliningTarget, PythonModule module, long timeoutNs, boolean repeat, int fd, Object fileObj, boolean exit) {
            Thread thread;
            PythonContext context = PythonContext.get(null);
            ModuleState moduleState = module.getModuleState(ModuleState.class);
            FaulthandlerModuleBuiltins.cancelDumpTracebackLater(moduleState, context);
            moduleState.dumpTracebackLaterThread = thread = context.getEnv().newTruffleThreadBuilder(() -> {
                do {
                    FaulthandlerModuleBuiltins.sleepInterruptibly(inliningTarget, timeoutNs);
                    long timeoutS = timeoutNs / 1000000000L;
                    FaulthandlerModuleBuiltins.newRawFdPrintWriter(fd).printf("Timeout (%d:%02d:%02d)!%n", timeoutS / 3600L, timeoutS / 60L, timeoutS);
                    try {
                        DumpTracebackNode.dump(context.getLanguage(), context, fd, fileObj, true);
                        if (!exit) continue;
                        FaulthandlerModuleBuiltins.sleepInterruptibly(inliningTarget, 100000000L);
                    }
                    finally {
                        if (exit) {
                            PosixModuleBuiltins.ExitNode.exit(1, inliningTarget);
                        }
                    }
                } while (repeat);
            }).build();
            thread.start();
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return FaulthandlerModuleBuiltinsClinicProviders.DumpTracebackLaterNodeClinicProviderGen.INSTANCE;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class GetFilenoNode
    extends Node {
        GetFilenoNode() {
        }

        public abstract int execute(VirtualFrame var1, Node var2, Object var3);

        @Specialization
        static int fileno(VirtualFrame frame, Node inliningTarget, Object file, @Cached PyObjectGetAttr getAttr, @Cached PyLongCheckNode longCheckNode, @Cached PyLongAsIntNode asIntNode, @Cached PyObjectCallMethodObjArgs callMethod, @Cached PRaiseNode raiseNode) {
            if (file instanceof PNone && (file = getAttr.execute((Frame)frame, inliningTarget, PythonContext.get(inliningTarget).getSysModule(), BuiltinNames.T_STDERR)) == PNone.NONE) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.SYS_STDERR_IS_NONE);
            }
            if (longCheckNode.execute(inliningTarget, file)) {
                int fd = asIntNode.execute((Frame)frame, inliningTarget, file);
                if (fd < 0) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.FILE_IS_NOT_A_VALID_FILE_DESCRIPTOR);
                }
                return fd;
            }
            Object result = callMethod.execute((Frame)frame, inliningTarget, file, IONodes.T_FILENO, new Object[0]);
            int fd = -1;
            if (longCheckNode.execute(inliningTarget, result)) {
                fd = asIntNode.execute((Frame)frame, inliningTarget, result);
            }
            if (fd < 0) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.FILE_FILENO_IS_NOT_A_VALID_FILE_DESCRIPTOR);
            }
            try {
                callMethod.execute((Frame)frame, inliningTarget, file, IONodes.T_FLUSH, new Object[0]);
            }
            catch (AbstractTruffleException abstractTruffleException) {
                // empty catch block
            }
            return fd;
        }
    }

    @Builtin(name="dump_traceback", minNumOfPositionalArgs=0, parameterNames={"file", "all_threads"})
    @ArgumentsClinic(value={@ArgumentClinic(name="file", defaultValue="PNone.NO_VALUE"), @ArgumentClinic(name="all_threads", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")})
    @GenerateNodeFactory
    static abstract class DumpTracebackNode
    extends PythonClinicBuiltinNode {
        DumpTracebackNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        PNone doit(VirtualFrame frame, Object fileObj, boolean allThreads, @Bind Node inliningTarget, @Cached GetFilenoNode getFilenoNode, @Cached(value="createFor($node)") IndirectCallData indirectCallData) {
            int fileno = getFilenoNode.execute(frame, inliningTarget, fileObj);
            PythonContext context = this.getContext();
            PythonLanguage language = context.getLanguage(this);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
            try {
                DumpTracebackNode.dump(language, context, fileno, fileObj, allThreads);
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            }
            TruffleSafepoint.poll((Node)this);
            return PNone.NONE;
        }

        @CompilerDirectives.TruffleBoundary
        static void dump(PythonLanguage language, PythonContext context, final int fd, Object fileObj, boolean allThreads) {
            PrintWriter err = FaulthandlerModuleBuiltins.newRawFdPrintWriter(fd);
            if (allThreads) {
                if (PythonOptions.isPExceptionWithJavaStacktrace(language)) {
                    Thread[] ths = context.getThreads();
                    for (Map.Entry<Thread, StackTraceElement[]> e : Thread.getAllStackTraces().entrySet()) {
                        boolean found = false;
                        for (Thread pyTh : ths) {
                            if (pyTh != e.getKey()) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        err.println();
                        err.println(e.getKey());
                        for (StackTraceElement el : e.getValue()) {
                            err.println(el.toString());
                        }
                    }
                }
                context.getEnv().submitThreadLocal(context.getThreads(), new ThreadLocalAction(true, false){

                    protected void perform(ThreadLocalAction.Access access) {
                        FaulthandlerModuleBuiltins.dumpTraceback(fd);
                    }
                });
            } else {
                if (PythonOptions.isPExceptionWithJavaStacktrace(language)) {
                    err.println();
                    err.println(Thread.currentThread());
                    for (StackTraceElement el : Thread.currentThread().getStackTrace()) {
                        err.println(el);
                    }
                }
                FaulthandlerModuleBuiltins.dumpTraceback(fd);
            }
            Reference.reachabilityFence(fileObj);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return FaulthandlerModuleBuiltinsClinicProviders.DumpTracebackNodeClinicProviderGen.INSTANCE;
        }
    }
}

