/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.ForwardOnlyResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class OracleReturnResultSet
extends ForwardOnlyResultSet {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    OracleReturnResultSet(PhysicalConnection conn, OracleStatement stmt) throws SQLException {
        super(conn, stmt);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$3, null, conn, stmt);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$3, null);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$3, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$0, this, new Object[0]);
                    }
                    lock = this.statement.connection.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        super.close();
                        this.statement.currentResultSet = null;
                        this.statement.returnParamsFetched = false;
                        this.statement.rowsDmlReturned = 0;
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$0, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$0, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$0, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            AutoKeyInfo autoKeyInfo;
            block24: {
                Monitor.CloseableLock lock;
                block25: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$1, this, new Object[0]);
                    }
                    lock = this.statement.connection.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        if (!this.statement.isAutoGeneratedKey) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$1, this, sQLException);
                            }
                            throw sQLException;
                        }
                        if (this.closed) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$1, this, sQLException);
                            }
                            throw sQLException;
                        }
                        if (this.statement.closed) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$1, this, sQLException);
                            }
                            throw sQLException;
                        }
                        AutoKeyInfo info = this.statement.autoKeyInfo;
                        info.statement = this.statement;
                        info.connection = this.connection;
                        info.initMetaData(this);
                        autoKeyInfo = info;
                        if (lock == null) break block24;
                        if (throwable == null) break block25;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$1, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$1, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block24;
                }
                lock.close();
            }
            AutoKeyInfo autoKeyInfo2 = autoKeyInfo;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$1, this, autoKeyInfo2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$1, this, null);
            }
            return autoKeyInfo2;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$1, this, throwable8);
            }
            throw throwable;
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$2, this, string);
            }
            Monitor.CloseableLock lock = this.statement.connection.acquireCloseableLock();
            Throwable throwable = null;
            try {
                try {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$2, this, sQLException);
                    }
                    throw sQLException;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    Throwable throwable3 = throwable2;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$2, this, throwable3);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (lock != null) {
                    if (throwable != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        lock.close();
                    }
                }
                Throwable throwable6 = throwable4;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$2, this, throwable6);
                }
                throw throwable6;
            }
        }
        catch (Throwable throwable) {
            Throwable throwable7 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleReturnResultSet.class, $$$methodRef$$$2, this, throwable7);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$3 = OracleReturnResultSet.class.getDeclaredConstructor(PhysicalConnection.class, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleReturnResultSet.class.getDeclaredMethod("findColumn", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleReturnResultSet.class.getDeclaredMethod("getMetaData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleReturnResultSet.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

