/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.community.helpersLocator.PythonHelpersLocator;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFinallyPart;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyTupleExpression;
import java.io.CharArrayWriter;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class UnsupportedFeaturesUtil {
    public static final Map<LanguageLevel, Set<String>> BUILTINS = new HashMap<LanguageLevel, Set<String>>();
    public static final Map<LanguageLevel, Set<String>> MODULES = new HashMap<LanguageLevel, Set<String>>();
    public static final Map<String, Map<LanguageLevel, Set<String>>> CLASS_METHODS = new HashMap<String, Map<LanguageLevel, Set<String>>>();

    private static void fillTestCaseMethods() throws IOException {
        Logger log = Logger.getInstance((String)UnsupportedFeaturesUtil.class.getName());
        try (FileReader reader = new FileReader(PythonHelpersLocator.findPathStringInHelpers("/tools/class_method_versions.xml"), StandardCharsets.UTF_8);){
            XMLReader xr = XMLReaderFactory.createXMLReader();
            ClassMethodsParser parser = new ClassMethodsParser();
            xr.setContentHandler(parser);
            xr.parse(new InputSource(reader));
        }
        catch (SAXException e) {
            log.error("Improperly formed \"class_method_versions.xml\". " + e.getMessage());
        }
    }

    private static void fillMaps() throws IOException {
        Logger log = Logger.getInstance((String)UnsupportedFeaturesUtil.class.getName());
        try (FileReader reader = new FileReader(PythonHelpersLocator.findPathStringInHelpers("/tools/versions.xml"), StandardCharsets.UTF_8);){
            XMLReader xr = XMLReaderFactory.createXMLReader();
            VersionsParser parser = new VersionsParser();
            xr.setContentHandler(parser);
            xr.parse(new InputSource(reader));
        }
        catch (SAXException e) {
            log.error("Improperly formed \"versions.xml\". " + e.getMessage());
        }
    }

    public static boolean raiseHasNoArgsUnderFinally(@NotNull PyRaiseStatement node, @NotNull LanguageLevel versionToProcess) {
        if (node == null) {
            UnsupportedFeaturesUtil.$$$reportNull$$$0(0);
        }
        if (versionToProcess == null) {
            UnsupportedFeaturesUtil.$$$reportNull$$$0(1);
        }
        return node.getExpressions().length == 0 && versionToProcess.isPython2() && PsiTreeUtil.getParentOfType((PsiElement)node, PyFinallyPart.class, (boolean)true, (Class[])new Class[]{PyExceptPart.class}) != null;
    }

    public static boolean raiseHasMoreThenOneArg(PyRaiseStatement node, LanguageLevel versionToProcess) {
        PyExpression[] expressions = node.getExpressions();
        if (expressions.length > 0) {
            if (expressions.length < 2) {
                return false;
            }
            if (versionToProcess.isPy3K()) {
                if (expressions.length == 3) {
                    return true;
                }
                PsiElement element = expressions[0].getNextSibling();
                while (element instanceof PsiWhiteSpace) {
                    element = element.getNextSibling();
                }
                if (element != null && ",".equals(element.getText())) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean raiseHasFromKeyword(PyRaiseStatement node, LanguageLevel versionToProcess) {
        PyExpression[] expressions = node.getExpressions();
        if (expressions.length > 0) {
            if (expressions.length < 2) {
                return false;
            }
            if (versionToProcess.isPython2()) {
                PsiElement element = expressions[0].getNextSibling();
                while (element instanceof PsiWhiteSpace) {
                    element = element.getNextSibling();
                }
                if (element != null && element.getNode().getElementType() == PyTokenTypes.FROM_KEYWORD) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean listComprehensionIteratesOverNonParenthesizedTuple(@NotNull PyListCompExpression node, @NotNull LanguageLevel versionToProcess) {
        if (node == null) {
            UnsupportedFeaturesUtil.$$$reportNull$$$0(2);
        }
        if (versionToProcess == null) {
            UnsupportedFeaturesUtil.$$$reportNull$$$0(3);
        }
        if (versionToProcess.isPy3K()) {
            for (PyComprehensionForComponent forComponent : node.getForComponents()) {
                PyExpression iteratedList = (PyExpression)forComponent.getIteratedList();
                if (!(iteratedList instanceof PyTupleExpression)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        try {
            UnsupportedFeaturesUtil.fillMaps();
            UnsupportedFeaturesUtil.fillTestCaseMethods();
        }
        catch (IOException e) {
            Logger log = Logger.getInstance((String)UnsupportedFeaturesUtil.class.getName());
            log.error("Cannot find \"versions.xml\". " + e.getMessage());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionToProcess";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/UnsupportedFeaturesUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "raiseHasNoArgsUnderFinally";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "listComprehensionIteratesOverNonParenthesizedTuple";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ClassMethodsParser
    extends DefaultHandler {
        private final CharArrayWriter myContent = new CharArrayWriter();
        private String myClassName = "";
        private LanguageLevel myCurrentLevel;

        ClassMethodsParser() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
            this.myContent.reset();
            if (localName.equals("class_name")) {
                this.myClassName = attr.getValue("name");
                if (!CLASS_METHODS.containsKey(this.myClassName)) {
                    CLASS_METHODS.put(this.myClassName, new HashMap());
                }
            }
            if (localName.equals("python")) {
                Map<LanguageLevel, Set<String>> map2;
                this.myCurrentLevel = LanguageLevel.fromPythonVersion(attr.getValue("version"));
                if (this.myClassName != null && (map2 = CLASS_METHODS.get(this.myClassName)) != null) {
                    map2.put(this.myCurrentLevel, new HashSet());
                }
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            Set<String> set;
            Map<LanguageLevel, Set<String>> levelSetMap;
            if (localName.equals("func") && (levelSetMap = CLASS_METHODS.get(this.myClassName)) != null && (set = levelSetMap.get((Object)this.myCurrentLevel)) != null) {
                set.add(this.myContent.toString());
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.myContent.write(ch, start, length);
        }
    }

    private static class VersionsParser
    extends DefaultHandler {
        private final CharArrayWriter myContent = new CharArrayWriter();
        private LanguageLevel myCurrentLevel;

        private VersionsParser() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
            this.myContent.reset();
            if (localName.equals("python")) {
                BUILTINS.put(LanguageLevel.fromPythonVersion(attr.getValue("version")), new HashSet());
                MODULES.put(LanguageLevel.fromPythonVersion(attr.getValue("version")), new HashSet());
                this.myCurrentLevel = LanguageLevel.fromPythonVersion(attr.getValue("version"));
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (localName.equals("func")) {
                BUILTINS.get((Object)this.myCurrentLevel).add(this.myContent.toString());
            }
            if (localName.equals("module")) {
                MODULES.get((Object)this.myCurrentLevel).add(this.myContent.toString());
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.myContent.write(ch, start, length);
        }
    }
}

