/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.query;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.client.hotrod.impl.query.RemoteQuery;
import org.infinispan.commons.api.query.Query;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.query.dsl.QueryResult;

public final class QueryHelper {
    public static final Function<Object[], Long> SINGLE_PROJECTION_TO_LONG = projection -> {
        assert (((Object[])projection).length == 1);
        return (long)((Long)projection[0]);
    };
    public static final Function<Object[], String> SINGLE_PROJECTION_TO_STRING = projection -> {
        assert (((Object[])projection).length == 1);
        return String.valueOf(projection[0]);
    };
    public static final Function<Object[], Map.Entry<String, Long>> PROJECTION_TO_STRING_LONG_ENTRY = projection -> {
        assert (((Object[])projection).length == 2);
        return Map.entry((String)projection[0], Long.valueOf((Long)projection[1]));
    };

    private QueryHelper() {
    }

    public static <T, R> Optional<R> fetchSingle(Query<T> query, Function<T, R> mapping) {
        query.hitCountAccuracy(1).maxResults(1);
        try (CloseableIterator iterator = query.iterator();){
            Optional optional = iterator.hasNext() ? Optional.ofNullable(mapping.apply(iterator.next())) : Optional.empty();
            return optional;
        }
    }

    public static <T, R> Stream<R> streamAll(Query<T> query, int batchSize, Function<T, R> mapping) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new BatchingIterator<T, R>(query, batchSize, mapping), 0), false);
    }

    public static <T, R> Collection<R> toCollection(Query<T> query, Function<T, R> mapping) {
        try (CloseableIterator iterator = query.iterator();){
            Collection collection = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false).map(mapping).collect(Collectors.toList());
            return collection;
        }
    }

    private static class BatchingIterator<T, R>
    implements Iterator<R> {
        private final RemoteQuery<T> query;
        private final int batchSize;
        private final Function<T, R> mapping;
        private int currentOffset;
        private Iterator<T> currentResults;
        private CompletableFuture<QueryResult<T>> nextResults;
        private R next;
        private boolean completed;

        private BatchingIterator(Query<T> query, int batchSize, Function<T, R> mapping) {
            assert (query instanceof RemoteQuery);
            this.query = (RemoteQuery)query.startOffset(0L).hitCountAccuracy(batchSize).maxResults(batchSize);
            this.batchSize = batchSize;
            this.mapping = mapping;
            this.currentResults = Collections.emptyIterator();
            this.executeQueryAsync();
            this.fetchNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public R next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            R result = this.next;
            this.fetchNext();
            return result;
        }

        private void executeQueryAsync() {
            this.nextResults = this.query.executeAsync().toCompletableFuture();
        }

        private void fetchNext() {
            while (true) {
                if (this.currentResults.hasNext()) {
                    this.next = this.mapping.apply(this.currentResults.next());
                    if (this.next == null) continue;
                    return;
                }
                if (this.completed) {
                    this.next = null;
                    return;
                }
                this.useNextResultsAndRequestMore();
            }
        }

        private void useNextResultsAndRequestMore() {
            QueryResult<T> rsp = this.nextResults.join();
            List resultList = rsp.list();
            if (resultList.isEmpty()) {
                this.completed = true;
                return;
            }
            this.currentResults = resultList.iterator();
            if (resultList.size() < this.batchSize) {
                this.completed = true;
                return;
            }
            this.currentOffset += resultList.size();
            if (rsp.count().isExact() && this.currentOffset >= rsp.count().value()) {
                this.completed = true;
                return;
            }
            this.query.startOffset((long)this.currentOffset);
            this.executeQueryAsync();
        }
    }
}

