/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.function.Supplier;
import org.hibernate.MappingException;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.List;
import org.hibernate.mapping.MappingHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.ArrayType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.PrimitiveJavaType;
import org.hibernate.usertype.UserCollectionType;

public class Array
extends List {
    private String elementClassName;

    public Array(MetadataBuildingContext buildingContext, PersistentClass owner) {
        super(buildingContext, owner);
    }

    public Array(Supplier<ManagedBean<? extends UserCollectionType>> customTypeBeanResolver, PersistentClass owner, MetadataBuildingContext buildingContext) {
        super(customTypeBeanResolver, owner, buildingContext);
    }

    protected Array(Array original) {
        super(original);
        this.elementClassName = original.elementClassName;
    }

    @Override
    public Array copy() {
        return new Array(this);
    }

    public Class<?> getElementClass() throws MappingException {
        if (this.elementClassName == null) {
            Type elementType = this.getElement().getType();
            if (this.isPrimitiveArray()) {
                JavaType javaTypeDescriptor = ((BasicType)elementType).getJavaTypeDescriptor();
                return ((PrimitiveJavaType)javaTypeDescriptor).getPrimitiveClass();
            }
            return elementType.getReturnedClass();
        }
        try {
            return MappingHelper.classForName(this.elementClassName, this.getBuildingContext().getBootstrapContext());
        }
        catch (ClassLoadingException e) {
            throw new MappingException((Throwable)((Object)e));
        }
    }

    @Override
    public CollectionType getDefaultCollectionType() {
        return new ArrayType(this.getRole(), this.getReferencedPropertyName(), this.getElementClass());
    }

    @Override
    public boolean isArray() {
        return true;
    }

    public String getElementClassName() {
        return this.elementClassName;
    }

    public void setElementClassName(String elementClassName) {
        this.elementClassName = elementClassName;
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }
}

