/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm.authorization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.keycloak.representations.idm.authorization.ResourceType;

public class AuthorizationSchema {
    @JsonDeserialize(using=ResourceTypeDeserializer.class)
    private final Map<String, ResourceType> resourceTypes;

    @JsonCreator
    public AuthorizationSchema(@JsonProperty(value="resourceTypes") Map<String, ResourceType> resourceTypes) {
        this.resourceTypes = resourceTypes;
    }

    public Map<String, ResourceType> getResourceTypes() {
        return Collections.unmodifiableMap(this.resourceTypes);
    }

    public static class ResourceTypeDeserializer
    extends JsonDeserializer<Map<String, ResourceType>> {
        @Override
        public Map<String, ResourceType> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            if (parser.isExpectedStartArrayToken()) {
                List resourceTypeList = (List)parser.readValueAs(new TypeReference<List<ResourceType>>(){});
                return resourceTypeList.stream().collect(Collectors.toMap(ResourceType::getType, Function.identity()));
            }
            if (parser.isExpectedStartObjectToken()) {
                return (Map)parser.readValueAs(new TypeReference<Map<String, ResourceType>>(){});
            }
            throw JsonMappingException.from(parser, "Expected an array or object for resourceTypes");
        }
    }
}

