/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.distance;

import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.Bearing;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.distance.BearingDescriber;
import tim.prune.function.distance.GenericTableModel;

public class DistanceTableModel
extends GenericTableModel {
    private double[] _distances = null;
    private String[] _bearings = null;
    private static final String _toColLabel = I18nManager.getText("dialog.distances.column.to");
    private String _distanceLabel = null;
    private final String _bearingLabel;
    private Unit _previousDistUnit = null;
    private BearingDescriber _bearingDescriber = new BearingDescriber();

    public DistanceTableModel() {
        this._bearingLabel = I18nManager.getText("fieldname.bearing");
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.getPointName(n);
        }
        if (n2 == 1) {
            return this._distances == null ? 0.0 : this._distances[n];
        }
        return this._bearings == null ? "" : this._bearings[n];
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return _toColLabel;
        }
        if (n == 1) {
            return this._distanceLabel;
        }
        return this._bearingLabel;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0 || n == 2) {
            return String.class;
        }
        return Double.class;
    }

    public void recalculate(int n, Config config) {
        Unit unit = config.getUnitSet().getDistanceUnit();
        this._distanceLabel = String.valueOf(I18nManager.getText("fieldname.distance")) + " (" + I18nManager.getText(unit.getShortnameKey()) + ")";
        boolean bl = unit != this._previousDistUnit;
        this._previousDistUnit = unit;
        int n2 = this.getRowCount();
        if (this._distances == null || this._distances.length != n2) {
            this._distances = new double[n2];
        }
        if (this._bearings == null || this._bearings.length != n2) {
            this._bearings = new String[n2];
        }
        DataPoint dataPoint = (DataPoint)this._pointList.get(n);
        int n3 = 0;
        while (n3 < n2) {
            if (n3 == n) {
                this._distances[n3] = 0.0;
                this._bearings[n3] = "";
            } else {
                DataPoint dataPoint2 = (DataPoint)this._pointList.get(n3);
                double d = DataPoint.calculateRadiansBetween(dataPoint, dataPoint2);
                this._distances[n3] = Distance.convertRadiansToDistance(d, unit);
                if (Distance.convertRadiansToDistance(d, UnitSetLibrary.UNITS_METRES) < 20.0) {
                    this._bearings[n3] = "";
                } else {
                    double d2 = Bearing.calculateDegrees(dataPoint, dataPoint2);
                    this._bearings[n3] = this._bearingDescriber.describeBearing(d2);
                }
            }
            ++n3;
        }
        if (bl) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }
}

