/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.model;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.gef.EditPart;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.erd.ERDObject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructContainer;
import org.jkiss.dbeaver.ui.editors.erd.model.EntityDiagram;
import org.jkiss.dbeaver.ui.editors.erd.part.DiagramPart;

public class ERDObjectAdapter
implements IAdapterFactory {
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        Object model;
        if (DBNNode.class == adapterType) {
            boolean unwrapParentNode = false;
            Object object = ((EditPart)adaptableObject).getModel();
            if (object instanceof EntityDiagram) {
                EntityDiagram diagram = (EntityDiagram)object;
                if (ERDObjectAdapter.isEntityContainerUnique(diagram)) {
                    if (!diagram.getEntities().isEmpty()) {
                        object = diagram.getEntities().get(0);
                    } else if (diagram.getRootObjectContainer() != null) {
                        object = diagram.getRootObjectContainer();
                    }
                }
                unwrapParentNode = true;
            }
            if (object instanceof ERDObject && (object = ((ERDObject)object).getObject()) instanceof DBSObject && adaptableObject instanceof DiagramPart && ((DBSObject)object).getParentObject() instanceof DBSStructContainer) {
                object = ((DBSObject)object).getParentObject();
            }
            if (object instanceof DBSObject) {
                DBNDatabaseNode node = DBNUtils.getNodeByObject((DBSObject)((DBSObject)object));
                if (node instanceof DBNDatabaseItem && node.getObject() instanceof DBSStructContainer) {
                    node = this.getItemsFolderNode(node);
                } else if (node != null && node.getParentNode() instanceof DBNDatabaseNode && unwrapParentNode) {
                    node = (DBNDatabaseNode)node.getParentNode();
                }
                if (node != null) {
                    return adapterType.cast(node);
                }
            }
        } else if (DBPObject.class.isAssignableFrom(adapterType)) {
            if (adaptableObject instanceof EditPart) {
                Object object;
                Object model2 = ((EditPart)adaptableObject).getModel();
                if (model2 != null && adapterType.isAssignableFrom(model2.getClass())) {
                    return adapterType.cast(model2);
                }
                if (model2 instanceof ERDObject && (object = ((ERDObject)model2).getObject()) != null && adapterType.isAssignableFrom(object.getClass())) {
                    return adapterType.cast(object);
                }
            }
        } else if (DBPPropertySource.class.isAssignableFrom(adapterType) && adaptableObject instanceof EditPart && (model = ((EditPart)adaptableObject).getModel()) instanceof ERDObject) {
            return (T)((ERDObject)model).getAdapter(adapterType);
        }
        return null;
    }

    private static boolean isEntityContainerUnique(@NotNull EntityDiagram diagram) {
        if (diagram.getDataSources().size() == 1) {
            DBPDataSourceContainer dataSourceContainer = (DBPDataSourceContainer)diagram.getDataSources().iterator().next();
            Collection objectContainers = diagram.getObjectContainers(dataSourceContainer);
            return objectContainers != null && objectContainers.size() == 1;
        }
        return diagram.getRootObjectContainer() != null;
    }

    private DBNDatabaseNode getItemsFolderNode(DBNDatabaseNode node) {
        block2: for (DBXTreeNode childFolderMeta : node.getMeta().getChildren((DBNNode)node)) {
            String itemPropName;
            DBXTreeNode itemMeta;
            List childItems;
            if (!(childFolderMeta instanceof DBXTreeFolder) || (childItems = childFolderMeta.getChildren((DBNNode)node)).isEmpty() || !((itemMeta = (DBXTreeNode)childItems.get(0)) instanceof DBXTreeItem) || !(itemPropName = ((DBXTreeItem)itemMeta).getPropertyName()).contains("table") && !itemPropName.contains("collection")) continue;
            try {
                DBNDatabaseNode[] nodeChildren = node.getChildren((DBRProgressMonitor)new VoidProgressMonitor());
                if (nodeChildren == null) break;
                DBNDatabaseNode[] dBNDatabaseNodeArray = nodeChildren;
                int n = nodeChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    DBNDatabaseNode navFolder = dBNDatabaseNodeArray[n2];
                    if (navFolder.getMeta() == childFolderMeta) {
                        node = navFolder;
                        break block2;
                    }
                    ++n2;
                }
            }
            catch (DBException dBException) {}
            break;
        }
        return node;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{ERDObject.class, DBPNamedObject.class, DBPQualifiedObject.class, DBSObject.class, DBNNode.class};
    }
}

