﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/wisdom/ConnectWisdomService_EXPORTS.h>

namespace Aws {
namespace ConnectWisdomService {
namespace Model {
enum class ImportJobType { NOT_SET, QUICK_RESPONSES };

namespace ImportJobTypeMapper {
AWS_CONNECTWISDOMSERVICE_API ImportJobType GetImportJobTypeForName(const Aws::String& name);

AWS_CONNECTWISDOMSERVICE_API Aws::String GetNameForImportJobType(ImportJobType value);
}  // namespace ImportJobTypeMapper
}  // namespace Model
}  // namespace ConnectWisdomService
}  // namespace Aws
